/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.attribute;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;

public abstract class AbstractAttributeSpinnerPanel<T, S>
extends JPanel {
    private static final long serialVersionUID = 8676365412572947280L;
    private JCheckBox checkBox;
    private JSpinner spinner;
    private boolean enabled = true;

    public AbstractAttributeSpinnerPanel(T t) {
        super(new BorderLayout());
        this.buildLayout(t);
    }

    private void buildLayout(T t) {
        this.checkBox = new JCheckBox();
        this.checkBox.setSelected(true);
        this.checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!AbstractAttributeSpinnerPanel.this.checkBox.isSelected()) {
                    AbstractAttributeSpinnerPanel.this.spinner.setEnabled(false);
                } else {
                    AbstractAttributeSpinnerPanel.this.spinner.setEnabled(true);
                }
            }
        });
        this.add((Component)this.checkBox, "West");
        this.spinner = new JSpinner(this.createSpinnerModel(t));
        this.spinner.setEnabled(true);
        this.modifySpinner(this.spinner, t);
        this.add((Component)this.spinner, "Center");
    }

    protected void modifySpinner(JSpinner spinner, T t) {
    }

    protected abstract SpinnerModel createSpinnerModel(T var1);

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.checkBox.setEnabled(enabled);
        this.spinner.setEnabled(enabled && this.getValue() != null);
    }

    public void setValue(S value) {
        if (value == null) {
            this.checkBox.setSelected(false);
            this.spinner.setEnabled(false);
        } else {
            this.checkBox.setSelected(true);
            this.spinner.setEnabled(this.enabled);
            this.spinner.setValue(value);
        }
    }

    public S getValue() {
        if (!this.checkBox.isSelected()) {
            return null;
        }
        return (S)this.spinner.getValue();
    }

    public JSpinner getSpinner() {
        return this.spinner;
    }
}

