/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.areatour;

import de.datomino.peppergis.client.gui.common.EnumCellEditor;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.comparator.ComparatorBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.ktde.util.datatypes.Tupel;

public class AreaTourCalculationOrderNotPossiblePane
extends JPanel {
    private static final long serialVersionUID = 5174484958175606710L;
    private Map<AreaObjectModel, List<Model>> origOrderNotPossible;
    private Map<AreaObjectModel, List<Model>> parcelOrderNotPossible;
    private List<AreaObjectModel> allAreaObjects;
    private JTable table;
    private NotPossibleAction[] actions;

    public AreaTourCalculationOrderNotPossiblePane(Collection<Tupel<AreaObjectModel, List<Model>>> origOrderNotPossible, Collection<Tupel<AreaObjectModel, List<Model>>> parcelOrderNotPossible) {
        super(new BorderLayout());
        this.origOrderNotPossible = CollectionUtil.tupelToHashMap(origOrderNotPossible);
        this.parcelOrderNotPossible = CollectionUtil.tupelToHashMap(parcelOrderNotPossible);
        TreeSet<AreaObjectModel> sortedSet = new TreeSet<AreaObjectModel>(new Comparator<AreaObjectModel>(){

            @Override
            public int compare(AreaObjectModel o1, AreaObjectModel o2) {
                return new ComparatorBuilder().append(o1.getShortcut(), o2.getShortcut(), true).append(o1.getAreaLayer().getDisplayname(), o2.getAreaLayer().getDisplayname(), true).compare();
            }
        });
        sortedSet.addAll(this.origOrderNotPossible.keySet());
        sortedSet.addAll(this.parcelOrderNotPossible.keySet());
        this.allAreaObjects = new ArrayList<AreaObjectModel>(sortedSet);
        sortedSet = null;
        this.actions = new NotPossibleAction[this.allAreaObjects.size()];
        Arrays.fill((Object[])this.actions, (Object)NotPossibleAction.SKIP);
        this.buildLayout();
    }

    private void buildLayout() {
        this.table = new JTable(new AreaTourCalculationOrderNotPossibleTableModel());
        this.table.setDefaultRenderer(NotPossibleAction.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = -5152720513350860428L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                NotPossibleAction notPossibleAction = (NotPossibleAction)((Object)value);
                String text = ModelEnviroment.getMessageResolver().resolveMessageForEnum(notPossibleAction);
                return super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
            }
        });
        this.table.setDefaultEditor(NotPossibleAction.class, new EnumCellEditor<NotPossibleAction>(NotPossibleAction.class, false){
            private static final long serialVersionUID = -5844575974062494071L;

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                EnumComboBox comboBox = (EnumComboBox)super.getTableCellEditorComponent(table, value, isSelected, row, column);
                AreaObjectModel areaObject = (AreaObjectModel)AreaTourCalculationOrderNotPossiblePane.this.allAreaObjects.get(row);
                boolean isOrig = AreaTourCalculationOrderNotPossiblePane.this.origOrderNotPossible.containsKey(areaObject);
                boolean isParcel = AreaTourCalculationOrderNotPossiblePane.this.parcelOrderNotPossible.containsKey(areaObject);
                Enum[] notPossibleActions = new NotPossibleAction[]{};
                if (isOrig && isParcel) {
                    notPossibleActions = new NotPossibleAction[]{NotPossibleAction.SKIP, NotPossibleAction.OPTIMIZE};
                } else if (isOrig) {
                    notPossibleActions = new NotPossibleAction[]{NotPossibleAction.SKIP, NotPossibleAction.OPTIMIZE, NotPossibleAction.PARCEL};
                } else if (isParcel) {
                    notPossibleActions = new NotPossibleAction[]{NotPossibleAction.SKIP, NotPossibleAction.OPTIMIZE, NotPossibleAction.ORIG};
                }
                comboBox.setElements(false, true, notPossibleActions);
                return comboBox;
            }
        });
        this.add((Component)new JScrollPane(this.table), "Center");
        this.add((Component)new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.areacalculation.notPossible.question", new Serializable[0])), "North");
    }

    public Collection<Tupel<AreaObjectModel, List<Model>>> getAreaObjectsToSkip() {
        return this.getAreaObjects(NotPossibleAction.SKIP);
    }

    public Collection<Tupel<AreaObjectModel, List<Model>>> getAreaObjectsForOptimize() {
        return this.getAreaObjects(NotPossibleAction.OPTIMIZE);
    }

    public Collection<Tupel<AreaObjectModel, List<Model>>> getAreaObjectsForOrig() {
        return this.getAreaObjects(NotPossibleAction.ORIG);
    }

    public Collection<Tupel<AreaObjectModel, List<Model>>> getAreaObjectsForParcel() {
        return this.getAreaObjects(NotPossibleAction.PARCEL);
    }

    private Collection<Tupel<AreaObjectModel, List<Model>>> getAreaObjects(NotPossibleAction notPossibleAction) {
        LinkedList<Tupel<AreaObjectModel, List<Model>>> list = new LinkedList<Tupel<AreaObjectModel, List<Model>>>();
        for (int i = 0; i < this.actions.length; ++i) {
            if (this.actions[i] != notPossibleAction) continue;
            AreaObjectModel area = this.allAreaObjects.get(i);
            List<Model> models = this.origOrderNotPossible.get(area);
            if (models == null) {
                models = this.parcelOrderNotPossible.get(area);
            }
            list.add(new Tupel<AreaObjectModel, List<Model>>(area, models));
        }
        return list;
    }

    private class AreaTourCalculationOrderNotPossibleTableModel
    implements TableModel {
        private List<TableModelListener> listeners = new LinkedList<TableModelListener>();

        private AreaTourCalculationOrderNotPossibleTableModel() {
        }

        @Override
        public int getRowCount() {
            return AreaTourCalculationOrderNotPossiblePane.this.allAreaObjects.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("messages.area.shortcut", new Serializable[0]);
                }
                case 1: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("messages.area.displayName", new Serializable[0]);
                }
                case 2: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("messages.default.action", new Serializable[0]);
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: 
                case 1: {
                    return String.class;
                }
                case 2: {
                    return NotPossibleAction.class;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            AreaObjectModel areaObjectModel = (AreaObjectModel)AreaTourCalculationOrderNotPossiblePane.this.allAreaObjects.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return areaObjectModel.getShortcut();
                }
                case 1: {
                    return areaObjectModel.getDisplayname();
                }
                case 2: {
                    return AreaTourCalculationOrderNotPossiblePane.this.actions[rowIndex];
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 2) {
                ((AreaTourCalculationOrderNotPossiblePane)AreaTourCalculationOrderNotPossiblePane.this).actions[rowIndex] = (NotPossibleAction)((Object)aValue);
            }
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }
    }

    private static enum NotPossibleAction {
        SKIP,
        OPTIMIZE,
        ORIG,
        PARCEL;

    }
}

