/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.area;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModel;
import java.awt.Component;
import java.util.Collection;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang.builder.EqualsBuilder;

public class DeliveryRoundComboBox
extends JComboBox<DeliveryRoundModel> {
    private static final long serialVersionUID = 443176252374246051L;

    public DeliveryRoundComboBox(ModelEnviroment modelEnviroment, boolean withEmpty) {
        super(DeliveryRoundComboBox.createDeliveryRoundVector(modelEnviroment, withEmpty));
        final ListCellRenderer renderer = this.getRenderer();
        this.setRenderer(new ListCellRenderer<DeliveryRoundModel>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends DeliveryRoundModel> list, DeliveryRoundModel value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == null) {
                    return renderer.getListCellRendererComponent(list, " ", index, isSelected, cellHasFocus);
                }
                return renderer.getListCellRendererComponent(list, value.getName(), index, isSelected, cellHasFocus);
            }
        });
    }

    private static Vector<DeliveryRoundModel> createDeliveryRoundVector(ModelEnviroment modelEnviroment, boolean withEmpty) {
        Collection<DeliveryRoundModel> deliveryRounds = modelEnviroment.getAllCaller().getTourCaller().fetchAllDeliveryRounds();
        if (withEmpty) {
            Vector<DeliveryRoundModel> vector = new Vector<DeliveryRoundModel>(deliveryRounds.size() + 1);
            vector.add(null);
            vector.addAll(deliveryRounds);
            return vector;
        }
        return new Vector<DeliveryRoundModel>(deliveryRounds);
    }

    public DeliveryRoundModel getSelectedDeliveryRound() {
        Object o = this.getSelectedItem();
        if (o instanceof DeliveryRoundModel) {
            return (DeliveryRoundModel)o;
        }
        return null;
    }

    public void setSelectedDeliveryRound(String name) {
        ComboBoxModel model = this.getModel();
        int index = 0;
        for (int i = 0; i < model.getSize(); ++i) {
            DeliveryRoundModel round = (DeliveryRoundModel)model.getElementAt(i);
            if (round == null || !new EqualsBuilder().append(round.getName(), name).isEquals()) continue;
            index = i;
            break;
        }
        this.setSelectedIndex(index);
    }
}

