/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.area;

import de.datomino.peppergis.client.gui.area.AreaObjectChooserTableModel;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableColumn;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;

public class DefaultAreaObjectChooserPane
extends JPanel {
    private static final long serialVersionUID = 7730553988425706238L;
    private JCheckBox showAll;
    protected JTable areaList;
    private JTextField search;
    protected AreaLayerModel areaLayerModel;
    private Color defaultColor;
    protected ModelEnviroment modelEnviroment;
    private AreaObjectChooserTableModel areaTableModel;
    private boolean autoClear;

    public DefaultAreaObjectChooserPane(ModelEnviroment modelEnviroment) {
        this(null, modelEnviroment);
    }

    public DefaultAreaObjectChooserPane(ModelEnviroment modelEnviroment, boolean autoClear, boolean copyAndPasteWindow) {
        this(null, modelEnviroment, autoClear, copyAndPasteWindow);
    }

    public DefaultAreaObjectChooserPane(AreaLayerModel areaLayerModel, ModelEnviroment modelEnviroment) {
        this(areaLayerModel, modelEnviroment, false);
    }

    public DefaultAreaObjectChooserPane(AreaLayerModel areaLayerModel, ModelEnviroment modelEnviroment, boolean autoClear) {
        this(areaLayerModel, modelEnviroment, autoClear, false);
    }

    public DefaultAreaObjectChooserPane(AreaLayerModel areaLayerModel, ModelEnviroment modelEnviroment, boolean autoClear, boolean copyAndPasteWindow) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        this.autoClear = autoClear;
        this.areaLayerModel = areaLayerModel;
        this.buildLayout(copyAndPasteWindow);
        this.setAreaLayerModel(areaLayerModel);
    }

    public void setAreaLayerModel(AreaLayerModel areaLayerModel) {
        this.areaLayerModel = areaLayerModel;
        List<Tripel<Long, String, String>> areas = areaLayerModel == null ? Collections.EMPTY_LIST : this.modelEnviroment.getAllCaller().getAreaCaller().getAreaObjectsIdAndCaptionsForLayer(areaLayerModel);
        this.areaTableModel.setElements(areas);
    }

    private void buildLayout(boolean copyAndPasteWindow) {
        JPanel top = new JPanel(new SpringLayout());
        this.showAll = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage(this.getShowAllMessageKey(), new Serializable[0]), true);
        top.add(this.showAll);
        this.defaultColor = this.showAll.getForeground();
        this.showAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultAreaObjectChooserPane.this.showAll.setForeground(DefaultAreaObjectChooserPane.this.defaultColor);
                AreaObjectChooserTableModel areaObjectChooserTableModel = (AreaObjectChooserTableModel)DefaultAreaObjectChooserPane.this.areaList.getModel();
                areaObjectChooserTableModel.setShownAreasSelected(DefaultAreaObjectChooserPane.this.showAll.isSelected());
                DefaultAreaObjectChooserPane.this.fireShowAll(DefaultAreaObjectChooserPane.this.showAll.isSelected());
            }
        });
        this.search = new JTextField(30);
        this.search.getDocument().addDocumentListener(new SearchListener());
        top.add(this.search);
        SpringUtilities.makeCompactGrid(top, 2, 1, 2, 2, 2, 2);
        this.add((Component)top, "North");
        boolean isGenArea = this.areaLayerModel == null ? false : this.areaLayerModel.getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT;
        this.areaTableModel = new AreaObjectChooserTableModel(isGenArea ? "messages.area.shortcut.order" : "messages.area.shortcut");
        this.areaList = new JTable(this.areaTableModel);
        this.areaList.getTableHeader().setReorderingAllowed(false);
        this.areaList.setAutoCreateRowSorter(true);
        this.areaList.getDefaultEditor(Boolean.class).addCellEditorListener(new MarkAreaCellEditorListener());
        this.areaList.addMouseListener(this.createAreaTabelMouseListener());
        TableColumn markColumn = this.areaList.getColumnModel().getColumn(0);
        markColumn.setMaxWidth(20);
        this.add((Component)new JScrollPane(this.areaList), "Center");
        this.add(this.createSouthPanel(copyAndPasteWindow), "South");
        SwingUtils.addKeyListenerRek(this, new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                boolean ctrl;
                boolean bl = ctrl = (e.getModifiersEx() & 0x80) == 128;
                if (ctrl) {
                    switch (e.getKeyCode()) {
                        case 67: {
                            e.consume();
                            DefaultAreaObjectChooserPane.this.copy();
                            break;
                        }
                        case 86: {
                            e.consume();
                            DefaultAreaObjectChooserPane.this.paste();
                        }
                    }
                }
            }
        });
    }

    private void copy() {
        TreeSet<String> areas = new TreeSet<String>(this.getSelectedShortcuts());
        String value = StringUtil.implode(areas, "\n");
        StringSelection selection = new StringSelection(value);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
    }

    private void paste() {
        DataFlavor[] flavors;
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        for (DataFlavor flavor : flavors = transferable.getTransferDataFlavors()) {
            if (!DataFlavor.stringFlavor.equals(flavor)) continue;
            try {
                String value = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.paste(value);
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            break;
        }
    }

    private void paste(String value) {
        if (value != null) {
            StringTokenizer st = new StringTokenizer(value, "\n");
            HashSet<String> shortcuts = new HashSet<String>();
            while (st.hasMoreTokens()) {
                shortcuts.add(st.nextToken());
            }
            this.setSelection(shortcuts);
        }
    }

    protected MouseListener createAreaTabelMouseListener() {
        return null;
    }

    protected String getShowAllMessageKey() {
        return "messages.area.showAll";
    }

    protected Component createSouthPanel(boolean copyAndPasteWindow) {
        if (copyAndPasteWindow) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)new JButton(new InsertFromClipboardAction()), "West");
            return panel;
        }
        return new JLabel();
    }

    public Set<Long> getNotSelectedAreaObjects() {
        if (this.showAll == null || !this.showAll.isSelected()) {
            return this.areaTableModel.getNotSelectedIds();
        }
        return null;
    }

    public Set<Long> getSelectedAreaObjects() {
        if (this.showAll == null || !this.showAll.isSelected()) {
            return this.areaTableModel.getSelectedIds();
        }
        Map<Long, Tripel<String, String, Boolean>> all = this.areaTableModel.getAll();
        return new HashSet<Long>(all.keySet());
    }

    public boolean isShowAllSelected() {
        return this.showAll != null && this.showAll.isSelected();
    }

    public Set<String> getSelectedShortcuts() {
        HashSet<String> shortcuts = new HashSet<String>();
        if (this.showAll == null || !this.showAll.isSelected()) {
            Set<Tripel<Long, String, String>> selection = this.areaTableModel.getSelection();
            for (Tripel tripel : selection) {
                shortcuts.add((String)tripel.getElement2());
            }
        } else {
            Collection<Tripel<String, String, Boolean>> values = this.areaTableModel.getAll().values();
            for (Tripel<String, String, Boolean> tripel : values) {
                shortcuts.add(tripel.getElement1());
            }
        }
        return shortcuts;
    }

    public String getTitleAddon() {
        Set<Tripel<Long, String, String>> selection;
        if (this.areaLayerModel.getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT && (selection = this.areaTableModel.getSelection()).size() == 1) {
            Tripel<Long, String, String> tripel = selection.iterator().next();
            return tripel.getElement2();
        }
        return null;
    }

    public void setSelection(Collection<String> shortcuts) {
        this.showAll.setSelected(false);
        this.areaTableModel.setSelectedValues(shortcuts);
    }

    public void clearSelection() {
        this.showAll.setSelected(false);
        this.areaTableModel.clearSelection();
    }

    protected void fireMarkAreaCell(String shortCut, boolean selected) {
        if (!selected && this.isShowAllSelected()) {
            this.setShowAllSelected(false);
        }
    }

    protected void fireShowAll(boolean selected) {
    }

    public AreaLayerModel getAreaLayerModel() {
        return this.areaLayerModel;
    }

    public void setShowAllSelected(boolean b) {
        this.showAll.setSelected(b);
    }

    public void setSelectionIds(Collection<Long> areaObjectIds) {
        this.areaTableModel.setSelectedIds(areaObjectIds);
    }

    protected class InsertFromClipboardAction
    extends AbstractAction {
        private static final long serialVersionUID = -1603170165526693222L;

        public InsertFromClipboardAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.insertFromClipboard", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            try {
                String data = (String)clipboard.getData(DataFlavor.stringFlavor);
                AreaObjectChooserTableModel tableModel = (AreaObjectChooserTableModel)DefaultAreaObjectChooserPane.this.areaList.getModel();
                HashSet<String> shortCuts = new HashSet<String>();
                StringTokenizer st = new StringTokenizer(data);
                while (st.hasMoreTokens()) {
                    shortCuts.add(st.nextToken());
                }
                tableModel.setSelectedValues(shortCuts);
            }
            catch (UnsupportedFlavorException ex) {
                JOptionPane.showMessageDialog(SwingUtils.findWindowParent(DefaultAreaObjectChooserPane.this), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.noTextInClipboard", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.warning", new Serializable[0]), 2);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private class MarkAreaCellEditorListener
    implements CellEditorListener {
        private MarkAreaCellEditorListener() {
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            DefaultAreaObjectChooserPane.this.showAll.setForeground(Color.GRAY.brighter());
            int selectedRow = DefaultAreaObjectChooserPane.this.areaList.getSelectedRow();
            boolean selected = (Boolean)DefaultAreaObjectChooserPane.this.areaTableModel.getValueAt(selectedRow, 0);
            String shortCut = (String)DefaultAreaObjectChooserPane.this.areaTableModel.getValueAt(selectedRow, 1);
            DefaultAreaObjectChooserPane.this.fireMarkAreaCell(shortCut, selected);
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
        }
    }

    private class SearchListener
    implements DocumentListener {
        private SearchListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.search();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.search();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.search();
        }

        private void search() {
            String searchText = DefaultAreaObjectChooserPane.this.search.getText();
            searchText = "*" + searchText + "*";
            AreaObjectChooserTableModel model = DefaultAreaObjectChooserPane.this.areaTableModel;
            model.searchShortcut(searchText);
            boolean showAllSelected = DefaultAreaObjectChooserPane.this.showAll.isSelected();
            if (DefaultAreaObjectChooserPane.this.autoClear || showAllSelected) {
                model.clearSelection();
                model.setShownAreasSelected(showAllSelected);
            }
        }
    }
}

