/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.area;

import de.datomino.peppergis.client.communication.AreaCaller;
import de.datomino.peppergis.client.gui.AbstractAutoCompleteComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import java.io.Serializable;
import java.util.List;

public class AutoCompleteAreaObjectComboBox
extends AbstractAutoCompleteComboBox<AreaObjectModel> {
    private static final long serialVersionUID = 2852619037613904505L;
    private AreaLayerModel areaLayer;
    private AreaCaller areaCaller;

    public AutoCompleteAreaObjectComboBox(AreaCaller areaCaller) {
        this(null, areaCaller);
    }

    public AutoCompleteAreaObjectComboBox(AreaLayerModel areaLayer, AreaCaller areaCaller) {
        this.areaCaller = areaCaller;
        this.setAreaLayer(areaLayer);
    }

    @Override
    public String toDisplayString(Object data) {
        if (data == null) {
            return ModelEnviroment.getMessageResolver().resolveMessage("messages.default.all", new Serializable[0]);
        }
        if (data instanceof AreaObjectModel) {
            AreaObjectModel area = (AreaObjectModel)data;
            return AreaObjectModelUtil.getShortcutAndDisplayname(area);
        }
        return data.toString();
    }

    public AreaLayerModel getAreaLayer() {
        return this.areaLayer;
    }

    public void setAreaLayer(AreaLayerModel areaLayer) {
        if (areaLayer != null && (this.areaLayer == null || this.areaLayer != areaLayer)) {
            this.areaLayer = areaLayer;
            List<AreaObjectModel> areaObjects = this.areaCaller.fetchAreaObjectsByAreaLayer(areaLayer, false);
            super.setDataList(areaObjects);
        }
    }
}

