/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.area;

import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.type.areatourtype.AreaCalculationType;
import de.datomino.peppergis.type.areatourtype.AreaObjectType;
import de.datomino.peppergis.type.areatourtype.AreaTourType;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.WidthUnifier;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.ArrayUtils;

public class AreaTourTypePane
extends JPanel {
    private static final long serialVersionUID = 4263731850493631250L;
    private AreaObjectType[] allowedAreaObjectTypes;
    private AreaCalculationType[] allowedAreaCalculationTypes;
    private EnumComboBox<AreaObjectType> areaObjectType;
    private EnumComboBox<AreaCalculationType> areaCalculationType;
    private List<ChangeListener> changeListeners = new LinkedList<ChangeListener>();

    public AreaTourTypePane(AreaObjectType[] allowedAreaObjectTypes, AreaCalculationType[] allowedAreaCalculationTypes) {
        this(allowedAreaObjectTypes, allowedAreaCalculationTypes, new WidthUnifier(), new WidthUnifier());
    }

    public AreaTourTypePane(AreaObjectType[] allowedAreaObjectTypes, AreaCalculationType[] allowedAreaCalculationTypes, WidthUnifier labelWidthUnifier, WidthUnifier widgetWidthUnifier) {
        super(new SpringLayout());
        this.allowedAreaCalculationTypes = allowedAreaCalculationTypes;
        this.allowedAreaObjectTypes = allowedAreaObjectTypes;
        this.buildLayout(labelWidthUnifier, widgetWidthUnifier);
    }

    private void buildLayout(WidthUnifier labelWidthUnifier, WidthUnifier widgetWidthUnifier) {
        JLabel label;
        ChangeActionListener changeActionListener = new ChangeActionListener();
        this.areaObjectType = new EnumComboBox(AreaObjectType.class, false, (Enum[])this.allowedAreaObjectTypes);
        this.areaObjectType.addActionListener(changeActionListener);
        int cCount = 0;
        if (this.allowedAreaObjectTypes.length > 1) {
            label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(AreaObjectType.class.getName(), new Serializable[0]));
            this.add(label);
            labelWidthUnifier.add(label);
            this.add(this.areaObjectType);
            widgetWidthUnifier.add(this.areaObjectType);
            ++cCount;
        }
        this.areaCalculationType = new EnumComboBox(AreaCalculationType.class, false, (Enum[])this.allowedAreaCalculationTypes);
        this.areaCalculationType.addActionListener(changeActionListener);
        if (this.allowedAreaCalculationTypes.length > 1) {
            label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(AreaCalculationType.class.getName(), new Serializable[0]));
            this.add(label);
            labelWidthUnifier.add(label);
            this.add(this.areaCalculationType);
            widgetWidthUnifier.add(this.areaCalculationType);
            ++cCount;
        }
        labelWidthUnifier.unifyWidth();
        widgetWidthUnifier.unifyWidth();
        SpringUtilities.makeCompactGrid(this, cCount, 2, 2, 2, 5, 5);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.areaCalculationType.setEnabled(enabled);
        this.areaObjectType.setEnabled(enabled);
    }

    public void setAreaTourType(AreaTourType areaTourType) {
        int itemCount = this.areaObjectType.getItemCount();
        if (areaTourType == null) {
            this.areaCalculationType.setSelectedIndex(0);
            if (itemCount > 0) {
                this.areaObjectType.setSelectedIndex(0);
            }
        } else {
            if (ArrayUtils.contains((Object[])this.allowedAreaCalculationTypes, (Object)areaTourType.getAreaCalculationType())) {
                this.areaCalculationType.setSelectedValue(areaTourType.getAreaCalculationType());
            } else {
                this.areaCalculationType.setSelectedIndex(0);
            }
            if (ArrayUtils.contains((Object[])this.allowedAreaObjectTypes, (Object)areaTourType.getAreaObjectType())) {
                this.areaObjectType.setSelectedValue(areaTourType.getAreaObjectType());
            } else if (itemCount > 0) {
                this.areaObjectType.setSelectedIndex(0);
            }
        }
    }

    public AreaTourType getAreaTourType() {
        return new AreaTourType(this.areaObjectType.getSelectedValue(), this.areaCalculationType.getSelectedValue());
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    protected void fireChangeEvent(ChangeEvent e) {
        for (ChangeListener l : this.changeListeners) {
            l.stateChanged(e);
        }
    }

    private class ChangeActionListener
    implements ActionListener {
        private ChangeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AreaTourTypePane.this.fireChangeEvent(new ChangeEvent(AreaTourTypePane.this));
        }
    }
}

