/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.area;

import de.datomino.peppergis.client.gui.common.AbstractStringListCellRenderer;
import de.datomino.peppergis.client.model.area.AreaAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.area.AreaAttributeValueModel;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaStaticChoiceAttributeValueModel;
import de.datomino.util.common.PrimitiveUtil;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.swing.ListCellRenderer;
import org.ktde.util.StringUtil;

public class AreaObjectListCellRenderer
extends AbstractStringListCellRenderer {
    private boolean showLayer;
    private Map<String, String[]> attributeNames;

    public AreaObjectListCellRenderer(ListCellRenderer listCellRenderer, boolean showLayer, Map<String, String[]> attributeNames) {
        super(listCellRenderer);
        this.showLayer = showLayer;
        this.attributeNames = attributeNames == null ? Collections.emptyMap() : attributeNames;
    }

    @Override
    protected String getString(Object value) {
        if (value instanceof AreaObjectModel) {
            String layerName;
            AreaLayerModel areaLayerModel;
            AreaObjectModel areaObjectModel = (AreaObjectModel)value;
            StringBuilder sb = new StringBuilder();
            String displayName = areaObjectModel.getDisplayname();
            String shortCut = areaObjectModel.getShortcut();
            boolean displayNameBlank = StringUtil.isBlank(displayName);
            boolean shortCutBlank = StringUtil.isBlank(shortCut);
            if (displayNameBlank && shortCutBlank) {
                sb.append("???");
            } else if (displayNameBlank) {
                sb.append(shortCut);
            } else if (shortCutBlank) {
                sb.append(displayName);
            } else if (displayName.equals(shortCut)) {
                sb.append(displayName);
            } else {
                sb.append(displayName).append("/").append(shortCut);
            }
            if (this.showLayer && (areaLayerModel = areaObjectModel.getAreaLayer()) != null && !StringUtil.isBlank(layerName = areaLayerModel.getDisplayname())) {
                sb.append(" - ").append(layerName);
            }
            if (this.attributeNames != null) {
                String[] attributes;
                AreaLayerModel layer = areaObjectModel.getAreaLayer();
                String[] stringArray = attributes = layer == null ? null : this.attributeNames.get(layer.getDisplayname());
                if (attributes != null) {
                    block0: for (String attributeName : attributes) {
                        for (AreaAttributeValueModel areaAttributeValueModel : areaObjectModel.iterableAreaAttributeValues()) {
                            AreaAttributeValueDescriptorModel areaAttributeValueDescriptorModel = areaAttributeValueModel.getAreaAttributeValueDescriptor();
                            if (!attributeName.equals(areaAttributeValueDescriptorModel.getKey())) continue;
                            sb.append(" - ").append(this.getAttributeValue(areaAttributeValueModel, areaAttributeValueDescriptorModel));
                            continue block0;
                        }
                    }
                }
            }
            return sb.toString();
        }
        return value == null ? null : value.toString();
    }

    private Object getAttributeValue(AreaAttributeValueModel areaAttributeValueModel, AreaAttributeValueDescriptorModel areaAttributeValueDescriptorModel) {
        switch (areaAttributeValueDescriptorModel.getAttributeValueType()) {
            case BOOLEAN: {
                boolean b = PrimitiveUtil.nullToFalse(areaAttributeValueModel.getBooleanValue());
                return b ? "x" : "";
            }
            case DATE: {
                Long l = areaAttributeValueModel.getLongValue();
                if (l == null) {
                    return "";
                }
                return new SimpleDateFormat("yyyyMMdd").format(new Date(l));
            }
            case INTEGER: {
                Integer i = areaAttributeValueModel.getIntegerValue();
                if (i == null) {
                    return "";
                }
                return i.toString();
            }
            case STATIC_CHOICE: {
                AreaStaticChoiceAttributeValueModel staticChoiceValue = areaAttributeValueModel.getStaticChoiceValue();
                if (staticChoiceValue == null) {
                    return "";
                }
                return staticChoiceValue.getValue();
            }
            case STRING: {
                return StringUtil.nullToEmpty(areaAttributeValueModel.getStringValue());
            }
            case TEXT: {
                return StringUtil.nullToEmpty(areaAttributeValueModel.getTextValue());
            }
            case FLOAT: {
                return StringUtil.nullToEmpty(areaAttributeValueModel.getFloatValue());
            }
        }
        return "";
    }
}

