/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.area;

import de.datomino.peppergis.client.gui.attribute.area.AreaAttributeValuePane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.poi.PoiSelectionPanel;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.AttributeGroupModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.AttributeGroupType;
import de.datomino.peppergis.type.PoiSearchType;
import de.datomino.peppergis.type.UserRole;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.ktde.util.StringUtil;

public class AreaObjectDialog
extends JDialog {
    private static final long serialVersionUID = 2434350634564602797L;
    private AreaObjectModel areaObjectModel;
    private ModelEnviroment modelEnviroment;
    private List<AreaAttributeValuePane> areaAttributeValuePanes;
    private JTextField displayName;
    private PoiSelectionPanel poiSelectionPanel;
    private PoiSelectionPanel firstPickPointSelectionPanel;
    private PoiSelectionPanel lastThrowPoiSelectionPanel;
    private static final int TEXT_INT = 20;

    public AreaObjectDialog(Window parent, AreaObjectModel areaObjectModel, ModelEnviroment modelEnviroment) {
        super(parent, AreaObjectModelUtil.getShortcutAndDisplayname(areaObjectModel), Dialog.ModalityType.MODELESS);
        try {
            this.setIconImage(ImageIO.read(AreaObjectDialog.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.modelEnviroment = modelEnviroment;
        this.areaObjectModel = areaObjectModel;
        this.buildLayout();
        this.fillValues();
        this.pack();
        SwingUtils.centerDialog(this, parent);
    }

    private void fillValues() {
        for (AreaAttributeValuePane areaAttributeValuePane : this.areaAttributeValuePanes) {
            areaAttributeValuePane.fillValues(this.areaObjectModel);
        }
    }

    private void buildLayout() {
        this.getContentPane().setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        if (this.areaObjectModel != null) {
            JPanel areaBasicPane = new JPanel(new BorderLayout());
            JPanel internalAreaPane = new JPanel(new SpringLayout());
            JLabel shortcutLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.shortcut", new Serializable[0]));
            internalAreaPane.add(shortcutLabel);
            JTextField shortcutText = new JTextField(20);
            shortcutText.setText(StringUtil.nullToEmpty(this.areaObjectModel.getShortcut()));
            shortcutText.setEditable(false);
            internalAreaPane.add(shortcutText);
            JLabel displayNameLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.displayName", new Serializable[0]));
            internalAreaPane.add(displayNameLabel);
            this.displayName = new JTextField(20);
            this.displayName.setText(StringUtil.nullToEmpty(this.areaObjectModel.getDisplayname()));
            boolean displayNameEditable = ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.AREA_ADMIN, UserRole.AREA_EDITOR, UserRole.DISPONENT_SUPER);
            this.displayName.setEditable(displayNameEditable);
            internalAreaPane.add(this.displayName);
            JLabel parcelsCountLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.parcels", new Serializable[0]));
            internalAreaPane.add(parcelsCountLabel);
            JTextField parcelsCountText = new JTextField(20);
            parcelsCountText.setText(StringUtil.nullToEmpty(this.areaObjectModel.countAreaObjectParcelRel()));
            parcelsCountText.setEditable(false);
            internalAreaPane.add(parcelsCountText);
            PoiModel poi = null;
            PoiModel firstThrowPoi = null;
            PoiModel lastThrowPoi = null;
            if (this.areaObjectModel.getId() != null) {
                poi = this.areaObjectModel.getPoi();
                firstThrowPoi = this.areaObjectModel.getFirstPickPoint();
                lastThrowPoi = this.areaObjectModel.getLastPickPoint();
            }
            JLabel subscriptionsCountLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptions", new Serializable[0]));
            internalAreaPane.add(subscriptionsCountLabel);
            JTextField subscriptionsCountText = new JTextField(20);
            subscriptionsCountText.setText(StringUtil.nullToEmpty(this.areaObjectModel.countSubscriptions()));
            subscriptionsCountText.setEditable(false);
            internalAreaPane.add(subscriptionsCountText);
            JLabel poiNumberLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.poi.unloadingPoint", new Serializable[0]));
            internalAreaPane.add(poiNumberLabel);
            this.poiSelectionPanel = new PoiSelectionPanel(this.modelEnviroment, new PoiSearchType[]{PoiSearchType.AREAOBJECT_LOCATION}, poi);
            internalAreaPane.add(this.poiSelectionPanel);
            JLabel firstThrowLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.firstThrowPoi", new Serializable[0]));
            internalAreaPane.add(firstThrowLabel);
            this.firstPickPointSelectionPanel = new PoiSelectionPanel(this.modelEnviroment, new PoiSearchType[]{PoiSearchType.AREAOBJECT_LOCATION, PoiSearchType.PICK_POINT}, firstThrowPoi);
            internalAreaPane.add(this.firstPickPointSelectionPanel);
            JLabel lastThrowLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.lastThrowPoi", new Serializable[0]));
            internalAreaPane.add(lastThrowLabel);
            this.lastThrowPoiSelectionPanel = new PoiSelectionPanel(this.modelEnviroment, new PoiSearchType[]{PoiSearchType.AREAOBJECT_LOCATION, PoiSearchType.PICK_POINT}, lastThrowPoi);
            internalAreaPane.add(this.lastThrowPoiSelectionPanel);
            SpringUtilities.makeCompactGrid(internalAreaPane, 7, 2, 2, 5, 2, 2);
            areaBasicPane.add((Component)internalAreaPane, "North");
            tabbedPane.add(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.area", new Serializable[0]), areaBasicPane);
        }
        int rowsPerCol = 20;
        try {
            rowsPerCol = Integer.parseInt(ModelEnviroment.getProperties().getProperty("attributes.area.dialog.rowsPerCol"));
        }
        catch (Exception internalAreaPane) {
            // empty catch block
        }
        Collection<AttributeGroupModel> groups = this.modelEnviroment.getAllCaller().getBaseCaller().getAttributeGroupForType(AttributeGroupType.AREA);
        this.areaAttributeValuePanes = new ArrayList<AreaAttributeValuePane>(groups.size());
        for (AttributeGroupModel group : groups) {
            JPanel attributePane = new JPanel(new BorderLayout());
            AreaAttributeValuePane areaAttributeValuePane = new AreaAttributeValuePane(this.areaObjectModel, Collections.singleton(group), rowsPerCol, this.modelEnviroment, ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.AREA_ADMIN, UserRole.AREA_EDITOR, UserRole.DISPONENT_SUPER));
            attributePane.add((Component)areaAttributeValuePane, "North");
            tabbedPane.add(group.getName(), new JScrollPane(attributePane));
            this.areaAttributeValuePanes.add(areaAttributeValuePane);
        }
        this.getContentPane().add((Component)tabbedPane, "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JButton cancel = new JButton(new AbstractAction("Abbrechen"){
            private static final long serialVersionUID = -6788888052501724380L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AreaObjectDialog.this.dispose();
            }
        });
        buttonPanel.add((Component)cancel, "West");
        JButton ok = new JButton(new AbstractAction("Ok"){
            private static final long serialVersionUID = -8894721739597074504L;

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoManager undoManager = AreaObjectDialog.this.modelEnviroment.getUndoManager();
                undoManager.startTransaction();
                for (AreaAttributeValuePane areaAttributeValuePane : AreaObjectDialog.this.areaAttributeValuePanes) {
                    areaAttributeValuePane.adaptValuesToModel(AreaObjectDialog.this.areaObjectModel);
                }
                String key = AreaObjectDialog.this.areaObjectModel.getAreaLayer().getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT ? "messages.area.attributes.changed.order" : "messages.area.attributes.changed";
                AreaObjectDialog.this.areaObjectModel.setDisplayname(AreaObjectDialog.this.displayName.getText());
                PoiModel poi = AreaObjectDialog.this.poiSelectionPanel.getPoiModel();
                AreaObjectDialog.this.areaObjectModel.setPoi(poi);
                PoiModel firstThrowPoi = AreaObjectDialog.this.firstPickPointSelectionPanel.getPoiModel();
                AreaObjectDialog.this.areaObjectModel.setFirstPickPoint(firstThrowPoi);
                PoiModel lastThrowPoi = AreaObjectDialog.this.lastThrowPoiSelectionPanel.getPoiModel();
                AreaObjectDialog.this.areaObjectModel.setLastPickPoint(lastThrowPoi);
                undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage(key, new Serializable[]{AreaObjectDialog.this.areaObjectModel.getShortcut()}));
                AreaObjectDialog.this.dispose();
            }
        });
        buttonPanel.add((Component)ok, "East");
        this.getContentPane().add((Component)buttonPanel, "South");
    }
}

