/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.area;

import de.datomino.peppergis.client.gui.area.AreaLayerProvider;
import de.datomino.peppergis.client.gui.common.AbstractModelComboBox;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.util.common.PrimitiveUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultComboBoxModel;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.collections.Transformer;
import org.ktde.util.StringUtil;

public class AreaObjectComboBox
extends AbstractModelComboBox<AreaObjectModel> {
    private static final long serialVersionUID = -5776675940421351008L;

    public AreaObjectComboBox(boolean emptyItem) {
        super(emptyItem);
    }

    @Override
    protected String getStringRepresentation(AreaObjectModel t) {
        return t.getShortcut();
    }

    public ActionListener createLayerChangeListener(final AreaLayerProvider areaLayerProvider) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AreaLayerModel newLayer;
                AreaObjectModel selectedItem = (AreaObjectModel)AreaObjectComboBox.this.getSelectedItem();
                AreaLayerModel currentLayer = selectedItem == null ? null : selectedItem.getAreaLayer();
                if (!PrimitiveUtil.equalsNullSafe(currentLayer, newLayer = areaLayerProvider.getLayer())) {
                    DefaultComboBoxModel dcm = (DefaultComboBoxModel)AreaObjectComboBox.this.getModel();
                    dcm.removeAllElements();
                    if (newLayer != null) {
                        ArrayList<AreaObjectModel> list = new ArrayList<AreaObjectModel>(newLayer.countAreaObjects());
                        for (AreaObjectModel areaObject : newLayer.iterableAreaObjects()) {
                            list.add(areaObject);
                        }
                        Collections.sort(list, ComparatorUtils.chainedComparator(ComparatorUtils.transformedComparator(ComparatorUtils.naturalComparator(), new Transformer(){

                            @Override
                            public Object transform(Object input) {
                                return StringUtil.nullToEmpty(((AreaObjectModel)input).getShortcut());
                            }
                        }), ComparatorUtils.transformedComparator(ComparatorUtils.naturalComparator(), new Transformer(){

                            @Override
                            public Object transform(Object input) {
                                return StringUtil.nullToEmpty(((AreaObjectModel)input).getDisplayname());
                            }
                        })));
                        for (AreaObjectModel areaObjectModel : list) {
                            dcm.addElement(areaObjectModel);
                        }
                    }
                }
            }
        };
    }
}

