/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.area;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;

public class AreaObjectChooserTableModel
implements TableModel {
    private Map<Long, Tripel<String, String, Boolean>> all;
    private Map<Long, Tripel<String, String, Boolean>> searched;
    private long[] ids;
    private List<Long> searchIds;
    private List<TableModelListener> tableModelListeners;
    private String pattern = "";
    private String shortcutKey;

    public AreaObjectChooserTableModel(String shortcutKey) {
        this.shortcutKey = shortcutKey;
    }

    private void orgTable(Collection<Tripel<Long, String, String>> areas) {
        String sortProperty = ModelEnviroment.getProperties().getProperty("area.choose.sort");
        if (StringUtil.nullToEmpty(sortProperty).trim().equalsIgnoreCase("name")) {
            ArrayList<Tripel<Long, String, String>> list = new ArrayList<Tripel<Long, String, String>>(areas);
            Collections.sort(list, new Comparator<Tripel<Long, String, String>>(){

                @Override
                public int compare(Tripel<Long, String, String> tripel1, Tripel<Long, String, String> tripel2) {
                    return StringUtil.nullToEmpty(tripel1.getElement3()).compareTo(StringUtil.nullToEmpty(tripel2.getElement3()));
                }
            });
            areas = list;
        }
        this.all = new LinkedHashMap<Long, Tripel<String, String, Boolean>>();
        int size = areas.size();
        this.ids = new long[size];
        this.searchIds = new ArrayList<Long>(size);
        int counter = 0;
        for (Tripel<Long, String, String> area : areas) {
            Long id = area.getElement1();
            this.all.put(id, new Tripel<String, String, Boolean>(area.getElement2(), area.getElement3(), true));
            this.ids[counter] = id;
            this.searchIds.add(id);
            ++counter;
        }
        this.searched = new LinkedHashMap<Long, Tripel<String, String, Boolean>>(this.all);
        this.fireModelChangedInternal();
    }

    @Override
    public int getRowCount() {
        return this.searched == null ? 0 : this.searched.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String value = "";
        switch (columnIndex) {
            case 1: {
                value = ModelEnviroment.getMessageResolver().resolveMessage(this.shortcutKey, new Serializable[0]);
                break;
            }
            case 2: {
                value = ModelEnviroment.getMessageResolver().resolveMessage("messages.area.displayName", new Serializable[0]);
            }
        }
        return value;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Long id = this.searchIds.get(rowIndex);
        Tripel<String, String, Boolean> tripel = this.searched.get(id);
        switch (columnIndex) {
            case 0: {
                return tripel.getElement3();
            }
            case 1: {
                return tripel.getElement1();
            }
            case 2: {
                return tripel.getElement2();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Long id = this.searchIds.get(rowIndex);
        Tripel<String, String, Boolean> tripel = this.searched.get(id);
        switch (columnIndex) {
            case 0: {
                tripel.setElement3((Boolean)aValue);
            }
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (this.tableModelListeners == null) {
            this.tableModelListeners = new LinkedList<TableModelListener>();
        }
        this.tableModelListeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        if (this.tableModelListeners != null) {
            this.tableModelListeners.remove(l);
        }
    }

    public void searchShortcut(String pattern) {
        this.pattern = pattern;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '*') {
                sb.append(".*");
                continue;
            }
            if (!Character.isLetter(c) && !Character.isDigit(c)) {
                sb.append("\\").append(c);
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        String mPattern = sb.toString();
        this.searchIds.clear();
        this.searched.clear();
        Set<Map.Entry<Long, Tripel<String, String, Boolean>>> entrySet = this.all.entrySet();
        for (Map.Entry<Long, Tripel<String, String, Boolean>> entry : entrySet) {
            Tripel<String, String, Boolean> value = entry.getValue();
            if (!StringUtil.isBlank(mPattern) && !StringUtil.nullToEmpty(value.getElement1()).toLowerCase().matches(mPattern) && !StringUtil.nullToEmpty(value.getElement2()).toLowerCase().matches(mPattern)) continue;
            Long key = entry.getKey();
            this.searchIds.add(key);
            this.searched.put(key, value);
        }
        this.fireModelChangedInternal();
    }

    private void fireModelChangedInternal() {
        if (this.tableModelListeners != null) {
            TableModelEvent e = new TableModelEvent(this);
            for (TableModelListener tableModelListener : this.tableModelListeners) {
                tableModelListener.tableChanged(e);
            }
        }
    }

    public Set<Long> getSelectedIds() {
        HashSet<Long> selected = new HashSet<Long>();
        Set<Map.Entry<Long, Tripel<String, String, Boolean>>> entrySet = this.all.entrySet();
        for (Map.Entry<Long, Tripel<String, String, Boolean>> entry : entrySet) {
            Tripel<String, String, Boolean> value = entry.getValue();
            if (!value.getElement3().booleanValue()) continue;
            selected.add(entry.getKey());
        }
        return selected;
    }

    public Set<Tripel<Long, String, String>> getSelection() {
        HashSet<Tripel<Long, String, String>> selected = new HashSet<Tripel<Long, String, String>>();
        Set<Map.Entry<Long, Tripel<String, String, Boolean>>> entrySet = this.all.entrySet();
        for (Map.Entry<Long, Tripel<String, String, Boolean>> entry : entrySet) {
            Tripel<String, String, Boolean> value = entry.getValue();
            if (!value.getElement3().booleanValue()) continue;
            selected.add(new Tripel<Long, String, String>(entry.getKey(), value.getElement1(), value.getElement2()));
        }
        return selected;
    }

    public Set<Long> getNotSelectedIds() {
        HashSet<Long> selected = new HashSet<Long>();
        Set<Map.Entry<Long, Tripel<String, String, Boolean>>> entrySet = this.all.entrySet();
        for (Map.Entry<Long, Tripel<String, String, Boolean>> entry : entrySet) {
            Tripel<String, String, Boolean> value = entry.getValue();
            if (value.getElement3().booleanValue()) continue;
            selected.add(entry.getKey());
        }
        return selected;
    }

    public Map<Long, Tripel<String, String, Boolean>> getAll() {
        return this.all;
    }

    public void insertElements(Collection<Tripel<Long, String, String>> areas) {
        ArrayList<Tripel<Long, String, String>> newAll = new ArrayList<Tripel<Long, String, String>>(areas.size() + this.all.size());
        newAll.addAll(areas);
        for (Map.Entry<Long, Tripel<String, String, Boolean>> entry : this.all.entrySet()) {
            Tripel<String, String, Boolean> value = entry.getValue();
            Long key = entry.getKey();
            newAll.add(new Tripel<Long, String, String>(key, value.getElement1(), value.getElement2()));
        }
        this.orgTable(newAll);
        this.searchShortcut(this.pattern);
    }

    public void setElements(Collection<Tripel<Long, String, String>> areas) {
        this.orgTable(areas);
    }

    public void setSelectedValues(Collection<String> shortCuts) {
        for (Tripel<String, String, Boolean> tripel : this.all.values()) {
            tripel.setElement3(shortCuts.contains(tripel.getElement1()));
        }
        this.fireModelChangedInternal();
    }

    public void setSelectedIds(Collection<Long> areaObjectIds) {
        HashSet<Long> set = new HashSet<Long>(areaObjectIds);
        for (Map.Entry<Long, Tripel<String, String, Boolean>> entry : this.all.entrySet()) {
            Tripel<String, String, Boolean> tripel = entry.getValue();
            tripel.setElement3(set.contains(entry.getKey()));
        }
        this.fireModelChangedInternal();
    }

    public void setShownAreasSelected(boolean selected) {
        for (Tripel<String, String, Boolean> tripel : this.searched.values()) {
            tripel.setElement3(selected);
        }
        this.fireModelChangedInternal();
    }

    public void clearSelection() {
        for (Tripel<String, String, Boolean> tripel : this.all.values()) {
            tripel.setElement3(false);
        }
        this.fireModelChangedInternal();
    }
}

