/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.area;

import de.datomino.peppergis.client.auth.UserInformation;
import de.datomino.peppergis.client.gui.area.AreaLayerProvider;
import de.datomino.peppergis.client.gui.common.AbstractModelComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.UserRole;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxModel;
import org.apache.commons.lang.builder.EqualsBuilder;

public class AreaLayerComboBox
extends AbstractModelComboBox<AreaLayerModel>
implements AreaLayerProvider {
    private static final long serialVersionUID = -1934621840443644097L;

    public AreaLayerComboBox(ModelEnviroment modelEnviroment, boolean emptyItem, AreaObjectGenInfoDiscriminator[] areaObjectGenInfoDiscriminators, boolean writableOnly, boolean wage, Collection<AreaLayerModel> exclusions) {
        super(AreaLayerComboBox.fetchAreaLayers(modelEnviroment, areaObjectGenInfoDiscriminators, writableOnly, exclusions, wage), emptyItem);
    }

    public AreaLayerComboBox(ModelEnviroment modelEnviroment, boolean emptyItem, AreaObjectGenInfoDiscriminator[] areaObjectGenInfoDiscriminators, boolean writableOnly, boolean wage) {
        super(AreaLayerComboBox.fetchAreaLayers(modelEnviroment, areaObjectGenInfoDiscriminators, writableOnly, null, wage), emptyItem);
    }

    public AreaLayerComboBox(ModelEnviroment modelEnviroment, boolean emptyItem, AreaObjectGenInfoDiscriminator[] areaObjectGenInfoDiscriminators) {
        this(modelEnviroment, emptyItem, areaObjectGenInfoDiscriminators, false, false);
    }

    private static Collection<AreaLayerModel> fetchAreaLayers(ModelEnviroment modelEnviroment, AreaObjectGenInfoDiscriminator[] areaObjectGenInfoDiscriminators, boolean writableOnly, Collection<AreaLayerModel> exclusions, boolean wage) {
        UserInformation userInformation;
        Collection<AreaLayerModel> areaLayersForType = wage ? modelEnviroment.getAllCaller().getAreaCaller().getAreaLayerForWage(areaObjectGenInfoDiscriminators) : modelEnviroment.getAllCaller().getAreaCaller().getAreaLayersForType(areaObjectGenInfoDiscriminators);
        if (exclusions != null) {
            ArrayList<AreaLayerModel> filtered = new ArrayList<AreaLayerModel>(areaLayersForType.size());
            for (AreaLayerModel areaLayerModel : areaLayersForType) {
                if (exclusions.contains(areaLayerModel)) continue;
                filtered.add(areaLayerModel);
            }
            areaLayersForType = filtered;
        }
        if (writableOnly && !(userInformation = ModelEnviroment.getUserInformation()).isAdmin() && !userInformation.hasAtLeastOneRole(UserRole.AREA_ADMIN, UserRole.DISPONENT_SUPER)) {
            Map<UserRole, Set<Long>> rightInformation = userInformation.getRightInformation();
            Set<Long> set = rightInformation.get((Object)UserRole.AREA_ADMIN);
            ArrayList<AreaLayerModel> filtered = new ArrayList<AreaLayerModel>(areaLayersForType.size());
            if (set != null) {
                for (AreaLayerModel areaLayerModel : areaLayersForType) {
                    if (!set.contains(areaLayerModel.getId())) continue;
                    filtered.add(areaLayerModel);
                }
            }
            areaLayersForType = filtered;
        }
        return areaLayersForType;
    }

    public AreaLayerComboBox(Collection<AreaLayerModel> layers, boolean emptyItem) {
        super(layers, emptyItem);
    }

    @Override
    protected String getStringRepresentation(AreaLayerModel t) {
        return t.getDisplayname();
    }

    @Override
    public AreaLayerModel getLayer() {
        return (AreaLayerModel)this.getSelectedItem();
    }

    public void setLayer(String areaLayer) {
        int index = 0;
        if (areaLayer != null) {
            int i;
            ComboBoxModel model = this.getModel();
            int n = i = this.isEmptyItem() ? 1 : 0;
            while (i < model.getSize()) {
                AreaLayerModel layer = (AreaLayerModel)model.getElementAt(i);
                if (new EqualsBuilder().append(layer.getDisplayname(), areaLayer).isEquals()) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        this.setSelectedIndex(index);
    }
}

