/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.area;

import de.datomino.peppergis.client.model.area.AreaLayerModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.ktde.util.StringUtil;

public class AreaLayerChooserList
extends JPanel {
    private static final long serialVersionUID = 2490090332781622060L;
    private JList<AreaLayerModel> layers;

    public AreaLayerChooserList(Collection<AreaLayerModel> choosables) {
        super(new BorderLayout());
        this.buildLayout();
        this.fillValues(choosables);
    }

    private void fillValues(Collection<AreaLayerModel> choosables) {
        TreeSet<AreaLayerModel> sortedSet = new TreeSet<AreaLayerModel>(new Comparator<AreaLayerModel>(){

            @Override
            public int compare(AreaLayerModel o1, AreaLayerModel o2) {
                String s1 = o1 == null ? " " : StringUtil.nullToEmpty(o1.getDisplayname());
                String s2 = o2 == null ? " " : StringUtil.nullToEmpty(o2.getDisplayname());
                return s1.compareTo(s2);
            }
        });
        sortedSet.addAll(choosables);
        DefaultListModel dlm = (DefaultListModel)this.layers.getModel();
        dlm.clear();
        for (AreaLayerModel layer : sortedSet) {
            dlm.addElement(layer);
        }
    }

    private void buildLayout() {
        DefaultListModel dlm = new DefaultListModel();
        this.layers = new JList(dlm);
        this.layers.setSelectionMode(2);
        ListCellRenderer<AreaLayerModel> cellRenderer = this.layers.getCellRenderer();
        this.layers.setCellRenderer(new AreaLayerListCellRenderer(cellRenderer));
        this.add((Component)new JScrollPane(this.layers), "Center");
    }

    public void setSelectedAreaLayer(Collection<AreaLayerModel> layers) {
        DefaultListModel dlm = (DefaultListModel)this.layers.getModel();
        ArrayList<Integer> indicesList = new ArrayList<Integer>(layers.size());
        HashSet<AreaLayerModel> layerSet = new HashSet<AreaLayerModel>(layers);
        for (int i = 0; i < dlm.getSize(); ++i) {
            AreaLayerModel layer = (AreaLayerModel)dlm.getElementAt(i);
            if (!layerSet.contains(layer)) continue;
            indicesList.add(i);
        }
        int[] indices = new int[indicesList.size()];
        int i = 0;
        for (Integer v : indicesList) {
            indices[i++] = v;
        }
        this.layers.setSelectedIndices(indices);
    }

    public Collection<AreaLayerModel> getSelectedAreaLayers() {
        return this.layers.getSelectedValuesList();
    }

    @Override
    public void setEnabled(boolean b) {
        this.layers.setEnabled(b);
    }

    private class AreaLayerListCellRenderer
    implements ListCellRenderer<AreaLayerModel> {
        private ListCellRenderer cellRenderer;

        public AreaLayerListCellRenderer(ListCellRenderer<? super AreaLayerModel> cellRenderer) {
            this.cellRenderer = cellRenderer;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends AreaLayerModel> list, AreaLayerModel value, int index, boolean isSelected, boolean cellHasFocus) {
            String stringValue = value == null ? "" : value.getDisplayname();
            return this.cellRenderer.getListCellRendererComponent(list, stringValue, index, isSelected, cellHasFocus);
        }
    }
}

