/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.address;

import de.datomino.peppergis.client.gui.common.CountryComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.client.util.model.location.ParcelLocationWrapper;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.international.country.Country;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.WidthUnifier;
import java.awt.Component;
import java.io.Serializable;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.util.StringUtil;

public class BlockAdressPane
extends JPanel {
    private static final long serialVersionUID = 2495249125873701500L;
    private CountryComboBox country;
    private JTextField postcode;
    private JTextField city;
    private JTextField district;
    private JTextField street;
    private JFormattedTextField housenumber;
    private JTextField housenumberExtension;
    private JTextField key;
    private JComponent x;
    private JComponent y;

    public BlockAdressPane(boolean withKey, boolean withCountry, boolean withCoords, Country preselectedCountry) {
        this(withKey, withCountry, withCoords, null, preselectedCountry);
    }

    public BlockAdressPane(boolean withKey, boolean withCountry, boolean withCoords, String title, Country preselectedCountry) {
        this(withKey, withCountry, withCoords, title, null, null, preselectedCountry);
    }

    public BlockAdressPane(boolean withKey, boolean withCountry, boolean withCoords, String title, WidthUnifier unifierForLable, WidthUnifier widthUnifierForFields, Country preselectedCountry) {
        this(withKey, withCountry, withCoords, title, unifierForLable, widthUnifierForFields, false, preselectedCountry);
    }

    public BlockAdressPane(boolean withKey, boolean withCountry, boolean withCoords, String title, WidthUnifier unifierForLable, WidthUnifier widthUnifierForFields, boolean coordsAsTextField, Country preselectedCountry) {
        super(new SpringLayout());
        if (withKey) {
            this.key = new JTextField(20);
            this.addSubBlock("messages.parcel.parcelId", this.key, unifierForLable, widthUnifierForFields);
        }
        this.country = new CountryComboBox(withCountry, preselectedCountry);
        this.addSubBlock("address.country", this.country, unifierForLable, widthUnifierForFields);
        this.postcode = new JTextField(20);
        this.addSubBlock("address.postcode", this.postcode, unifierForLable, widthUnifierForFields);
        this.city = new JTextField(20);
        this.addSubBlock("address.city", this.city, unifierForLable, widthUnifierForFields);
        this.district = new JTextField(20);
        this.addSubBlock("address.district", this.district, unifierForLable, widthUnifierForFields);
        this.street = new JTextField(20);
        this.addSubBlock("address.street", this.street, unifierForLable, widthUnifierForFields);
        this.housenumber = new JFormattedTextField(new DecimalFormat("#"));
        this.addSubBlock("address.housenumber", this.housenumber, unifierForLable, widthUnifierForFields);
        this.housenumberExtension = new JTextField(20);
        this.addSubBlock("address.housenumberExt", this.housenumberExtension, unifierForLable, widthUnifierForFields);
        if (withCoords) {
            if (coordsAsTextField) {
                this.x = new JTextField(20);
                this.y = new JTextField(20);
            } else {
                this.x = new JSpinner(new SpinnerNumberModel(0.0, -180.0, 180.0, 1.0E-6));
                this.y = new JSpinner(new SpinnerNumberModel(0.0, -180.0, 180.0, 1.0E-6));
            }
            this.addSubBlock("gis.coordinate.longitude", this.x, unifierForLable, widthUnifierForFields);
            this.addSubBlock("gis.coordinate.latitude", this.y, unifierForLable, widthUnifierForFields);
        }
        if (title != null) {
            this.setBorder(new TitledBorder(title));
        }
        SpringUtilities.makeCompactGrid(this, 7 + (withKey ? 1 : 0) + (withCoords ? 2 : 0), 2, 2, 2, 2, 2);
    }

    private void addSubBlock(String key, Component component, WidthUnifier unifierForLable, WidthUnifier widthUnifierForFields) {
        JLabel label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(key, new Serializable[0]));
        if (unifierForLable != null) {
            unifierForLable.add(label);
        }
        this.add(label);
        if (widthUnifierForFields != null) {
            widthUnifierForFields.add(component);
        }
        this.add(component);
    }

    public void setEditable(boolean b) {
        this.setEnabled(b);
        if (this.key != null) {
            this.key.setEditable(b);
        }
        this.country.setEnabled(b);
        this.postcode.setEditable(b);
        this.city.setEditable(b);
        this.district.setEditable(b);
        this.street.setEditable(b);
        this.housenumber.setEditable(b);
        this.housenumberExtension.setEditable(b);
        if (this.x instanceof JSpinner) {
            this.x.setEnabled(b);
        }
        if (this.y instanceof JSpinner) {
            this.y.setEnabled(b);
        }
        if (this.x instanceof JTextComponent) {
            ((JTextComponent)this.x).setEditable(b);
        }
        if (this.y instanceof JTextComponent) {
            ((JTextComponent)this.y).setEditable(b);
        }
    }

    public void setParcel(ParcelModel parcel, ModelEnviroment modelEnviroment) {
        PostcodeDistrictRelationModel pdr;
        if (this.key != null) {
            String keyValue = StringUtil.nullToEmpty(parcel.getImportKey());
            this.key.setText(keyValue);
        }
        StreetModel street = parcel.getStreet();
        PostcodeModel postcode = null;
        DistrictModel district = null;
        CityModel city = null;
        if (street != null && (pdr = street.getPostcodeDistrictRelation()) != null) {
            postcode = pdr.getPostcode();
            district = pdr.getDistrict();
            if (district != null) {
                city = district.getCity();
            }
        }
        this.country.setSelectedItem(postcode.getCountry());
        this.postcode.setText(postcode.getName());
        this.city.setText(city.getName());
        this.district.setText(district.getName());
        this.street.setText(street.getName());
        this.housenumber.setText(parcel.getHouseNumber());
        this.housenumberExtension.setText(parcel.getHouseNumberExtension());
        ImmutablePoint geom = parcel.getGeom();
        this.setCoordinates(geom);
    }

    private void setCoordinates(ImmutablePoint geom) {
        if (this.x != null && this.y != null) {
            Double x = 0.0;
            Double y = 0.0;
            if (geom != null) {
                geom = (ImmutablePoint)geom.getTransformed(Wgs84Factory.INSTANCE);
                x = geom.getX();
                y = geom.getY();
            }
            if (this.x instanceof JSpinner) {
                ((JSpinner)this.x).setValue(x);
            }
            if (this.y instanceof JSpinner) {
                ((JSpinner)this.y).setValue(y);
            }
            if (this.x instanceof JTextComponent) {
                String xString = StringUtil.roundDouble(x, 6, false);
                ((JTextComponent)this.x).setText(xString);
            }
            if (this.y instanceof JTextComponent) {
                String yString = StringUtil.roundDouble(y, 6, false);
                ((JTextComponent)this.y).setText(yString);
            }
        }
    }

    public void setLocation(LocationWrapper locationWrapper, ModelEnviroment modelEnviroment) {
        if (locationWrapper instanceof ParcelLocationWrapper) {
            ParcelLocationWrapper parcelLocationWrapper = (ParcelLocationWrapper)locationWrapper;
            ParcelModel parcel = parcelLocationWrapper.getParcel();
            this.setParcel(parcel, modelEnviroment);
        } else {
            if (this.key != null) {
                this.key.setText("");
            }
            this.country.setSelectedItem(locationWrapper.getCountry());
            this.postcode.setText(locationWrapper.getPostcode());
            this.city.setText(locationWrapper.getCity());
            this.district.setText(locationWrapper.getDistrict());
            this.street.setText(locationWrapper.getStreet());
            this.housenumber.setText(StringUtil.nullToEmpty(locationWrapper.getHousenumber()));
            this.housenumberExtension.setText(locationWrapper.getHousenumberExtension());
            this.setCoordinates(locationWrapper.getGeoLocation());
        }
    }

    public void setLocation(LocationModel location, ModelEnviroment modelEnviroment) {
        LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
        this.setLocation(locationWrapper, modelEnviroment);
    }
}

