/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.address;

import de.datomino.peppergis.client.gui.common.CountryComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.dto.lucene.LocationSearchDto;
import de.datomino.util.international.country.Country;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.text.DecimalFormat;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.ktde.util.StringUtil;

public class AddressPane
extends JPanel {
    private static final long serialVersionUID = 6253980701290280109L;
    private CountryComboBox country;
    private JTextField postcode;
    private JTextField city;
    private JTextField district;
    private JTextField street;
    private JFormattedTextField housenumber;
    private JTextField housenumberExtension;
    private boolean markForSave;

    public AddressPane(boolean countryEmpty, String title, boolean markForSave, Country preselectedCountry) {
        super(new SpringLayout());
        this.markForSave = markForSave;
        this.buildLayout(countryEmpty, preselectedCountry);
        if (!StringUtil.isBlank(title)) {
            this.setBorder(new TitledBorder(title));
        }
    }

    public AddressPane(boolean countryEmpty, boolean markForSave, Country preselectedCountry) {
        this(countryEmpty, null, markForSave, preselectedCountry);
    }

    public AddressPane(Country preselectedCountry) {
        this(false, false, preselectedCountry);
    }

    public AddressPane(String title, Country preselectedCountry) {
        this(false, title, false, preselectedCountry);
    }

    private void buildLayout(boolean countryEmpty, Country preselectedCountry) {
        this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.street", new Serializable[0]) + (this.markForSave ? "*" : "")));
        this.street = new JTextField(30);
        this.add(this.street);
        this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.housenumber", new Serializable[0]) + (this.markForSave ? "*" : "")));
        JPanel housenumberPane = new JPanel(new SpringLayout());
        this.housenumber = new JFormattedTextField(new DecimalFormat("#"));
        this.housenumber.setColumns(3);
        this.housenumber.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.checkBlank();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.checkBlank();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.checkBlank();
            }

            private void checkBlank() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (AddressPane.this.housenumber.getValue() != null && StringUtil.isBlank(AddressPane.this.housenumber.getText())) {
                            AddressPane.this.housenumber.setValue(null);
                        }
                    }
                });
            }
        });
        housenumberPane.add(this.housenumber);
        housenumberPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.housenumberExt", new Serializable[0])));
        this.housenumberExtension = new JTextField(2);
        housenumberPane.add(this.housenumberExtension);
        SpringUtilities.makeCompactGrid(housenumberPane, 1, 3, 0, 0, 10, 2);
        this.add(housenumberPane);
        this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.postcode", new Serializable[0]) + (this.markForSave ? "*" : "")));
        JPanel cityPane = new JPanel(new SpringLayout());
        this.postcode = new JTextField(5);
        cityPane.add(this.postcode);
        cityPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.city", new Serializable[0]) + (this.markForSave ? "*" : "")));
        this.city = new JTextField(30);
        cityPane.add(this.city);
        SpringUtilities.makeCompactGrid(cityPane, 1, 3, 0, 0, 10, 2);
        this.add(cityPane);
        this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.district", new Serializable[0])));
        this.district = new JTextField(10);
        this.add(this.district);
        this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.country", new Serializable[0])));
        this.country = new CountryComboBox(true, preselectedCountry);
        JPanel countryPanel = new JPanel(new BorderLayout());
        countryPanel.add((Component)this.country, "West");
        this.add(countryPanel);
        this.add(new JLabel());
        this.add(new JLabel());
        SpringUtilities.makeCompactGrid(this, 3, 4, 5, 5, 10, 2);
    }

    public String getCity() {
        return this.city.getText();
    }

    public Country getCountry() {
        return this.country.getSelectedItem();
    }

    public String getDistrict() {
        return this.district.getText();
    }

    public Integer getHousenumber() {
        Number value = (Number)this.housenumber.getValue();
        return value == null ? null : Integer.valueOf(value.intValue());
    }

    public String getHousenumberExtension() {
        return this.housenumberExtension.getText();
    }

    public String getPostcode() {
        return this.postcode.getText();
    }

    public String getStreet() {
        return this.street.getText();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.city.setEditable(enabled);
        this.country.setEnabled(enabled);
        this.district.setEditable(enabled);
        this.housenumber.setEditable(enabled);
        this.housenumberExtension.setEditable(enabled);
        this.postcode.setEditable(enabled);
        this.street.setEditable(enabled);
    }

    public void setLocation(LocationModel location) {
        LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
        this.setLocation(locationWrapper);
    }

    public void clearValues() {
        this.country.setSelectedIndex(0);
        this.postcode.setText("");
        this.city.setText("");
        this.district.setText("");
        this.street.setText("");
        this.housenumber.setValue(null);
        this.housenumberExtension.setText("");
    }

    public LocationSearchDto getLocationSearchDto() {
        return new LocationSearchDto(this.getCountry(), this.getPostcode(), this.getCity(), this.getDistrict(), this.getStreet(), this.getHousenumber(), this.getHousenumberExtension());
    }

    public void addActionListener(final ActionListener actionListener) {
        this.country.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    actionListener.actionPerformed(new ActionEvent(AddressPane.this.country, 0, null));
                }
            }
        });
        this.postcode.addActionListener(actionListener);
        this.city.addActionListener(actionListener);
        this.district.addActionListener(actionListener);
        this.street.addActionListener(actionListener);
        this.housenumber.addActionListener(actionListener);
        this.housenumberExtension.addActionListener(actionListener);
    }

    public void setLocation(LocationWrapper locationWrapper) {
        if (locationWrapper == null) {
            this.city.setText("");
            this.country.setSelectedIndex(0);
            this.district.setText("");
            this.housenumber.setValue(null);
            this.housenumberExtension.setText("");
            this.postcode.setText("");
            this.street.setText("");
        } else {
            this.city.setText(StringUtil.nullToEmpty(locationWrapper.getCity()));
            this.country.setSelectedItem(locationWrapper.getCountry());
            this.district.setText(StringUtil.nullToEmpty(locationWrapper.getDistrict()));
            this.housenumber.setValue(locationWrapper.getHousenumber());
            this.housenumberExtension.setText(StringUtil.nullToEmpty(locationWrapper.getHousenumberExtension()));
            this.postcode.setText(StringUtil.nullToEmpty(locationWrapper.getPostcode()));
            this.street.setText(StringUtil.nullToEmpty(locationWrapper.getStreet()));
        }
    }
}

