/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.util.swing.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Serializable;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ErrorMessagesDialog
extends JDialog {
    private static final long serialVersionUID = -1910513719925796067L;

    public ErrorMessagesDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.setAlwaysOnTop(true);
    }

    public ErrorMessagesDialog(String errorDescription, Component parentComponent) {
        this((Frame)null, ModelEnviroment.getMessageResolver().resolveMessage("gui.common.errormessage.window.title", new Serializable[0]), true);
        this.init(errorDescription);
        JDialog.setDefaultLookAndFeelDecorated(true);
        this.setAlwaysOnTop(true);
    }

    private void init(String errorDescription) {
        try {
            this.setIconImage(ImageIO.read(ErrorMessagesDialog.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        JPanel errorPanel = new JPanel();
        JButton clearButton = new JButton();
        JLabel errorLabel = new JLabel();
        errorPanel.setLayout(null);
        errorPanel.setPreferredSize(new Dimension(820, 570));
        errorLabel.setForeground(Color.RED);
        errorDescription = errorDescription == null ? "" : errorDescription.replaceAll("/n", "<br>");
        errorLabel.setText("<html>" + errorDescription + "</html>");
        errorLabel.setBounds(new Rectangle(12, 12, 799, 459));
        errorLabel.setVerticalAlignment(1);
        clearButton.setBackground(Color.lightGray);
        clearButton.setBounds(new Rectangle(684, 532, 120, 25));
        clearButton.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.close", new Serializable[0]));
        clearButton.addActionListener(new ClearButtonListener(this));
        errorPanel.add((Component)errorLabel, null);
        errorPanel.add((Component)clearButton, null);
        this.getContentPane().add(errorPanel);
    }

    public static void creatAndShow(String errorDescription, Component parentComponent) {
        ErrorMessagesDialog errorDialog = new ErrorMessagesDialog(errorDescription, parentComponent);
        errorDialog.setAlwaysOnTop(true);
        errorDialog.pack();
        SwingUtils.centerDialog(errorDialog, SwingUtils.findWindowParent(parentComponent));
        errorDialog.setVisible(true);
    }

    private class ClearButtonListener
    implements ActionListener {
        ErrorMessagesDialog errorDialog;

        ClearButtonListener(ErrorMessagesDialog errorDialog) {
            this.errorDialog = errorDialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.errorDialog.dispose();
        }
    }
}

