/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.map.RendererNode;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.LetterModelUtil;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.ParcelModelUtil;
import de.datomino.peppergis.client.util.StreetNameComparator;
import de.datomino.peppergis.client.util.SubscriptionModelUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.type.RendererType;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.geo.ImmutablePoint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.swing.graphics.Polygon2D;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPointRenderer
implements Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPointRenderer.class);
    public static Double DEFAULTDENSITY;
    protected static Tupel<Color, Color> POINTCOLOR;
    protected static Tupel<Color, Color> STOPCOLOR;
    protected Graphics2D g2d;
    protected double upp;
    protected CoordinateFactory coordinateFactory;

    public DefaultPointRenderer(Graphics2D g2d, double upp, CoordinateFactory coordinateFactory) {
        this.g2d = g2d;
        this.upp = upp;
        this.coordinateFactory = coordinateFactory;
    }

    public void drawPoint(RendererNode node) {
        if (node.getFontground() == null) {
            this.g2d.setColor(POINTCOLOR.getElement1());
        } else {
            this.g2d.setColor(node.getFontground());
        }
        Coordinate c = this.coordinateFactory.createCoordinate(node.getCoordinate());
        Ellipse2D.Double center = DefaultPointRenderer.getCircle(c, node.getMargin() * (double)this.getPointDensity());
        this.g2d.fill(center);
    }

    public void drawCircle(RendererNode node) {
        this.g2d.setColor(node.getBackground());
        Coordinate c = this.coordinateFactory.createCoordinate(node.getCoordinate());
        Ellipse2D.Double circle = DefaultPointRenderer.getCircle(c, node.getMargin());
        this.g2d.fill(circle);
        this.g2d.setColor(node.getFontground());
        BasicStroke stroke = new BasicStroke((float)(node.getMargin() * 0.1));
        this.g2d.setStroke(stroke);
        this.g2d.draw(circle);
    }

    public void drawRectangle(RendererNode node) {
        this.drawShape(DefaultPointRenderer.getRectangle(this.coordinateFactory.createCoordinate(node.getCoordinate()), node.getWidth(), node.getHeight()), node, node.getMargin() / 5.0);
    }

    public void drawShape(Shape shape, RendererNode node, double widthOfLine) {
        if (node.getBackground() != null) {
            if (node.getType() == RendererType.PLAIN) {
                this.g2d.setColor(node.getBackground());
            } else if (node.getType() == RendererType.HATCH_LINE) {
                this.g2d.setColor(Color.WHITE);
            }
            this.g2d.fill(shape);
        }
        if (widthOfLine != 0.0) {
            Color fontground = node.getFontground();
            BasicStroke stroke = new BasicStroke((float)widthOfLine);
            if (node.getType() == RendererType.HATCH_LINE) {
                Rectangle bounds = shape.getBounds();
                this.g2d.drawImage((Image)this.createDiagonal(bounds.getWidth(), bounds.getHeight(), node.getBackground()), (int)bounds.getX(), (int)bounds.getY(), null);
            } else if (node.getType() == RendererType.DASH_LINE) {
                stroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{16.0f, 4.0f}, 0.0f);
            }
            this.g2d.setColor(fontground);
            this.g2d.setStroke(stroke);
            this.g2d.draw(shape);
        }
    }

    private BufferedImage createDiagonal(double width, double height, Color color) {
        BufferedImage bi = new BufferedImage((int)width, (int)height, 2);
        Graphics2D big = bi.createGraphics();
        big.setColor(color);
        Line2D.Double p = new Line2D.Double();
        for (double x = -height; x < width; x += height / 3.0) {
            p.setLine(x, height, x + height, 0.0);
            big.draw(p);
        }
        return bi;
    }

    private void drawRoof(RendererNode node) {
        Rectangle2D.Double rectangle = DefaultPointRenderer.getRectangle(this.coordinateFactory.createCoordinate(node.getCoordinate()), node.getWidth(), node.getHeight());
        Point2D.Double p1 = new Point2D.Double(rectangle.x, rectangle.y + rectangle.height);
        Point2D.Double p2 = new Point2D.Double(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        Point2D.Double p3 = new Point2D.Double(rectangle.getCenterX(), rectangle.y + rectangle.height + node.getMargin());
        this.drawTriangle(new Tripel<Point2D.Double, Point2D.Double, Point2D.Double>(p1, p2, p3), node);
    }

    public void drawTriangle(Tripel<Point2D.Double, Point2D.Double, Point2D.Double> triangle, RendererNode node) {
        this.g2d.setColor(node.getBackground());
        Polygon2D.Double polygon = new Polygon2D.Double();
        polygon.moveTo(triangle.getElement1());
        polygon.lineTo(triangle.getElement2());
        polygon.lineTo(triangle.getElement3());
        polygon.closePath();
        this.g2d.fill(polygon);
        this.g2d.setColor(node.getFontground());
        BasicStroke stroke = new BasicStroke((float)(node.getMargin() * 0.1));
        this.g2d.setStroke(stroke);
        this.g2d.draw(polygon);
    }

    public void drawNumber(RendererNode node) {
        this.g2d.setColor(node.getFontground() == null ? Color.BLACK : node.getFontground());
        Coordinate c = this.coordinateFactory.createCoordinate(node.getCoordinate());
        AffineTransform affineTransform = this.g2d.getTransform();
        double scaleX = affineTransform.getScaleX() / 1.5;
        double scaleY = affineTransform.getScaleY() / 1.5;
        AffineTransform tranform = AffineTransform.getScaleInstance(1.0 / scaleX, 1.0 / scaleY);
        this.g2d.transform(tranform);
        if (node.getMargin() >= 1.0) {
            double fontbase = node.getMargin();
            switch (node.getText().length() - 1) {
                case 0: {
                    fontbase *= 0.75;
                    break;
                }
                case 1: {
                    fontbase *= 0.75;
                    break;
                }
                case 2: {
                    fontbase *= 0.6;
                    break;
                }
                case 3: {
                    fontbase *= 0.5;
                    break;
                }
                default: {
                    fontbase *= 0.4;
                }
            }
            Point2D.Double dst = new Point2D.Double();
            AffineTransform.getScaleInstance(scaleX, scaleY).transform(new Point2D.Double(c.getX(), c.getY()), dst);
            Font font = new Font(node.getFontName(), node.getFontStyle(), (int)Math.round(fontbase / this.upp));
            String value = String.valueOf(node.getText());
            TextLayout textLayout = new TextLayout(value == null || value.equals("") ? " " : value, font, this.g2d.getFontRenderContext());
            Rectangle2D bounds = textLayout.getBounds();
            textLayout.draw(this.g2d, (float)(dst.getX() - bounds.getCenterX()), (float)(dst.getY() - bounds.getCenterY()));
            this.g2d.setTransform(affineTransform);
        }
    }

    public void drawText(RendererNode node) {
        this.drawText(node, false, false);
    }

    public void drawText(RendererNode node, boolean midpoint, boolean shadow) {
        AffineTransform affineTransform = this.g2d.getTransform();
        double scaleX = affineTransform.getScaleX() / 1.5;
        double scaleY = affineTransform.getScaleY() / 1.5;
        AffineTransform tranformForText = AffineTransform.getScaleInstance(1.0 / scaleX, 1.0 / scaleY);
        this.g2d.transform(tranformForText);
        String text = node.getText();
        if (text == null || text.equals("")) {
            text = " ";
        }
        Point2D.Double dst = new Point2D.Double();
        Coordinate reformed = this.coordinateFactory.createCoordinate(node.getCoordinate());
        double textX = reformed.getX() + node.getMargin();
        double textY = reformed.getY();
        if (midpoint) {
            double d = node.getMargin() * (double)node.getFontSize();
            textX = reformed.getX() - (double)node.getText().length() * d / 2.0;
            textY = reformed.getY() - d;
        }
        Point2D.Double point = new Point2D.Double(textX, textY);
        this.g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        AffineTransform.getScaleInstance(scaleX, scaleY).transform(point, dst);
        Font font = new Font(node.getFontName(), node.getFontStyle(), node.getFontSize());
        TextLayout textLayout = new TextLayout(text, font, this.g2d.getFontRenderContext());
        if (shadow) {
            this.g2d.setColor(new Color(150, 150, 150));
            textLayout.draw(this.g2d, (float)(dst.getX() + node.getPadding()), (float)(dst.getY() + node.getPadding()));
        }
        this.g2d.setColor(node.getFontground());
        textLayout.draw(this.g2d, (float)(dst.getX() + node.getPadding() - 1.0), (float)(dst.getY() + node.getPadding() - 1.0));
        this.g2d.setTransform(affineTransform);
    }

    public void drawImage(RendererNode node) {
        AffineTransform affineTransform = this.g2d.getTransform();
        double scaleX = affineTransform.getScaleX();
        double scaleY = affineTransform.getScaleY();
        AffineTransform tranformed = AffineTransform.getScaleInstance(1.0 / scaleX, 1.0 / scaleY);
        this.g2d.transform(tranformed);
        Image image = node.getImage();
        Point2D.Double dst = new Point2D.Double();
        Point2D.Double point = new Point2D.Double(this.coordinateFactory.createCoordinate(node.getCoordinate()).getX(), this.coordinateFactory.createCoordinate(node.getCoordinate()).getY());
        AffineTransform.getScaleInstance(scaleX, scaleY).transform(point, dst);
        this.g2d.drawImage(image, (int)dst.getX() - image.getWidth(null) / 2, (int)dst.getY() - image.getHeight(null) / 2, null);
        this.g2d.setTransform(affineTransform);
    }

    public void drawBuilding(RendererNode node, boolean isWithRoof) {
        this.drawRectangle(node);
        if (isWithRoof) {
            this.drawRoof(node);
        }
        if (node.getText() != null) {
            node.setFontground(this.getNumberColor(node.getBackground()));
            this.drawNumber(node);
        }
    }

    public void drawBuildings(List<ParcelModel> parcels, double margin, CoordinateFactory coordinateFactory, Color colorOfParcel, boolean withIndex, Map<Model, Integer> indexMap) {
        this.drawBuildingsWithSubscription(parcels, null, margin, coordinateFactory, Color.BLACK, colorOfParcel, withIndex, indexMap);
    }

    public void drawBuildingsWithSubscription(Collection<ParcelModel> parcels, Collection<SubscriptionModel> subscriptions, double margin, CoordinateFactory coordinateFactory, Color lineColor, Color colorOfParcel, boolean withIndex, Map<Model, Integer> indexMap) {
        int index = 1;
        for (ParcelModel parcel : parcels) {
            Integer mIndex;
            int indexToDraw = index++;
            if (indexMap != null && (mIndex = indexMap.get(parcel)) != null) {
                indexToDraw = mIndex;
            }
            String string = String.valueOf(indexToDraw);
            if (!ParcelModelUtil.checkGeomOfParcel(parcel)) continue;
            ImmutablePoint point = parcel.getGeom();
            if (point == null) {
                LOGGER.error("a parcel with null point: " + parcel);
                continue;
            }
            point = (ImmutablePoint)point.getTransformed(coordinateFactory);
            Color color = ParcelModelUtil.getColorOfParcel(parcel, subscriptions, null, colorOfParcel);
            if (!withIndex) {
                string = FormUtil.getStringDisplay(parcel.getHouseNumber()) + FormUtil.getStringDisplay(parcel.getHouseNumberExtension());
            }
            RendererNode node = new RendererNode(string, point.getCoordinate(), lineColor, color, margin);
            this.drawBuilding(node, false);
        }
    }

    private Color getNumberColor(Color bgColor) {
        if (bgColor.getRed() == Color.WHITE.getRed() && bgColor.getGreen() == Color.WHITE.getGreen() && bgColor.getBlue() == Color.WHITE.getBlue()) {
            return Color.BLACK;
        }
        return Color.WHITE;
    }

    public void drawStops(List<StopModel> stops, double margin, Map<TourModel, Color> tourColorCache, boolean withIndex) {
        Collections.sort(stops, new StreetNameComparator());
        int index = 1;
        Color lastColor = null;
        for (StopModel stop : stops) {
            Color fontground;
            String string = String.valueOf(index++);
            ImmutablePoint point = LocationModelUtil.getGeom(stop.getLocation());
            if (point == null) continue;
            point.getTransformed(this.getCoordinateFactory());
            Color color = fontground = tourColorCache == null ? Color.BLACK : tourColorCache.get(stop.getTourPart().getTour());
            if (fontground == Color.BLACK && tourColorCache != null) {
                fontground = GeoUtil.getNextColor(lastColor);
                tourColorCache.put(stop.getTourPart().getTour(), fontground);
                lastColor = GeoUtil.getNextColor(lastColor);
            }
            RendererNode node = new RendererNode("", point.getCoordinate(), fontground, Color.WHITE, margin);
            this.drawCircle(node);
            if (withIndex) {
                node.setText(string);
            } else {
                node.setText("A");
            }
            this.drawNumber(node);
        }
    }

    public void drawPois(List<PoiModel> pois, double margin, boolean withIndex) {
        Collections.sort(pois, new StreetNameComparator());
        int index = 1;
        for (PoiModel poi : pois) {
            String string = String.valueOf(index++);
            ImmutablePoint point = LocationModelUtil.getGeom(poi.getLocation());
            if (point == null) continue;
            point.getTransformed(this.getCoordinateFactory());
            RendererNode node = new RendererNode("", point.getCoordinate(), Color.BLACK, Color.WHITE, margin);
            this.drawCircle(node);
            if (withIndex) {
                node.setText("F" + string);
            } else {
                node.setText("F");
            }
            this.drawNumber(node);
        }
    }

    public Map<SubscriptionModel, Rectangle2D.Double> drawSubscriptions(List<Tupel<SubscriptionModel, Integer>> subscriptions, double margin, Map<AreaObjectModel, Color> areaObjectColorCache, boolean isWithIndex, Color background) {
        HashMap<SubscriptionModel, Rectangle2D.Double> drawedSubscriptionsOnMap = new HashMap<SubscriptionModel, Rectangle2D.Double>();
        int index = subscriptions.size();
        Color lastColor = null;
        boolean showHouseNumber = false;
        if (StringUtil.isTrue(ModelEnviroment.getProperties().getProperty("subscription.renderer.houseNumber.show"))) {
            showHouseNumber = true;
        }
        Collections.reverse(subscriptions);
        for (Tupel<SubscriptionModel, Integer> subscriptionTupel : subscriptions) {
            index = subscriptionTupel.getElement2() == null ? index : subscriptionTupel.getElement2();
            SubscriptionModel subscription = subscriptionTupel.getElement1();
            LocationModel location = subscription.getLocation();
            LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
            Object string = null;
            if (isWithIndex) {
                string = String.valueOf(index--);
            } else if (showHouseNumber) {
                string = FormUtil.getStringDisplay(locationWrapper.getHousenumber() == null ? null : String.valueOf(locationWrapper.getHousenumber())) + FormUtil.getStringDisplay(locationWrapper.getHousenumberExtension());
            }
            if (!SubscriptionModelUtil.checkGeomOfSubscription(subscription)) continue;
            ImmutablePoint point = locationWrapper.getGeoLocation();
            if (GeoUtil.isNullPoint(point)) {
                LOGGER.error("a subscription with null point: " + subscription);
                continue;
            }
            point = (ImmutablePoint)point.getTransformed(this.coordinateFactory);
            Color colorOfAreaObject = areaObjectColorCache.get(subscription.getAreaObject());
            if (colorOfAreaObject == null) {
                while ((colorOfAreaObject = GeoUtil.getNextColor(lastColor)).equals(Color.WHITE)) {
                }
                areaObjectColorCache.put(subscription.getAreaObject(), colorOfAreaObject);
                lastColor = GeoUtil.getNextColor(lastColor);
            }
            RendererNode node = new RendererNode((String)string, point.getCoordinate(), colorOfAreaObject, background, margin);
            this.drawBuilding(node, false);
            drawedSubscriptionsOnMap.put(subscription, DefaultPointRenderer.getRectangle(point.getCoordinate(), margin, margin * 0.75));
        }
        for (SubscriptionModel subscription : drawedSubscriptionsOnMap.keySet()) {
            int count = 0;
            Rectangle2D.Double rectangle = (Rectangle2D.Double)drawedSubscriptionsOnMap.get(subscription);
            Color colorOfAreaObject = areaObjectColorCache.get(subscription.getAreaObject());
            for (Rectangle2D.Double r : drawedSubscriptionsOnMap.values()) {
                if (!r.contains(rectangle)) continue;
                ++count;
            }
            if (count <= true) continue;
            Coordinate c = this.coordinateFactory.createCoordinate(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            RendererNode node = new RendererNode(String.valueOf(count), c, margin);
            node.setFontground(colorOfAreaObject);
            node.setFontStyle(1);
            this.drawText(node);
        }
        Collections.reverse(subscriptions);
        return drawedSubscriptionsOnMap;
    }

    public Polygon2D.Double drawPin(Coordinate c, double margin, Color colorOfPin) {
        Coordinate reformed = this.coordinateFactory.createCoordinate(c);
        Point2D.Double p1 = new Point2D.Double(reformed.getX(), reformed.getY());
        Point2D.Double p2 = new Point2D.Double(reformed.getX() + margin, reformed.getY() + margin * 2.0);
        Point2D.Double p3 = new Point2D.Double(reformed.getX() - margin, reformed.getY() + margin * 2.0);
        RendererNode node = new RendererNode(null, null, colorOfPin, colorOfPin, margin);
        this.drawTriangle(new Tripel<Point2D.Double, Point2D.Double, Point2D.Double>(p1, p2, p3), node);
        Coordinate cOfCircle = reformed.getFactory().createCoordinate(reformed.getX(), reformed.getY() + margin * 2.0);
        node = new RendererNode(null, cOfCircle, colorOfPin, colorOfPin, margin);
        this.drawCircle(node);
        Polygon2D.Double polygon = new Polygon2D.Double();
        polygon.moveTo(p1);
        polygon.lineTo(p2);
        polygon.lineTo(new Point2D.Double(reformed.getX(), reformed.getY() + margin * 3.0));
        polygon.lineTo(p3);
        polygon.closePath();
        return polygon;
    }

    public void drawInfoBox(List<String> infoBox, Coordinate c, Color colorOfText, double margin) {
        Coordinate reformed = this.coordinateFactory.createCoordinate(c);
        double left = reformed.getX();
        double top = reformed.getY();
        Rectangle2D.Double rectangleOfBox = new Rectangle2D.Double();
        rectangleOfBox.height = (double)infoBox.size() * margin * 2.5;
        rectangleOfBox.width = (double)FormUtil.getMaxWordCount(infoBox) * margin * 1.2;
        rectangleOfBox.x = left;
        rectangleOfBox.y = top - rectangleOfBox.height;
        RendererNode node = new RendererNode(null, null, margin);
        this.drawShape(rectangleOfBox, node, margin / 10.0);
        double marginTop = 0.0;
        for (String info : infoBox) {
            Coordinate coordinate = this.coordinateFactory.createCoordinate(left, top - margin * 2.0 - marginTop);
            RendererNode n = new RendererNode(info, coordinate, margin * 0.75);
            n.setFontground(colorOfText);
            this.drawText(n);
            marginTop += margin * 2.0;
        }
    }

    public static Rectangle2D.Double getRectangle(Coordinate c, double width, double height) {
        Rectangle2D.Double rectangle = new Rectangle2D.Double();
        rectangle.x = c.getX() - width / 2.0;
        rectangle.y = c.getY() - height / 2.0;
        rectangle.width = width;
        rectangle.height = height;
        return rectangle;
    }

    public static Ellipse2D.Double getCircle(Coordinate c, double r) {
        Ellipse2D.Double circle = new Ellipse2D.Double();
        circle.x = c.getX() - r;
        circle.y = c.getY() - r;
        circle.width = 2.0 * r;
        circle.height = 2.0 * r;
        return circle;
    }

    public void setCoordinateFactory(CoordinateFactory coordinateFactory) {
        this.coordinateFactory = coordinateFactory;
    }

    public CoordinateFactory getCoordinateFactory() {
        return this.coordinateFactory;
    }

    protected boolean isSelected(Object o) {
        return false;
    }

    public float getPointDensity() {
        if (DEFAULTDENSITY == null) {
            try {
                String newAttribute = ModelEnviroment.getProperties().getProperty("tour.point.density");
                DEFAULTDENSITY = ClientFormUtil.getNumber(newAttribute.trim()).doubleValue();
            }
            catch (Exception e) {
                DEFAULTDENSITY = 9.0;
            }
        }
        return (float)(DEFAULTDENSITY * Math.pow(this.upp, -0.1) * this.upp);
    }

    public Map<LetterModel, Rectangle2D.Double> drawLetters(List<Tupel<LetterModel, Integer>> letters, double margin, Map<AreaObjectModel, Color> areaObjectColorCache, boolean isWithIndex, Color background) {
        HashMap<LetterModel, Rectangle2D.Double> drawedlettersOnMap = new HashMap<LetterModel, Rectangle2D.Double>();
        int index = letters.size();
        Color lastColor = null;
        boolean showHouseNumber = false;
        if (StringUtil.isTrue(ModelEnviroment.getProperties().getProperty("subscription.renderer.houseNumber.show"))) {
            showHouseNumber = true;
        }
        Collections.reverse(letters);
        for (Tupel<LetterModel, Integer> letterTupel : letters) {
            index = letterTupel.getElement2() == null ? index : letterTupel.getElement2();
            LetterModel letter = letterTupel.getElement1();
            LocationModel location = letter.getLocation();
            LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
            Object string = null;
            if (isWithIndex) {
                string = String.valueOf(index--);
            } else if (showHouseNumber) {
                string = FormUtil.getStringDisplay(locationWrapper.getHousenumber() == null ? null : String.valueOf(locationWrapper.getHousenumber())) + FormUtil.getStringDisplay(locationWrapper.getHousenumberExtension());
            }
            if (!LetterModelUtil.checkGeomOfLetter(letter)) continue;
            ImmutablePoint point = locationWrapper.getGeoLocation();
            if (GeoUtil.isNullPoint(point)) {
                LOGGER.error("a subscription with null point: " + letter);
                continue;
            }
            point = (ImmutablePoint)point.getTransformed(this.coordinateFactory);
            Color colorOfAreaObject = areaObjectColorCache.get(letter.getAreaObject());
            if (colorOfAreaObject == null) {
                while ((colorOfAreaObject = GeoUtil.getNextColor(lastColor)).equals(Color.WHITE)) {
                }
                areaObjectColorCache.put(letter.getAreaObject(), colorOfAreaObject);
                lastColor = GeoUtil.getNextColor(lastColor);
            }
            RendererNode node = new RendererNode((String)string, point.getCoordinate(), colorOfAreaObject, background, margin);
            this.drawBuilding(node, false);
            drawedlettersOnMap.put(letter, DefaultPointRenderer.getRectangle(point.getCoordinate(), margin, margin * 0.75));
        }
        for (LetterModel letter : drawedlettersOnMap.keySet()) {
            int count = 0;
            Rectangle2D.Double rectangle = (Rectangle2D.Double)drawedlettersOnMap.get(letter);
            Color colorOfAreaObject = areaObjectColorCache.get(letter.getAreaObject());
            for (Rectangle2D.Double r : drawedlettersOnMap.values()) {
                if (!r.contains(rectangle)) continue;
                ++count;
            }
            if (count <= true) continue;
            Coordinate c = this.coordinateFactory.createCoordinate(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            RendererNode node = new RendererNode(String.valueOf(count), c, margin);
            node.setFontground(colorOfAreaObject);
            node.setFontStyle(1);
            this.drawText(node);
        }
        Collections.reverse(letters);
        return drawedlettersOnMap;
    }

    static {
        POINTCOLOR = new Tupel<Color, Color>(Color.BLACK, Color.BLACK);
        STOPCOLOR = new Tupel<Color, Color>(Color.BLACK, Color.WHITE);
    }

    protected class Rhombus
    extends Path2D.Double {
        private static final long serialVersionUID = -208643850002240924L;
        private double width;
        private double height;

        public Rhombus(double width, double height) {
            this.width = width;
            this.height = height;
            this.moveTo(0.0, height / 2.0);
            this.lineTo(width / 2.0, 0.0);
            this.lineTo(width, height / 2.0);
            this.lineTo(width / 2.0, height);
            this.closePath();
        }

        public Shape createShape(Coordinate c) {
            Coordinate newC = DefaultPointRenderer.this.coordinateFactory.createCoordinate(c);
            double x = newC.getX();
            double y = newC.getY();
            AffineTransform at = AffineTransform.getTranslateInstance(x -= this.width / 2.0, y -= this.height / 2.0);
            return at.createTransformedShape(this);
        }
    }
}

