/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public abstract class AbstractListCellRenderer<O>
implements ListCellRenderer {
    protected Color colorOfText = Color.BLACK;
    protected Color colorOfBg = Color.WHITE;
    private boolean withIndex;
    private ListCellRenderer listCellRenderer;

    public AbstractListCellRenderer(ListCellRenderer origListCellRenderer) {
        this.listCellRenderer = origListCellRenderer;
    }

    public AbstractListCellRenderer() {
        this(new DefaultListCellRenderer());
    }

    public Component getListCellRendererComponent(JList list, Object object, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)this.listCellRenderer.getListCellRendererComponent(list, object, index, isSelected, cellHasFocus);
        String stringFromValue = this.getStringFromValue(object);
        if (this.withIndex) {
            stringFromValue = String.valueOf(index + 1) + ". " + stringFromValue;
        }
        label.setText(stringFromValue);
        label.setFont(UIManager.getDefaults().getFont("TextField.font"));
        if (!isSelected) {
            label.setBackground(this.colorOfBg);
        }
        label.setForeground(this.colorOfText);
        return label;
    }

    protected abstract String getStringFromValue(O var1);

    public void setWithIndex(boolean withIndex) {
        this.withIndex = withIndex;
    }
}

