/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui;

import de.datomino.peppergis.PeppergisConstants;
import de.datomino.peppergis.client.gui.DefaultPointRenderer;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.SolidLineRenderer;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.geo.AbstractImmutableGeoObject;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.util.GeoUtils;
import de.datomino.util.swing.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ktde.math.projection.Coordinate;
import org.ktde.swing.navigator.DefaultMouseManipulator;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.swing.navigator.listener.NavigatorRendererActivateEvent;
import org.ktde.swing.navigator.listener.NavigatorRendererActiveListener;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractLayerRenderer
extends DefaultMouseManipulator
implements NavigatorRenderer {
    protected NavigatorPanel navigatorPanel;
    private boolean active;
    protected boolean withIndex;
    private boolean forMotorSegment;
    private boolean forFootSegment;
    private boolean forBikeSegment;
    private Component parent;
    protected ModelEnviroment modelEnviroment;
    private List<NavigatorRendererActiveListener> navigatorPanelActiveListeners = new ArrayList<NavigatorRendererActiveListener>();
    private Coordinate center;
    private int sortOrder = Integer.MAX_VALUE;

    public AbstractLayerRenderer(boolean active, boolean withIndex, Component parent, ModelEnviroment modelEnviroment) {
        this.active = active;
        this.withIndex = withIndex;
        this.parent = parent;
        this.modelEnviroment = modelEnviroment;
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setWithIndex(boolean withIndex) {
        this.withIndex = withIndex;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void setNavigatorPanel(NavigatorPanel navigatorPanel) {
        this.navigatorPanel = navigatorPanel;
    }

    public void setActive(boolean active) {
        if (this.active != active) {
            this.active = active;
            this.navigatorPanel.repaint(10L);
            this.fireActiveChanged();
        }
    }

    @Override
    public void addNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        this.navigatorPanelActiveListeners.add(navigatorPanelActiveListener);
    }

    @Override
    public void removeNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        this.navigatorPanelActiveListeners.remove(navigatorPanelActiveListener);
    }

    protected void fireActiveChanged() {
        NavigatorRendererActivateEvent navigatorPanelActivateEvent = new NavigatorRendererActivateEvent(this, this.isActive());
        for (NavigatorRendererActiveListener navigatorPanelActiveListener : this.navigatorPanelActiveListeners) {
            navigatorPanelActiveListener.valueChanged(navigatorPanelActivateEvent);
        }
    }

    protected Window getParentWindow() {
        return SwingUtils.findWindowParent(this.parent);
    }

    public void drawSegments(Map<ImmutablePoint, Set<Tripel<ImmutableLineString, ImmutableLineString, ImmutableLineString>>> map, Graphics2D g2d, double upp) {
        if (this.forMotorSegment || this.forFootSegment || this.forBikeSegment) {
            SolidLineRenderer lineRenderer = new SolidLineRenderer(upp, false, this.navigatorPanel.getCoordinateFactory());
            for (ImmutablePoint point : map.keySet()) {
                Set<Tripel<ImmutableLineString, ImmutableLineString, ImmutableLineString>> set = map.get(point);
                for (Tripel<ImmutableLineString, ImmutableLineString, ImmutableLineString> tripel : set) {
                    ImmutablePoint shortestPerpendicular;
                    AbstractImmutableGeoObject geoObject;
                    ImmutableLineString bikeSegment;
                    ImmutableLineString motorSegment = this.forMotorSegment ? tripel.getElement1() : null;
                    ImmutableLineString footSegment = this.forFootSegment ? tripel.getElement2() : null;
                    ImmutableLineString immutableLineString = bikeSegment = this.forBikeSegment ? tripel.getElement3() : null;
                    if (point != null && motorSegment != null && (geoObject = GeoUtil.createLineString(point, shortestPerpendicular = GeoUtil.getShortestPerpendicular(point, motorSegment).getElement2())) instanceof ImmutableLineString) {
                        lineRenderer.render(g2d, (ImmutableLineString)geoObject, new Tupel<Color, Object>(PeppergisConstants.MOTOR_SEGMENT_COLOR, null), 1.0f);
                    }
                    if (point != null && footSegment != null && (geoObject = GeoUtils.getLineString(point, shortestPerpendicular = GeoUtil.getShortestPerpendicular(point, footSegment).getElement2())) instanceof ImmutableLineString) {
                        lineRenderer.render(g2d, (ImmutableLineString)geoObject, new Tupel<Color, Object>(PeppergisConstants.FOOT_SEGMENT_COLOR, null), 1.0f);
                    }
                    if (point == null || bikeSegment == null || !((geoObject = GeoUtils.getLineString(point, shortestPerpendicular = GeoUtil.getShortestPerpendicular(point, bikeSegment).getElement2())) instanceof ImmutableLineString)) continue;
                    lineRenderer.render(g2d, (ImmutableLineString)geoObject, new Tupel<Color, Object>(PeppergisConstants.BIKE_SEGMENT_COLOR, null), 1.0f);
                }
            }
        }
    }

    protected void postPaintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        if (this.center != null) {
            DefaultPointRenderer pointRenderer = new DefaultPointRenderer(g2d, upp, this.navigatorPanel.getCoordinateFactory());
            pointRenderer.drawPin(this.center, 8.0 * upp, Color.BLUE);
        }
    }

    public void setForMotorSegment(boolean forMotorSegment) {
        this.forMotorSegment = forMotorSegment;
    }

    public void setForFootSegment(boolean forFootSegment) {
        this.forFootSegment = forFootSegment;
    }

    public void setForBikeSegment(boolean forBikeSegment) {
        this.forBikeSegment = forBikeSegment;
    }

    public void center(Coordinate coordinate) {
        this.center = coordinate;
        if (this.center != null) {
            this.navigatorPanel.center(coordinate);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }
}

