/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui;

import de.datomino.peppergis.client.gui.CompletableJTextField;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.MultiLineHeaderRenderer;
import de.datomino.util.swing.SwingUtils;
import de.datomino.util.swing.TableHeaderWithComponentLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import org.ktde.util.StringUtil;

public abstract class AbstractFilterTable<O>
extends JTable {
    private static final long serialVersionUID = 5872040387407250771L;
    private static final Comparator<Object> FILTER_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object arg0, Object arg1) {
            if (arg0 == null && arg1 == null) {
                return 0;
            }
            if (arg0 == null) {
                return -1;
            }
            if (arg1 == null) {
                return 1;
            }
            return arg0.toString().compareToIgnoreCase(arg1.toString());
        }
    };
    private Collection<O> os;
    protected int columnCount;
    private CompletableJTextField<Object>[] filters;
    private Collection<Integer> columnWithoutFilter;
    private Component parent;

    public AbstractFilterTable(Collection<O> os, int columnCount, Collection<Integer> columnWithoutFilter, Component parent) {
        super(new DefaultTableModel());
        this.os = os;
        this.columnCount = columnCount;
        this.filters = new CompletableJTextField[columnCount];
        this.columnWithoutFilter = columnWithoutFilter == null ? new HashSet(0) : columnWithoutFilter;
        this.parent = parent;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getSelectionModel().setSelectionMode(0);
        this.setRowSorter((RowSorter<? extends TableModel>)new TableRowSorter<TableModel>(this.getModel()){

            @Override
            public Comparator<?> getComparator(int column) {
                return AbstractFilterTable.this.getRowSorterComparator(column);
            }
        });
        ((TableRowSorter)this.getRowSorter()).setStringConverter(new TableStringConverter(){

            @Override
            public String toString(TableModel model, int row, int column) {
                Object value = model.getValueAt(row, column);
                return AbstractFilterTable.this.getValueString(value, row, column);
            }
        });
        this.reload(true);
    }

    protected abstract Object[] createRowData(O var1, int var2);

    protected abstract String[] createColumnHeader();

    public void reload(boolean initFilters) {
        List<O> list = this.sortAndFilter(this.os);
        Object[][] dataVector = this.createDataVector(list);
        this.fillColumnFilters(dataVector, initFilters);
        ((DefaultTableModel)this.getModel()).setDataVector(dataVector, this.createColumnHeader());
        ((DefaultTableModel)this.getModel()).fireTableDataChanged();
        this.setTableStyle();
    }

    public boolean inColumnFilters(O o) {
        for (int column = 1; column < this.columnCount; ++column) {
            String cell;
            CompletableJTextField<Object> field;
            if (this.columnWithoutFilter.contains(column) || (field = this.filters[column]) == null || field.getSelectedObject() == null) continue;
            Object s = field.getSelectedObject();
            Object[] row = this.createRowData(o, 0);
            String string = cell = row[column] == null ? "" : row[column];
            if (!(cell instanceof Collection ? !((Collection)((Object)cell)).contains(s) : !cell.equals(s))) continue;
            return false;
        }
        return true;
    }

    protected int compareO(O o1, O o2) {
        return 0;
    }

    protected String getValueString(Object value, int row, int column) {
        return value == null ? "" : value.toString();
    }

    protected Comparator<?> getRowSorterComparator(int column) {
        return FILTER_COMPARATOR;
    }

    protected void setTableStyle() {
        MultiLineHeaderRenderer headerHenderer = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setHeaderRenderer(headerHenderer);
        }
        JTableHeader th = this.getTableHeader();
        th.setLayout(new TableHeaderWithComponentLayout());
        th.add((Component)new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("buttons.clear", new Serializable[0])){
            private static final long serialVersionUID = 7230307199937774097L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                for (int i = 0; i < AbstractFilterTable.this.filters.length; ++i) {
                    CompletableJTextField field = AbstractFilterTable.this.filters[i];
                    if (field == null) continue;
                    field.setSelectedObject(null);
                }
                AbstractFilterTable.this.reload(false);
            }
        }), (Object)0);
        for (int i = 1; i < this.columnCount; ++i) {
            if (this.filters[i] == null) continue;
            th.add(this.filters[i], (Object)i);
        }
    }

    private synchronized List<O> sortAndFilter(Collection<O> os) {
        ArrayList<O> list = new ArrayList<O>(os.size());
        for (O o : os) {
            if (!this.inColumnFilters(o)) continue;
            list.add(o);
        }
        Collections.sort(list, new Comparator<O>(){

            @Override
            public int compare(O o1, O o2) {
                return AbstractFilterTable.this.compareO(o1, o2);
            }
        });
        return list;
    }

    private Object[][] createDataVector(List<O> list) {
        Object[][] dataVector = new Object[list.size()][this.columnCount];
        int row = 0;
        for (O o : list) {
            dataVector[row] = this.createRowData(o, row);
            ++row;
        }
        return dataVector;
    }

    private void fillColumnFilters(Object[][] dataVector, boolean initFilters) {
        if (initFilters) {
            Integer column = 1;
            while (column < this.columnCount) {
                if (!this.columnWithoutFilter.contains(column)) {
                    this.filters[column.intValue()] = this.createFilterField(dataVector, column);
                }
                Integer n = column;
                Integer n2 = column = Integer.valueOf(column + 1);
            }
        }
    }

    private CompletableJTextField<Object> createFilterField(Object[][] dataVector, int column) {
        HashSet<Object> valueSet = new HashSet<Object>();
        for (int row = 0; row < dataVector.length; ++row) {
            Object object = dataVector[row][column];
            if (object == null || StringUtil.isBlank(object.toString())) continue;
            if (object instanceof Collection) {
                valueSet.addAll((Collection)object);
                continue;
            }
            valueSet.add(object);
        }
        return this.createField(valueSet);
    }

    private CompletableJTextField<Object> createField(Set<Object> valueSet) {
        Vector<Object> vector = new Vector<Object>(valueSet);
        Collections.sort(vector, FILTER_COMPARATOR);
        CompletableJTextField<Object> textField = new CompletableJTextField<Object>(null, SwingUtils.findWindowParent(this.parent)){
            private static final long serialVersionUID = 9048687346533657328L;

            @Override
            public void makeSelection() {
                super.makeSelection();
                AbstractFilterTable.this.reload(false);
            }
        };
        textField.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        textField.getDataList().addAll(vector);
        return textField;
    }

    public void setOs(Collection<O> os) {
        this.os = os;
    }
}

