/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui;

import de.datomino.peppergis.client.gui.AutoCompleteTextField;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public abstract class AbstractAutoCompleteComboBox<O>
extends JComboBox {
    private static final long serialVersionUID = -7972787658860298714L;
    private AutoTextFieldEditor<O> autoTextFieldEditor;
    private AutoCompleteComboxBoxModel model;
    private List<O> datas;
    private boolean isFired = false;

    public AbstractAutoCompleteComboBox() {
        this(Collections.emptyList());
    }

    public AbstractAutoCompleteComboBox(List<O> datas) {
        this.autoTextFieldEditor = new AutoTextFieldEditor(datas);
        this.setEditor(this.autoTextFieldEditor);
        this.setEditable(true);
        this.datas = datas;
        this.model = new AutoCompleteComboxBoxModel(datas.toArray());
        super.setModel(this.model);
    }

    public abstract String toDisplayString(Object var1);

    private O getObject(Object object) {
        Object o = null;
        if (object != null && !(object instanceof String) || this.datas == null) {
            o = object;
        } else {
            for (O data : this.datas) {
                String displayString = this.toDisplayString(data);
                if (!displayString.equals(object)) continue;
                o = data;
            }
        }
        return (O)o;
    }

    public boolean isCaseSensitive() {
        return ((AutoTextFieldEditor)this.autoTextFieldEditor).getAutoTextFieldEditor().isCaseSensitive();
    }

    public void setCaseSensitive(boolean caseSensitive) {
        ((AutoTextFieldEditor)this.autoTextFieldEditor).getAutoTextFieldEditor().setCaseSensitive(caseSensitive);
    }

    public List<O> getDataList() {
        return ((AutoTextFieldEditor)this.autoTextFieldEditor).getAutoTextFieldEditor().getDataList();
    }

    public void setDataList(List<O> datas) {
        this.datas = Collections.unmodifiableList(datas);
        ((AutoTextFieldEditor)this.autoTextFieldEditor).getAutoTextFieldEditor().setDataList(datas);
        this.model = new AutoCompleteComboxBoxModel(datas.toArray());
        super.setModel(new AutoCompleteComboxBoxModel(datas.toArray()));
    }

    public void addItem(Object item) {
        ArrayList<O> arrayList = new ArrayList<O>(this.datas);
        arrayList.add(item);
        this.setDataList(arrayList);
    }

    @Override
    public void setSelectedItem(Object data) {
        if (!this.isFired) {
            this.isFired = true;
            super.setSelectedItem(this.getObject(data));
            this.isFired = false;
        }
    }

    public O getSelectedItem() {
        return this.getObject(super.getSelectedItem());
    }

    @Override
    protected void fireActionEvent() {
        if (!this.isFired) {
            super.fireActionEvent();
        }
    }

    public void clear() {
        this.model.setSelectedItem(null);
    }

    protected class AutoCompleteComboxBoxModel
    extends DefaultComboBoxModel {
        private static final long serialVersionUID = -591004235276789357L;
        private Object selectedObject;

        private AutoCompleteComboxBoxModel(Object[] datas) {
            super(datas);
        }

        @Override
        public String getElementAt(int index) {
            return AbstractAutoCompleteComboBox.this.toDisplayString(super.getElementAt(index));
        }

        @Override
        protected void fireContentsChanged(Object obj, int i, int j) {
            if (!AbstractAutoCompleteComboBox.this.isFired) {
                super.fireContentsChanged(obj, i, j);
            }
        }

        @Override
        public void setSelectedItem(Object o) {
            String displayString = AbstractAutoCompleteComboBox.this.toDisplayString(o);
            AbstractAutoCompleteComboBox.this.autoTextFieldEditor.getAutoTextFieldEditor().setText(displayString);
            this.selectedObject = o;
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedObject;
        }
    }

    private class AutoTextFieldEditor<O>
    extends BasicComboBoxEditor {
        private AutoTextFieldEditor(List<O> datas) {
            this.editor = new AutoCompleteTextField<O>(datas, AbstractAutoCompleteComboBox.this);
            Color background = AbstractAutoCompleteComboBox.this.getBackground();
            this.editor.setBackground(new Color(background.getRGB()));
        }

        private AutoCompleteTextField<O> getAutoTextFieldEditor() {
            return (AutoCompleteTextField)this.editor;
        }
    }
}

