/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.frey;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FreyRequestHandlingUtil {
    private static final String TERMINATED = "TERMINATED";

    public static byte[] getXml(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        int c = in.read();
        while (c >= 0) {
            char ch = (char)c;
            if (!Character.isDigit(ch)) {
                if (ch == '<') break;
                throw new IOException();
            }
            sb.append(ch);
            c = in.read();
        }
        int length = Integer.parseInt(sb.toString());
        byte[] result = new byte[length];
        result[0] = 60;
        in.read(result, 1, length - 1);
        return result;
    }

    public static byte[] getXml1(InputStream in) {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        Sax sax = new Sax();
        try {
            SAXParser saxParser = spf.newSAXParser();
            saxParser.parse(in, (DefaultHandler)sax);
            return sax.getXml();
        }
        catch (SAXException e) {
            if (TERMINATED.equals(e.getMessage())) {
                return sax.getXml();
            }
            throw new RuntimeException(e);
        }
        catch (IOException | ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Sax
    extends DefaultHandler {
        private StringBuilder sb = new StringBuilder();
        private int depth = 0;

        private Sax() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            this.sb.append("<").append(localName);
            for (int i = 0; i < attributes.getLength(); ++i) {
                String key = attributes.getLocalName(i);
                String value = attributes.getValue(i);
                this.sb.append(" ").append(key).append("=\"").append(StringEscapeUtils.escapeXml(value)).append("\"");
            }
            this.sb.append(">");
            ++this.depth;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            this.sb.append("</").append(localName).append(">");
            --this.depth;
            if (this.depth == 0) {
                throw new SAXException(FreyRequestHandlingUtil.TERMINATED);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
            String value = new String(ch, start, length);
            this.sb.append(StringEscapeUtils.escapeXml(value));
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            this.sb.append("<xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\">");
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
            throw new SAXException(FreyRequestHandlingUtil.TERMINATED);
        }

        public byte[] getXml() {
            try {
                return this.sb.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

