/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.frey;

import de.datomino.peppergis.client.frey.CoordinateAndAreasDto;
import de.datomino.peppergis.client.frey.FreyHandler;
import de.datomino.peppergis.client.frey.FreyRequestHandlingThread;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.swing.PepperGisDesktopApplication;
import de.datomino.util.callback.CallBack;

public class FreyHandlerImpl
implements FreyHandler {
    private PepperGisDesktopApplication pepperGisDesktopApplication;
    private CallBack<?, CoordinateAndAreasDto> proposalCallBack;
    private CallBack<?, CoordinateAndAreasDto> wednesdaySelectCallBack;
    private CallBack<?, CoordinateAndAreasDto> saturdaySelectCallBack;

    public FreyHandlerImpl(PepperGisDesktopApplication pepperGisDesktopApplication) {
        this.pepperGisDesktopApplication = pepperGisDesktopApplication;
        this.initialize();
    }

    @Override
    public void sendProposalKeys(CoordinateAndAreasDto coordinateAndAreasDto) {
        if (this.proposalCallBack != null) {
            this.proposalCallBack.execute((CoordinateAndAreasDto[])new CoordinateAndAreasDto[]{coordinateAndAreasDto});
        }
    }

    private void initialize() {
        String portString = ModelEnviroment.getProperties().getProperty("frey.port");
        int port = 60000;
        try {
            port = Integer.parseInt(portString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        FreyRequestHandlingThread freyRequestHandlingThread = new FreyRequestHandlingThread(port, this.pepperGisDesktopApplication);
        freyRequestHandlingThread.start();
    }

    @Override
    public void setProposalCallBack(CallBack<?, CoordinateAndAreasDto> callBack) {
        this.proposalCallBack = callBack;
    }

    @Override
    public void setWednesdaySelectCallBack(CallBack<?, CoordinateAndAreasDto> callBack) {
        this.wednesdaySelectCallBack = callBack;
    }

    @Override
    public void setSaturdaySelectCallBack(CallBack<?, CoordinateAndAreasDto> callBack) {
        this.saturdaySelectCallBack = callBack;
    }

    @Override
    public void sendSaturdaySelectAreas(CoordinateAndAreasDto coordinateAndAreasDto) {
        if (this.saturdaySelectCallBack != null) {
            this.saturdaySelectCallBack.execute((CoordinateAndAreasDto[])new CoordinateAndAreasDto[]{coordinateAndAreasDto});
        }
    }

    @Override
    public void sendWednesdaySelectAreas(CoordinateAndAreasDto coordinateAndAreasDto) {
        if (this.wednesdaySelectCallBack != null) {
            this.wednesdaySelectCallBack.execute((CoordinateAndAreasDto[])new CoordinateAndAreasDto[]{coordinateAndAreasDto});
        }
    }
}

