/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.file;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;
import org.ktde.util.StringUtil;

public final class FileUtil {
    private FileUtil() {
    }

    public static File saveFile(Map<String, byte[]> content, Component parent, String fileExtension) throws IOException {
        return FileUtil.saveFile(content, parent, fileExtension, null);
    }

    public static File saveFile(Map<String, byte[]> content, Component parent, final String fileExtension, File currentDir) throws IOException {
        final String dotFileExtension = "." + fileExtension;
        JFileChooser fileChooser = currentDir == null ? new JFileChooser() : new JFileChooser(currentDir);
        FileFilter filter = new FileFilter(){

            @Override
            public String getDescription() {
                return fileExtension;
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(dotFileExtension);
            }
        };
        fileChooser.addChoosableFileFilter(filter);
        fileChooser.setFileFilter(filter);
        int d2 = 0;
        block3: do {
            int d = fileChooser.showSaveDialog(parent);
            switch (d) {
                case 0: {
                    for (Map.Entry<String, byte[]> entry : content.entrySet()) {
                        File file = fileChooser.getSelectedFile();
                        String oName = file.getName();
                        String suffix = entry.getKey();
                        if (!StringUtil.isBlank(suffix)) {
                            int lIndex = oName.lastIndexOf(46);
                            String newName = lIndex >= 0 ? oName.substring(0, lIndex) + "_" + suffix + "." + oName.substring(lIndex + 1) : oName + "_" + suffix;
                            file = new File(file.getParent(), newName);
                        }
                        oName = file.getName();
                        if (fileChooser.getFileFilter() == filter && !oName.endsWith(dotFileExtension)) {
                            file = new File(file.getParent(), oName + dotFileExtension);
                        }
                        d2 = 0;
                        if (file.exists()) {
                            d2 = JOptionPane.showConfirmDialog(parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question.overwriteFile", new Serializable[]{oName}), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 1);
                        }
                        if (d2 != 0) continue;
                        FileUtils.writeByteArrayToFile(file, entry.getValue());
                    }
                    continue block3;
                }
                default: {
                    d2 = 2;
                }
            }
        } while (d2 == 1);
        File selectedFile = fileChooser.getSelectedFile();
        return selectedFile == null ? null : selectedFile.getParentFile();
    }
}

