/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.communication.listener;

import de.datomino.peppergis.client.communication.AreaCaller;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectModelImpl;
import de.datomino.peppergis.client.model.area.DetaillessAreaObjectGeometryModel;
import de.datomino.peppergis.client.model.area.DetaillessAreaObjectGeometryModelImpl;
import de.datomino.peppergis.client.model.area.DetaillessLevelModel;
import de.datomino.util.geo.ImmutablePolygonKind;
import java.util.ArrayList;
import org.ktde.model.ValueChangeEvent;
import org.ktde.model.ValueChangeListener;

public class AreaObjectDetaillessUpdateListener
implements ValueChangeListener {
    private AreaCaller areaCaller;

    public AreaObjectDetaillessUpdateListener(AreaCaller areaCaller) {
        this.areaCaller = areaCaller;
    }

    @Override
    public void valueChanged(ValueChangeEvent e) {
        Object source = e.getSource();
        if (source instanceof AreaObjectModel) {
            AreaObjectModel areaObjectModel = (AreaObjectModel)source;
            ValueChangeEvent.Type type = e.getType();
            switch (type) {
                case DELETE: {
                    this.deleteDetailless(areaObjectModel);
                    break;
                }
                case UPDATE: {
                    if (e.getProperty() != AreaObjectModelImpl.AreaObjectModelEnum.GEOM) break;
                    ImmutablePolygonKind geom = areaObjectModel.getGeom();
                    if (geom == null) {
                        this.deleteDetailless(areaObjectModel);
                        break;
                    }
                    this.updateDetailless(areaObjectModel);
                }
            }
        }
    }

    private void updateDetailless(AreaObjectModel areaObjectModel) {
        this.deleteDetailless(areaObjectModel);
        AreaLayerModel areaLayer = areaObjectModel.getAreaLayer();
        if (areaLayer != null) {
            ImmutablePolygonKind geom = areaObjectModel.getGeom();
            for (DetaillessLevelModel detaillessLevelModel : areaLayer.iterableDetaillessLevels()) {
                Double fromScale = detaillessLevelModel.getFromScale();
                Double tolerance = detaillessLevelModel.getTolerance();
                ImmutablePolygonKind reduced = this.areaCaller.createReducedGeom(geom, tolerance);
                DetaillessAreaObjectGeometryModelImpl detaillessAreaObjectGeometryModel = new DetaillessAreaObjectGeometryModelImpl();
                detaillessAreaObjectGeometryModel.setAreaObject(areaObjectModel);
                detaillessAreaObjectGeometryModel.setFromScale(fromScale);
                detaillessAreaObjectGeometryModel.setGeom(reduced);
            }
        }
    }

    private void deleteDetailless(AreaObjectModel areaObjectModel) {
        ArrayList<DetaillessAreaObjectGeometryModel> list = new ArrayList<DetaillessAreaObjectGeometryModel>(areaObjectModel.countDetaillessAreaObjectGeometries());
        for (DetaillessAreaObjectGeometryModel detaillessAreaObjectGeometryModel : areaObjectModel.iterableDetaillessAreaObjectGeometries()) {
            list.add(detaillessAreaObjectGeometryModel);
        }
        for (DetaillessAreaObjectGeometryModel detaillessAreaObjectGeometryModel : list) {
            detaillessAreaObjectGeometryModel.setAreaObject(null);
            detaillessAreaObjectGeometryModel.delete();
        }
    }
}

