/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.communication;

import de.datomino.peppergis.client.communication.AbstractCaller;
import de.datomino.peppergis.client.communication.GeoServerStub;
import de.datomino.peppergis.client.communication.WageCaller;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.ModelCache;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.DeliveryRoundRelationModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.client.model.wage.WageHolidaySetModel;
import de.datomino.peppergis.client.model.wage.WageParameterModel;
import de.datomino.peppergis.dto.area.AreaObjectDto;
import de.datomino.peppergis.dto.area.DeliveryRoundRelationDto;
import de.datomino.peppergis.dto.wage.WageExportDto;
import de.datomino.peppergis.dto.wage.WageModifierDto;
import de.datomino.peppergis.dto.wage.WageParameterDto;
import de.datomino.peppergis.type.WageParameterStatus;
import de.datomino.peppergis.wage.HistoryAreaTourSearchDto;
import de.datomino.peppergis.wage.ProductWeightParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.ktde.model.ValueChangeListener;
import org.ktde.util.datatypes.Tripel;

public class WageCallerImpl
extends AbstractCaller
implements WageCaller {
    public WageCallerImpl(GeoServerStub geoServerStub, ModelCache modelCache) {
        super(geoServerStub, modelCache);
    }

    @Override
    public List<HistoryAreaTourModel> searchHistoryAreaTours(HistoryAreaTourSearchDto historyAreaTourSearchDto) {
        return this.convertDtosToModels(this.getGeoServerStub().getWageBi().searchHistoryAreaTours(historyAreaTourSearchDto), new ValueChangeListener[0]);
    }

    @Override
    public Collection<WageParameterModel> fetchWageParameterWithStatus(WageParameterStatus[] statuses) {
        return this.convertDtosToModels(this.getGeoServerStub().getWageBi().fetchWageParameterWithStatus(statuses), new ValueChangeListener[0]);
    }

    @Override
    public Collection<AreaObjectModel> fetchAreaObjectsWithWageParameter(WageParameterModel wageParameterModel) {
        WageParameterDto proxy = wageParameterModel == null ? null : (WageParameterDto)this.convertModelToDtoProxy(wageParameterModel);
        return this.convertDtosToModels(this.getGeoServerStub().getWageBi().fetchAreaObjectsWithWageParameter(proxy), new ValueChangeListener[0]);
    }

    @Override
    public Collection<String> fetchAreaLayersFromHistoryAreaTour() {
        return this.getGeoServerStub().getWageBi().fetchAreaLayersFromHistoryAreaTour();
    }

    @Override
    public WageExportDto exportTimeWageOnServer(Collection<String> layerNames, Collection<Date> dates) {
        return this.getGeoServerStub().getWageBi().exportTimeWageOnServer(layerNames, dates);
    }

    @Override
    public Collection<String> fetchAreaShortcutsFromHistoryAreaTour(String layerName) {
        return this.getGeoServerStub().getWageBi().fetchAreaShortcutsFromHistoryAreaTour(layerName);
    }

    @Override
    public List<WageModifierDto> getHistoryAreaTourModifiers() {
        return this.getGeoServerStub().getWageBi().getHistoryAreaTourModifiers();
    }

    @Override
    public boolean isHistoryAreaTourPdfCreationActive() {
        return this.getGeoServerStub().getWageBi().isHistoryAreaTourPdfCreationActive();
    }

    @Override
    public Collection<WageHolidaySetModel> fetchAllWageHolidaySets() {
        return this.convertDtosToModels(this.getGeoServerStub().getWageBi().fetchAllWageHolidaySets(), new ValueChangeListener[0]);
    }

    @Override
    public ProductWeightParameter getProductWeightParameter() {
        return this.getGeoServerStub().getWageBi().getProductWeightParameter();
    }

    @Override
    public Collection<HistoryAreaTourModel> getHistoryAreaTourForDelivererUpdate(Collection<Tripel<AreaObjectModel, Date, DeliveryRoundRelationModel>> tripelList) {
        ArrayList<Tripel<AreaObjectDto, Date, DeliveryRoundRelationDto>> list = new ArrayList<Tripel<AreaObjectDto, Date, DeliveryRoundRelationDto>>(tripelList.size());
        for (Tripel<AreaObjectModel, Date, DeliveryRoundRelationModel> tripel : tripelList) {
            list.add(new Tripel<AreaObjectDto, Date, DeliveryRoundRelationDto>((AreaObjectDto)this.convertModelToDtoProxy((Model)tripel.getElement1()), tripel.getElement2(), (DeliveryRoundRelationDto)this.convertModelToDtoProxy((Model)tripel.getElement3())));
        }
        return this.convertDtosToModels(this.getGeoServerStub().getWageBi().getHistoryAreaTourForDelivererUpdate(list), new ValueChangeListener[0]);
    }
}

