/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.communication;

import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticQualifiedLocationDto;
import de.datomino.logistic.dto.qualifiers.LocationQualifierDescriptorDto;
import de.datomino.peppergis.client.communication.AbstractCaller;
import de.datomino.peppergis.client.communication.GeoServerStub;
import de.datomino.peppergis.client.communication.StreetNetCaller;
import de.datomino.peppergis.client.model.ModelCache;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.ImportedLocationModel;
import de.datomino.peppergis.client.model.filter.ParcelFilterModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.map.ParcelFilterPatternSetupModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.PlaceModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModelImpl;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.dto.Dto;
import de.datomino.peppergis.dto.area.AreaLayerDto;
import de.datomino.peppergis.dto.area.AreaObjectDto;
import de.datomino.peppergis.dto.exporter.DefaultExportDto;
import de.datomino.peppergis.dto.location.RangeType;
import de.datomino.peppergis.dto.map.ParcelAttributeValueDescriptorDto;
import de.datomino.peppergis.dto.map.ParcelDto;
import de.datomino.peppergis.dto.map.PlaceDto;
import de.datomino.peppergis.dto.map.PostcodeDistrictRelationDto;
import de.datomino.peppergis.dto.map.PostcodeDto;
import de.datomino.peppergis.dto.map.SegmentDto;
import de.datomino.peppergis.dto.map.StreetDto;
import de.datomino.peppergis.exception.ClientExportException;
import de.datomino.peppergis.type.SegmentType;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePointDto;
import de.datomino.util.geo.dto.ImmutablePolygonDto;
import de.datomino.util.international.country.Country;
import de.datomino.util.message.error.ErrorMessages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.ktde.math.projection.Coordinate;
import org.ktde.model.ValueChangeListener;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public class StreetNetCallerImpl
extends AbstractCaller
implements StreetNetCaller {
    public StreetNetCallerImpl(GeoServerStub geoServerStub, ModelCache modelCache) {
        super(geoServerStub, modelCache);
    }

    @Override
    public Collection<PostcodeModel> fetchPostcodeAreas(Coordinate topLeft, Coordinate bottomRight) {
        Collection<PostcodeDto> dtos = this.getGeoServerStub().getStreetNetBi().fetchPostcodeAreas(ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(topLeft)), ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(bottomRight)));
        ArrayList<PostcodeModel> models = new ArrayList<PostcodeModel>(dtos.size());
        for (PostcodeDto dto : dtos) {
            models.add((PostcodeModel)this.getModelCache().getModel(dto));
        }
        return models;
    }

    @Override
    public Collection<ParcelModel> fetchParcels(Coordinate topLeft, Coordinate bottomRight, boolean withRel) {
        Collection<? extends ParcelDto> dtos = this.getGeoServerStub().getStreetNetBi().fetchParcels(ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(topLeft)), ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(bottomRight)), withRel);
        return this.convertDtosToModels(dtos, new ValueChangeListener[0]);
    }

    @Override
    public ParcelModel fetchParcelById(Long id) {
        return (ParcelModel)this.getModelCache().getModel(this.getGeoServerStub().getStreetNetBi().fetchParcelById(id));
    }

    @Override
    public Collection<Tupel<Tupel<ParcelModel, ImmutablePoint>, Double>> searchParcelOrCoordinateRange(Country country, String postcode, String city, String district, String street, String housenumberStart, String housenumberExtensionStart, String housenumberEnd, String housenumberExtensionEnd, RangeType rangeType) {
        Collection<Tupel<Tupel<ParcelDto, ImmutablePointDto>, Double>> dtos = this.getGeoServerStub().getStreetNetBi().searchParcelOrCoordinateRange(country, postcode, city, district, street, housenumberStart, housenumberExtensionStart, housenumberEnd, housenumberExtensionEnd, rangeType);
        ArrayList<Tupel<Tupel<ParcelModel, ImmutablePoint>, Double>> list = new ArrayList<Tupel<Tupel<ParcelModel, ImmutablePoint>, Double>>(dtos.size());
        for (Tupel<Tupel<ParcelDto, ImmutablePointDto>, Double> tupel : dtos) {
            ImmutablePointDto pointDto = tupel.getElement1().getElement2();
            ImmutablePoint point = pointDto == null ? null : (ImmutablePoint)pointDto.getGeoObject();
            list.add(new Tupel<Tupel<ParcelModel, ImmutablePoint>, Double>(new Tupel<ParcelModel, ImmutablePoint>((ParcelModel)this.getModelCache().getModel((Dto)tupel.getElement1().getElement1()), point), tupel.getElement2()));
        }
        return list;
    }

    @Override
    public Collection<Tripel<ParcelModel, Double, String>> searchParcelRange(Country country, String postcode, String city, String district, String street, String housenumberStart, String housenumberExtensionStart, String housenumberEnd, String housenumberExtensionEnd, RangeType rangeType) {
        Collection<Tripel<ParcelDto, Double, String>> dtos = this.getGeoServerStub().getStreetNetBi().searchParcelRange(country, postcode, city, district, street, housenumberStart, housenumberExtensionStart, housenumberEnd, housenumberExtensionEnd, rangeType);
        ArrayList<Tripel<ParcelModel, Double, String>> list = new ArrayList<Tripel<ParcelModel, Double, String>>(dtos.size());
        for (Tripel<ParcelDto, Double, String> tupel : dtos) {
            list.add(new Tripel<ParcelModel, Double, String>((ParcelModel)this.getModelCache().getModel((Dto)tupel.getElement1()), tupel.getElement2(), tupel.getElement3()));
        }
        return list;
    }

    @Override
    public Collection<Tupel<ImmutablePoint, Double>> searchCoordinateRange(Country country, String postcode, String city, String district, String street, String housenumberRangeStart, String housenumberExtensionRangeStart, String housenumberRangeEnd, String housenumberExtensionRangeEnd, RangeType rangeType) {
        Collection<Tupel<ImmutablePointDto, Double>> dtos = this.getGeoServerStub().getStreetNetBi().searchCoordinateRange(country, postcode, city, district, street, housenumberRangeStart, housenumberExtensionRangeStart, housenumberRangeEnd, housenumberExtensionRangeEnd, rangeType);
        ArrayList<Tupel<ImmutablePoint, Double>> result = new ArrayList<Tupel<ImmutablePoint, Double>>(dtos.size());
        for (Tupel<ImmutablePointDto, Double> tupel : dtos) {
            ImmutablePointDto pointDto = tupel.getElement1();
            ImmutablePoint point = pointDto == null ? null : (ImmutablePoint)pointDto.getGeoObject();
            result.add(new Tupel<ImmutablePoint, Double>(point, tupel.getElement2()));
        }
        return result;
    }

    @Override
    public Collection<LogisticQualifiedLocationDto> searchAddress(LogisticLocationDto<Long> logisticLocationDto, Integer maxCount, boolean exact, boolean parcelOnly) {
        return this.getGeoServerStub().getStreetNetBi().searchAddress(logisticLocationDto, maxCount, exact, parcelOnly);
    }

    @Override
    public Collection<LogisticQualifiedLocationDto> searchAddressWithQualifiersParameterized(LogisticLocationDto<?> logisticLocationDto, Integer maxCount, LocationQualifierDescriptorDto<?>[] qualifiers) {
        return this.getGeoServerStub().getStreetNetBi().searchAddressWithQualifiersParameterized(logisticLocationDto, maxCount, qualifiers);
    }

    @Override
    public Collection<ParcelAttributeValueDescriptorModel> fetchAllParcelAttributeValueDescriptors() {
        Collection<ParcelAttributeValueDescriptorDto> dtos = this.getGeoServerStub().getStreetNetBi().fetchAllParcelAttributeValueDescriptors();
        return this.convertDtosToModels(dtos, new ValueChangeListener[0]);
    }

    @Override
    public Collection<PostcodeModel> fetchPostcodesForCountry(Country country, boolean parcelAttachedElementsOnly) {
        List<PostcodeModel> postcodes = this.convertDtosToModels(this.getGeoServerStub().getStreetNetBi().fetchPostcodesForCountry(country, parcelAttachedElementsOnly), new ValueChangeListener[0]);
        return postcodes;
    }

    @Override
    public Collection<StreetModel> fetchStreetsByPostcodeDistrictRelations(Collection<PostcodeDistrictRelationModel> postcodeDistrictRelationModels) {
        ArrayList<PostcodeDistrictRelationDto> dtos = new ArrayList<PostcodeDistrictRelationDto>(postcodeDistrictRelationModels.size());
        for (PostcodeDistrictRelationModel postcodeDistrictRelationModel : postcodeDistrictRelationModels) {
            dtos.add(((PostcodeDistrictRelationModelImpl)postcodeDistrictRelationModel).createProxy());
        }
        return this.convertDtosToModels(this.getGeoServerStub().getStreetNetBi().fetchStreetsByPostcodeDistrictRelations(dtos), new ValueChangeListener[0]);
    }

    @Override
    public Collection<ParcelModel> fetchParcelsWithNullGeom() {
        Collection<ParcelDto> dtos = this.getGeoServerStub().getStreetNetBi().fetchParcelsWithNullGeom();
        HashSet<ParcelModel> models = new HashSet<ParcelModel>(dtos.size());
        for (ParcelDto dto : dtos) {
            ParcelModel parcel = (ParcelModel)super.convertDtoToModel(dto, new ValueChangeListener[0]);
            models.add(parcel);
        }
        return models;
    }

    @Override
    public String generateImportParcelKey(String preValue) {
        return this.getGeoServerStub().getStreetNetBi().generateImportParcelKey(null, null, preValue);
    }

    @Override
    public Collection<ParcelModel> fetchNotCheckedParcels() {
        Collection<ParcelDto> dtos = this.getGeoServerStub().getStreetNetBi().fetchNotCheckedParcels();
        HashSet<ParcelModel> models = new HashSet<ParcelModel>(dtos.size());
        for (ParcelDto dto : dtos) {
            ParcelModel parcel = (ParcelModel)super.convertDtoToModel(dto, new ValueChangeListener[0]);
            models.add(parcel);
        }
        return models;
    }

    @Override
    public ErrorMessages deleteParcels(Collection<ParcelModel> parcels, ErrorMessages errorMessages) {
        List<ParcelDto> dtoProxies = super.convertModelsToDtoProxies(parcels);
        return this.getGeoServerStub().getStreetNetBi().deleteParcels(dtoProxies, errorMessages);
    }

    @Override
    public Collection<SegmentModel> fetchSegmentsWithType(Coordinate topLeft, Coordinate bottomRight, SegmentType ... streetTypes) {
        Collection<SegmentDto> dtos = this.getGeoServerStub().getStreetNetBi().fetchSegmentsWithType(ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(topLeft)), ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(bottomRight)), streetTypes);
        ArrayList<SegmentModel> models = new ArrayList<SegmentModel>(dtos.size());
        for (SegmentDto dto : dtos) {
            models.add((SegmentModel)this.getModelCache().getModel(dto));
        }
        return models;
    }

    @Override
    public Collection<SegmentModel> fetchSegments(Coordinate topLeft, Coordinate bottomRight) {
        return this.fetchSegmentsWithType(topLeft, bottomRight, SegmentType.values());
    }

    @Override
    public Collection<PlaceModel> fetchPlaces(Coordinate topLeft, Coordinate bottomRight) {
        Collection<PlaceDto> dtos = this.getGeoServerStub().getStreetNetBi().fetchPlaces(ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(topLeft)), ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(bottomRight)));
        return super.convertDtosToModels(dtos, new ValueChangeListener[0]);
    }

    @Override
    public Collection<ParcelFilterModel> fetchAllParcelFilters() {
        return this.convertDtosToModels(this.getGeoServerStub().getStreetNetBi().fetchAllParcelFilters(), new ValueChangeListener[0]);
    }

    @Override
    public Collection<ParcelFilterPatternSetupModel> fetchAllParcelFilterPatternSetups() {
        return this.convertDtosToModels(this.getGeoServerStub().getStreetNetBi().fetchAllParcelFilterPatternSetups(), new ValueChangeListener[0]);
    }

    @Override
    public Collection<ParcelFilterPatternSetupModel> fetchAllParcelFilterPatternSetupsForAreaLayer(Collection<AreaLayerModel> layers) {
        List<AreaLayerDto> layerDtos = this.convertModelsToDtoProxies(layers);
        return this.convertDtosToModels(this.getGeoServerStub().getStreetNetBi().fetchAllParcelFilterPatternSetupsForAreaLayer(layerDtos), new ValueChangeListener[0]);
    }

    @Override
    public Collection<ParcelModel> fetchParcelsWithoutSegment(Coordinate topLeft, Coordinate bottomRight) {
        ImmutablePointDto topLeftDto = topLeft == null ? null : ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(topLeft));
        ImmutablePointDto bottomRightDto = bottomRight == null ? null : ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(bottomRight));
        return this.convertDtosToModels(this.getGeoServerStub().getStreetNetBi().fetchParcelsWithoutSegment(topLeftDto, bottomRightDto), new ValueChangeListener[0]);
    }

    @Override
    public Collection<ParcelModel> fetchParcelByStreet(StreetModel streetModel) {
        return this.convertDtosToModels(this.getGeoServerStub().getStreetNetBi().fetchParcelByStreet((StreetDto)this.convertModelToDtoProxy(streetModel)), new ValueChangeListener[0]);
    }

    @Override
    public ParcelModel fetchParcelByImportKey(String importKey) {
        return (ParcelModel)this.convertDtoToModel(this.getGeoServerStub().getStreetNetBi().fetchParcelByOriginAndKey(importKey), new ValueChangeListener[0]);
    }

    @Override
    public Collection<ParcelModel> fetchParcelsWithoutAreaObject() {
        Collection<ParcelDto> dtos = this.getGeoServerStub().getStreetNetBi().fetchParcelsWithoutAreaObject();
        return this.convertDtosToModels(dtos, new ValueChangeListener[0]);
    }

    @Override
    public ImmutablePolygonDto getSegmentMaxEnvelope() {
        return this.getGeoServerStub().getStreetNetBi().getSegmentMaxEnvelope();
    }

    @Override
    public Collection<Tupel<Long, Long>> getForgeinRelsForLayer(Collection<Tupel<Long, Long>> toCheckIds, AreaLayerModel layer) {
        return this.getGeoServerStub().getStreetNetBi().getForgeinRelsForLayer(toCheckIds, (AreaLayerDto)this.convertModelToDtoProxy(layer));
    }

    @Override
    public void updateParcelObjectsValueByDescriptor(ParcelAttributeValueDescriptorModel selectedValueDescriptorModel, String value, boolean isToOverwriteNullValues) {
        this.getGeoServerStub().getStreetNetBi().updateParcelObjectsValueByDescriptor((ParcelAttributeValueDescriptorDto)this.convertModelToDtoProxy(selectedValueDescriptorModel), value, isToOverwriteNullValues);
    }

    @Override
    public List<Tupel<ParcelModel, ParcelModel>> fetchDoubleAddressParcels() {
        List<Tupel<ParcelDto, ParcelDto>> quads = this.getGeoServerStub().getStreetNetBi().fetchDoubleAddressParcels();
        ArrayList<Tupel<ParcelModel, ParcelModel>> nQuads = new ArrayList<Tupel<ParcelModel, ParcelModel>>();
        for (Tupel<ParcelDto, ParcelDto> quad : quads) {
            nQuads.add(new Tupel<ParcelModel, ParcelModel>((ParcelModel)this.convertDtoToModel((Dto)quad.getElement1(), new ValueChangeListener[0]), (ParcelModel)this.convertDtoToModel((Dto)quad.getElement2(), new ValueChangeListener[0])));
        }
        return nQuads;
    }

    @Override
    public Collection<ParcelModel> fetchParcelsWithBadSegment() {
        Collection<ParcelDto> dtos = this.getGeoServerStub().getStreetNetBi().fetchParcelsWithBadSegment();
        HashSet<ParcelModel> models = new HashSet<ParcelModel>(dtos.size());
        for (ParcelDto dto : dtos) {
            ParcelModel parcel = (ParcelModel)super.convertDtoToModel(dto, new ValueChangeListener[0]);
            models.add(parcel);
        }
        return models;
    }

    @Override
    public Tupel<Collection<ParcelModel>, Integer> searchParcelByNumberPart(String parcelId, Integer maxCount) {
        Tupel<Collection<ParcelDto>, Integer> tupel = this.getGeoServerStub().getStreetNetBi().searchParcelByNumberPart(parcelId, maxCount);
        List models = this.convertDtosToModels(tupel.getElement1(), new ValueChangeListener[0]);
        return new Tupel<Collection<ParcelModel>, Integer>(models, tupel.getElement2());
    }

    @Override
    public Collection<ImportedLocationModel> findImportLocationsExact(Country country, String postcode, String city, String district, String street, Integer housenumber, String housenumberExtension, boolean ignoreNulls) {
        return this.convertDtosToModels(this.getGeoServerStub().getStreetNetBi().findImportLocationsExact(country, postcode, city, district, street, housenumber, housenumberExtension, ignoreNulls, false), new ValueChangeListener[0]);
    }

    @Override
    public DefaultExportDto deleteParcelSegmentRelations(double maxDistance, AreaObjectModel area, PostcodeModel postcode, boolean remove, boolean foot, boolean motor, boolean bike) throws ClientExportException {
        return this.getGeoServerStub().getStreetNetBi().deleteParcelSegmentRelations(maxDistance, (AreaObjectDto)this.convertModelToDtoProxy(area), (PostcodeDto)this.convertModelToDtoProxy(postcode), remove, foot, motor, bike);
    }

    @Override
    public Collection<ParcelModel> fetchParcelExact(Country country, String postcode, String city, String district, String street, String housenumber, String housenumberExtension) {
        return this.convertDtosToModels(this.getGeoServerStub().getStreetNetBi().fetchParcelsExact(country, postcode, city, district, street, housenumber, housenumberExtension), new ValueChangeListener[0]);
    }

    @Override
    public Collection<Collection<ParcelModel>> fetchMultipleAdressParcels() {
        Collection<Collection<ParcelDto>> multis = this.getGeoServerStub().getStreetNetBi().fetchMultipleAdressParcels();
        ArrayList<Collection<ParcelModel>> multiModels = new ArrayList<Collection<ParcelModel>>(multis.size());
        for (Collection<ParcelDto> col : multis) {
            ArrayList<ParcelModel> tupels = new ArrayList<ParcelModel>(col.size());
            for (ParcelDto tupel : col) {
                tupels.add((ParcelModel)this.convertDtoToModel(tupel, new ValueChangeListener[0]));
            }
            multiModels.add(tupels);
        }
        return multiModels;
    }

    @Override
    public List<Tupel<Country, Integer>> fetchPostcodesWithAtLeastOneParcel() {
        return this.getGeoServerStub().getStreetNetBi().fetchPostcodesWithAtLeastOneParcel();
    }

    @Override
    public List<ParcelModel> fetchParcelsByIds(List<Long> ids) {
        return this.convertDtosToModels(this.getGeoServerStub().getStreetNetBi().fetchParcelsByIds(ids), new ValueChangeListener[0]);
    }

    @Override
    public Collection<StreetModel> fetchStreetsWithAtLeastOneParcel(Collection<StreetModel> streets) {
        List<StreetDto> streetDtos = this.convertModelsToDtoProxies(streets);
        return this.convertDtosToModels(this.getGeoServerStub().getStreetNetBi().fetchStreetsWithAtLeastOneParcelFromStreets(streetDtos), new ValueChangeListener[0]);
    }
}

