/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.communication;

import de.datomino.peppergis.client.communication.AbstractCaller;
import de.datomino.peppergis.client.communication.GeoServerStub;
import de.datomino.peppergis.client.communication.OfferCaller;
import de.datomino.peppergis.client.model.ModelCache;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.offer.AgentModel;
import de.datomino.peppergis.client.model.offer.DeliveryType1Model;
import de.datomino.peppergis.client.model.offer.MediaModel;
import de.datomino.peppergis.client.model.offer.OfferAreaRelationModel;
import de.datomino.peppergis.client.model.offer.OfferDeliveryInformationModel;
import de.datomino.peppergis.client.model.offer.OfferExtension1Model;
import de.datomino.peppergis.client.model.offer.OfferModel;
import de.datomino.peppergis.client.model.offer.OfferWeightExtension1Model;
import de.datomino.peppergis.client.model.offer.PriceType1Model;
import de.datomino.peppergis.client.model.offer.SenderModel;
import de.datomino.peppergis.dto.area.AreaObjectDto;
import de.datomino.peppergis.dto.offer.DeliveryType1Dto;
import de.datomino.peppergis.dto.offer.OfferDto;
import de.datomino.peppergis.dto.offer.PriceType1Dto;
import java.util.Collection;
import java.util.List;
import org.ktde.model.ValueChangeListener;

public class OfferCallerImpl
extends AbstractCaller
implements OfferCaller {
    public OfferCallerImpl(GeoServerStub geoServerStub, ModelCache modelCache) {
        super(geoServerStub, modelCache);
    }

    @Override
    public List<AgentModel> getAllAgents() {
        return this.convertDtosToModels(this.getGeoServerStub().getOfferBi().getAllAgents(), new ValueChangeListener[0]);
    }

    @Override
    public List<SenderModel> getAllSenders() {
        return this.convertDtosToModels(this.getGeoServerStub().getOfferBi().getAllSenders(), new ValueChangeListener[0]);
    }

    @Override
    public Collection<MediaModel> getAllMedia() {
        return this.convertDtosToModels(this.getGeoServerStub().getOfferBi().getAllMedia(), new ValueChangeListener[0]);
    }

    @Override
    public Collection<OfferDeliveryInformationModel> getAllDeliveryInformations() {
        return this.convertDtosToModels(this.getGeoServerStub().getOfferBi().getAllDeliveryInformations(), new ValueChangeListener[0]);
    }

    @Override
    public List<OfferWeightExtension1Model> getEsslingerWeights() {
        return this.convertDtosToModels(this.getGeoServerStub().getOfferBi().getEsslingerWeights(), new ValueChangeListener[0]);
    }

    @Override
    public Collection<DeliveryType1Model> getAllEsslingerDeliveryTypes() {
        return this.convertDtosToModels(this.getGeoServerStub().getOfferBi().getAllEsslingerDeliveryTypes(), new ValueChangeListener[0]);
    }

    @Override
    public OfferWeightExtension1Model determineEsslingerWeight(DeliveryType1Model deliveryType, PriceType1Model priceType, Double weight) {
        return (OfferWeightExtension1Model)this.convertDtoToModel(this.getGeoServerStub().getOfferBi().determineEsslingerWeight((DeliveryType1Dto)this.convertModelToDtoProxy(deliveryType), (PriceType1Dto)this.convertModelToDtoProxy(priceType), weight), new ValueChangeListener[0]);
    }

    @Override
    public Collection<PriceType1Model> getAllPriceTypes() {
        return this.convertDtosToModels(this.getGeoServerStub().getOfferBi().getAllPriceTypes(), new ValueChangeListener[0]);
    }

    @Override
    public OfferModel getOfferByNumber(String offerNumber) {
        return (OfferModel)this.convertDtoToModel(this.getGeoServerStub().getOfferBi().getOfferByNumber(offerNumber), new ValueChangeListener[0]);
    }

    @Override
    public String getNextOfferNumber() {
        return this.getGeoServerStub().getOfferBi().getNextOfferNumber();
    }

    @Override
    public OfferExtension1Model getEsslingerExtensionForOffer(OfferModel offer) {
        return (OfferExtension1Model)this.convertDtoToModel(this.getGeoServerStub().getOfferBi().getEsslingerExtensionForOffer((OfferDto)this.convertModelToDtoProxy(offer)), new ValueChangeListener[0]);
    }

    @Override
    public Collection<OfferModel> getAllOffers() {
        return this.convertDtosToModels(this.getGeoServerStub().getOfferBi().getAllOffers(), new ValueChangeListener[0]);
    }

    @Override
    public Collection<OfferModel> searchOfferBy(String offerNumber, String companyName, String firstName, String lastName) {
        return this.convertDtosToModels(this.getGeoServerStub().getOfferBi().searchOfferBy(offerNumber, companyName, firstName, lastName), new ValueChangeListener[0]);
    }

    @Override
    public Collection<OfferAreaRelationModel> getOfferAreaRelationsForAreaObject(AreaObjectModel areaObject) {
        AreaObjectDto areaDto = (AreaObjectDto)this.convertModelToDtoProxy(areaObject);
        return this.convertDtosToModels(this.getGeoServerStub().getOfferBi().getOfferAreaRelationsForAreaObject(areaDto), new ValueChangeListener[0]);
    }
}

