/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.communication;

import de.datomino.peppergis.client.communication.AbstractCaller;
import de.datomino.peppergis.client.communication.ExportCaller;
import de.datomino.peppergis.client.communication.GeoServerStub;
import de.datomino.peppergis.client.model.ModelCache;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.tour.AreaTourModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.dto.area.AreaLayerDto;
import de.datomino.peppergis.dto.area.AreaObjectDto;
import de.datomino.peppergis.dto.exporter.AreaExportDto;
import de.datomino.peppergis.dto.exporter.AreaExportType;
import de.datomino.peppergis.dto.exporter.DefaultExportDto;
import de.datomino.peppergis.dto.exporter.TourExportDto;
import de.datomino.peppergis.dto.exporter.TourExportFormat;
import de.datomino.peppergis.dto.exporter.TourExportReportDto;
import de.datomino.peppergis.dto.exporter.TourExportType;
import de.datomino.peppergis.dto.pmd.UploadPmdReportDto;
import de.datomino.peppergis.dto.tour.AreaTourDto;
import de.datomino.peppergis.dto.tour.TourDto;
import de.datomino.peppergis.exception.ClientExportException;
import de.datomino.peppergis.type.export.ExportParcelType;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.model.ValueChangeListener;
import org.ktde.util.datatypes.Tupel;

public class ExportCallerImpl
extends AbstractCaller
implements ExportCaller {
    public ExportCallerImpl(GeoServerStub geoServerStub, ModelCache modelCache) {
        super(geoServerStub, modelCache);
    }

    @Override
    public TourExportDto exportTours(Collection<TourModel> tourModels, TourExportType tourExportType) throws ClientExportException {
        List<TourDto> dtos = this.convertModelsToDtoProxies(tourModels);
        return this.getGeoServerStub().getExportBi().exportTours(dtos, tourExportType);
    }

    @Override
    public TourExportReportDto exportToursToServer(Collection<TourModel> tourModels) throws ClientExportException {
        List<TourDto> dtos = this.convertModelsToDtoProxies(tourModels);
        return this.getGeoServerStub().getExportBi().exportToursToServer(dtos);
    }

    @Override
    public UploadPmdReportDto uploadForPmd(Set<AreaObjectModel> selectedObjects, AreaLayerModel targetLayer) throws ClientExportException {
        List<AreaObjectDto> areaObjectDtos = this.convertModelsToDtoProxies(selectedObjects);
        AreaLayerDto areaLayerDto = (AreaLayerDto)this.convertModelToDtoProxy(targetLayer);
        return this.getGeoServerStub().getExportBi().uploadForPmd(areaObjectDtos, areaLayerDto);
    }

    @Override
    public Collection<AreaLayerModel> getPmdUploadableAreaLayers() {
        return this.convertDtosToModels(this.getGeoServerStub().getExportBi().getPmdUploadableAreaLayers(), new ValueChangeListener[0]);
    }

    @Override
    public AreaExportDto exportAreasByObjects(Collection<AreaObjectModel> selectedAreas, AreaExportType areaExportType, CoordinateFactory.Projections coordinateFactory, boolean houseNumbersExtendToFullRange) throws ClientExportException {
        List<AreaObjectDto> dtos = this.convertModelsToFullDtos(selectedAreas);
        return this.getGeoServerStub().getExportBi().exportAreasByObjects(dtos, areaExportType, coordinateFactory, houseNumbersExtendToFullRange);
    }

    @Override
    public TourExportDto exportAreaTours(Collection<AreaTourModel> areaTours, TourExportFormat tourExportType) throws ClientExportException {
        List<AreaTourDto> dtos = this.convertModelsToDtoProxies(areaTours);
        return this.getGeoServerStub().getExportBi().exportAreaTours(dtos, tourExportType);
    }

    @Override
    public DefaultExportDto exportStreetAlias() throws ClientExportException {
        return this.getGeoServerStub().getExportBi().exportStreetAlias();
    }

    @Override
    public DefaultExportDto exportDistrictAlias() throws ClientExportException {
        return this.getGeoServerStub().getExportBi().exportDistrictAlias();
    }

    @Override
    public DefaultExportDto exportCityAlias() throws ClientExportException {
        return this.getGeoServerStub().getExportBi().exportCityAlias();
    }

    @Override
    public DefaultExportDto exportParcels(ExportParcelType exportParcelType, AreaLayerDto areaLayer) throws ClientExportException {
        return this.getGeoServerStub().getExportBi().exportParcels(exportParcelType, areaLayer);
    }

    @Override
    public DefaultExportDto exportParcelsByIds(Collection<Tupel<Long, String[]>> filtered, String[] header, ExportParcelType exportParcelType) throws ClientExportException {
        return this.getGeoServerStub().getExportBi().exportParcelsByIds(filtered, header, exportParcelType);
    }

    @Override
    public DefaultExportDto exportSubscriptionsByIds(List<Long> ids) throws ClientExportException {
        return this.getGeoServerStub().getExportBi().exportSubscriptionsByIds(ids);
    }

    @Override
    public DefaultExportDto exportLettersByIds(List<Long> ids) throws ClientExportException {
        return this.getGeoServerStub().getExportBi().exportLettersByIds(ids);
    }

    @Override
    public DefaultExportDto exportPoisByIds(List<Long> ids) throws ClientExportException {
        return this.getGeoServerStub().getExportBi().exportPoisByIds(ids);
    }

    @Override
    public DefaultExportDto exportStopsByIds(List<Long> ids) throws ClientExportException {
        return this.getGeoServerStub().getExportBi().exportStopsByIds(ids);
    }

    @Override
    public AreaExportDto exportAreasBasedOnTimeFunction(AreaLayerModel layer, Date inputLastModifiedDate) throws ClientExportException {
        AreaLayerDto areaLayerDto = (AreaLayerDto)this.convertModelToDtoProxy(layer);
        return this.getGeoServerStub().getExportBi().exportAreasBasedOnTimeFunction(areaLayerDto, inputLastModifiedDate);
    }

    @Override
    public boolean isServerTourExportEnabled() {
        return this.getGeoServerStub().getExportBi().isServerTourExportEnabled();
    }
}

