/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.communication;

import de.datomino.peppergis.client.communication.AbstractCaller;
import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.communication.GeoServerStub;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.ModelCache;
import de.datomino.peppergis.dto.AbstractDto;
import de.datomino.peppergis.dto.AbstractProxyDto;
import de.datomino.peppergis.dto.AbstractSpecificDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.exception.ValidateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ktde.math.projection.CoordinateFactory;

public class CommonCallerImpl
extends AbstractCaller
implements CommonCaller {
    public CommonCallerImpl(GeoServerStub geoServerStub, ModelCache modelCache) {
        super(geoServerStub, modelCache);
    }

    @Override
    public void saveEventChain(Collection<AbstractModel<?, ?>> todoUpdate, Collection<AbstractModel<?, ?>> todoDelete) throws ValidateException {
        Collection<AbstractSpecificDto> todoUpdateDtos = this.createDtoUpdates(todoUpdate);
        Collection<AbstractProxyDto> todoDeleteDtos = this.createDtoDeletes(todoDelete);
        Collection<AbstractProxyDto> proxyDtos = this.getGeoServerStub().getCommonBi().saveEventChain(todoUpdateDtos, todoDeleteDtos);
        this.getModelCache().refreshAfterUpdate(proxyDtos, todoDelete);
    }

    private Collection<AbstractSpecificDto> createDtoUpdates(Collection<AbstractModel<?, ?>> models) {
        ArrayList<AbstractSpecificDto> dtoList = new ArrayList<AbstractSpecificDto>(models.size());
        for (AbstractModel<?, ?> model : models) {
            if (model == null) continue;
            dtoList.add((AbstractSpecificDto)model.createDto());
        }
        return dtoList;
    }

    private Collection<AbstractProxyDto> createDtoDeletes(Collection<AbstractModel<?, ?>> models) {
        ArrayList<AbstractProxyDto> dtoList = new ArrayList<AbstractProxyDto>(models.size());
        for (AbstractModel<?, ?> model : models) {
            dtoList.add((AbstractProxyDto)model.createProxy());
        }
        return dtoList;
    }

    @Override
    public synchronized void fetchModel(AbstractModel<?, ?> model) {
        System.out.println(model.getClass());
        Object dtoBefore = model.createProxy();
        AbstractSpecificDto dtoAfter = this.getGeoServerStub().getCommonBi().fetchModel((AbstractProxyDto)dtoBefore);
        try {
            this.getModelCache().getModel(dtoAfter);
        }
        catch (StaleStateException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void fetchModels(Collection<? extends Model> models, boolean onlyChangedVersions) {
        if (!models.isEmpty()) {
            ArrayList<AbstractProxyDto> befores = new ArrayList<AbstractProxyDto>(models.size());
            for (Model model : models) {
                befores.add(model.createProxy());
            }
            Collection<AbstractSpecificDto> afters = this.getGeoServerStub().getCommonBi().fetchModels(befores, onlyChangedVersions);
            for (AbstractSpecificDto specificDto : afters) {
                try {
                    this.getModelCache().getModel(specificDto);
                }
                catch (StaleStateException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public ModelCache getModelCache() {
        return super.getModelCache();
    }

    @Override
    public <T extends AbstractModel<?, ?>> Collection<T> fetchChildren(AbstractModel<?, ?> parent, String propertyName) {
        ArrayList<AbstractModel> modelList;
        List<AbstractSpecificDto> children = this.getGeoServerStub().getCommonBi().fetchChildren((AbstractDto)parent.createProxy(), propertyName);
        if (children == null) {
            modelList = new ArrayList<AbstractModel>();
        } else {
            modelList = new ArrayList(children.size());
            for (AbstractSpecificDto dto : children) {
                AbstractModel model;
                AbstractModel t = model = (AbstractModel)this.getModelCache().getModel(dto);
                modelList.add(t);
            }
        }
        return modelList;
    }

    @Override
    public <T extends AbstractModel<?, ?>> T fetchChild(AbstractModel<?, ?> parent, String propertyName) {
        AbstractModel model;
        AbstractSpecificDto child = this.getGeoServerStub().getCommonBi().fetchChild((AbstractDto)parent.createProxy(), propertyName);
        AbstractModel t = model = (AbstractModel)this.getModelCache().getModel(child);
        return (T)t;
    }

    @Override
    public CoordinateFactory getCoordinateFactory() {
        String coordinateFactoryName = this.getGeoServerStub().getCommonBi().getCoordinateFactory();
        return CoordinateFactory.getInstance(coordinateFactoryName);
    }

    @Override
    public Map<String, Object> fetchSharedValues() {
        return this.getGeoServerStub().getCommonBi().fetchSharedValues();
    }
}

