/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.communication;

import de.datomino.logistic.LogisticException;
import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.area.MakroParameter;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.area.AreaAttributeValueModel;
import de.datomino.peppergis.client.model.area.AreaFilterPatternSetupModel;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.DeliveryRoundRelationModel;
import de.datomino.peppergis.client.model.area.DetaillessAreaObjectGeometryModel;
import de.datomino.peppergis.client.model.base.SubscriptionAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.filter.AreaFilterModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModel;
import de.datomino.peppergis.client.model.wage.WageParameterModel;
import de.datomino.peppergis.type.AggregateType;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.MicrocellDescriptorType;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.message.error.ErrorMessages;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ktde.math.projection.Coordinate;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public interface AreaCaller {
    public Collection<AreaLayerModel> getAreaLayer(String var1);

    public Collection<AreaLayerModel> getAreaLayerForIds(Collection<Long> var1);

    public AreaLayerModel getAreaLayer(Long var1);

    public Collection<AreaObjectModel> fetchAreaObjects(AreaLayerModel var1, Coordinate var2, Coordinate var3);

    public Collection<AreaObjectModel> fetchAreaObjectsWithoutIds(AreaLayerModel var1, Coordinate var2, Coordinate var3, Collection<Long> var4);

    public List<AreaObjectModel> fetchAreaObjectsByAreaLayer(AreaLayerModel var1, boolean var2);

    public Collection<Tupel<Long, String>> fetchAreaIdNameTupelsByAreaLayer(AreaLayerModel var1);

    public Collection<AreaObjectModel> fetchAreaObjectsById(Collection<Long> var1);

    public AreaObjectModel fetchAreaObject(AreaLayerModel var1, String var2);

    public Collection<AreaObjectModel> fetchAreaObjects(AreaLayerModel var1, Collection<String> var2);

    public void createAreaGeometryReplace(AreaObjectModel var1, Collection<AreaObjectModel> var2, Collection<ImmutablePolygonKind> var3, ModelEnviroment var4);

    public void createAreaGeometryReplace(AreaObjectModel var1, Collection<AreaObjectModel> var2, Collection<ImmutablePolygonKind> var3, Integer var4, ModelEnviroment var5);

    public void createAreaGeometryRemove(AreaObjectModel var1, Collection<AreaObjectModel> var2, Collection<ImmutablePolygonKind> var3, ModelEnviroment var4);

    public void createAreaGeometryAdd(AreaObjectModel var1, Collection<AreaObjectModel> var2, Collection<ImmutablePolygonKind> var3, ModelEnviroment var4);

    public Collection<AreaObjectModel> getAreaObjectByKey(Collection<String> var1);

    public Collection<AreaObjectModel> getAreaObjectByKeysAndLayerIds(Collection<String> var1, Collection<Long> var2);

    public Collection<AreaAttributeValueDescriptorModel> fetchAllAreaAttributeValueDescriptors();

    public Collection<AreaFilterModel> fetchAllAreaFilters();

    public Collection<AreaFilterPatternSetupModel> fetchAllAreaFilterPatternSetupModels();

    public Collection<AreaFilterPatternSetupModel> fetchAllAreaFilterPatternSetupModelsForAreaLayer(Collection<AreaLayerModel> var1);

    public Collection<AreaLayerModel> getAreaLayersForType(AreaObjectGenInfoDiscriminator[] var1);

    public Collection<AreaObjectModel> findAreasWithCoordWithin(Coordinate var1, long ... var2);

    public Collection<AreaObjectModel> findAreasByEuclideanCircleSearch(Coordinate var1, int var2, AreaLayerModel var3, boolean var4, Collection<AreaFilterModel> var5, Collection<AreaFilterModel> var6, Boolean var7);

    public Collection<AreaObjectModel> findAreasWithCoordInRange(Coordinate var1, int var2, long ... var3);

    public Collection<AreaObjectModel> findAreasByAttributeAggregation(Coordinate var1, AreaAttributeValueDescriptorModel var2, double var3, AreaLayerModel var5, Collection<Long> var6, Collection<AreaFilterModel> var7, Collection<AreaFilterModel> var8, Boolean var9);

    public Collection<AreaObjectModel> findAreasWithFootOrCarDistance(AreaLayerModel var1, Coordinate var2, RouteVehicleType var3, RouteType var4, int var5, Collection<AreaFilterModel> var6, Collection<AreaFilterModel> var7, Boolean var8) throws LogisticException;

    public List<AreaObjectModel> fetchAreaObjectsByLayerAndPrefixes(AreaLayerModel var1, String var2, String var3, Integer var4);

    public void copyAndReduceLayer(AreaLayerModel var1, String var2, double var3);

    public void calcAreasFromParcels(AreaLayerModel var1, boolean var2, boolean var3);

    public List<Tripel<Long, String, String>> getAreaObjectsIdAndCaptionsForLayer(AreaLayerModel var1);

    public Tupel<ImmutablePoint, ImmutablePoint> getTopLeftAndBottomRightForLayer(AreaLayerModel var1, Set<Long> var2);

    public Collection<AreaObjectModel> calculateCover(Collection<AreaObjectModel> var1, Collection<ImmutablePolygonKind> var2, AreaLayerModel var3, Double var4);

    public Collection<AreaAttributeValueModel> getAreaAttributeValuesByAreaObject(AreaObjectModel var1);

    public void aggregateSubAreaAttributeValues(AreaLayerModel var1, AreaAttributeValueDescriptorModel var2, AreaAttributeValueDescriptorModel var3, AggregateType var4);

    public void aggregateParcelAttributeValues(AreaLayerModel var1, AreaAttributeValueDescriptorModel var2, ParcelAttributeValueDescriptorModel var3, AggregateType var4);

    public void aggregateSubscriptionAttributeValues(AreaLayerModel var1, AreaAttributeValueDescriptorModel var2, SubscriptionAttributeValueDescriptorModel var3, AggregateType var4);

    public void createParcelAreaRelationsForLayerByGeometry(AreaLayerModel var1, boolean var2);

    public void cutAreaLayerInMicrocell(AreaLayerModel var1, RouteVehicleType var2, Collection<ParcelModel> var3, Map<MicrocellDescriptorType, Model> var4, boolean var5, ErrorMessages var6);

    public Collection<Tupel<AreaObjectModel, List<Double>>> getDetaillessSteps(Collection<AreaObjectModel> var1);

    public Collection<Tupel<AreaObjectModel, DetaillessAreaObjectGeometryModel>> getDetaillessAreaGeometryForUpp(Collection<AreaObjectModel> var1, Double var2);

    public void createReducedAreasForLayer(AreaLayerModel var1, Double var2, Double var3);

    public void createReducedAreasForLayerByConfig(AreaLayerModel var1, Collection<Tupel<Double, Double>> var2);

    public ImmutablePolygonKind createReducedGeom(ImmutablePolygonKind var1, Double var2);

    public void deleteAreaLayer(AreaLayerModel var1);

    public void createMakrocellLayer(String var1, Long var2, MakroParameter var3, ErrorMessages var4);

    public void updateAreaObjectsValueByDescriptor(AreaAttributeValueDescriptorModel var1, String var2, boolean var3);

    public boolean isMicroCellAllowed();

    public boolean isMacroCellAllowed();

    public Collection<AreaAttributeValueModel> getAreaAttributeValuesByAreaLayerAndDescriptor(AreaLayerModel var1, AreaAttributeValueDescriptorModel var2);

    public Collection<AreaLayerModel> getAreaLayerForWage(AreaObjectGenInfoDiscriminator[] var1);

    public Collection<AreaObjectModel> fetchAllAreasWithoutParcelsAndSubscriptions(Collection<AreaLayerModel> var1);

    public void deleteAreaObjects(Collection<AreaObjectModel> var1);

    public Collection<AreaObjectModel> checkForBrokenOrders(Collection<Long> var1, Date var2, boolean var3);

    public DeliveryRoundRelationModel fetchRoundRelation(DeliveryRoundModel var1, WageParameterModel var2);

    public Collection<Tupel<Long, Long>> fetchLayerIdsForAreaObjectIds(Collection<Long> var1);
}

