/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.autoupdate;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.util.communication.HttpUtil;
import de.datomino.util.communication.StreamHttpResponse;
import de.datomino.util.swing.ExceptionMessageDialog;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.http.HttpException;
import org.ktde.util.StringUtil;

public class AutoUpdater {
    private static final String UPDATER_LOCATION = "https://www.datomino.de/download/clientUpdater.jar";
    private static final String OS_WINDOWS = "windows";

    public static void checkVersionAndAskForUpdate(ModelEnviroment modelEnviroment) {
        try {
            String serverVersion = modelEnviroment.getAllCaller().getClientManagementCaller().getServerVersion();
            String clientVersion = ModelEnviroment.getProperties().getProperty("peppergis.client.version");
            if (!new EqualsBuilder().append(serverVersion, clientVersion).isEquals()) {
                int d = JOptionPane.showConfirmDialog(null, ModelEnviroment.getMessageResolver().resolveMessage("messages.versionConflict", new Serializable[]{serverVersion, clientVersion}), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.warning", new Serializable[0]), 0, 2);
                if (d == 0) {
                    AutoUpdater.doUpdate(serverVersion);
                } else {
                    System.exit(0);
                }
            }
        }
        catch (Exception ex) {
            BufferedImage image;
            try {
                image = ImageIO.read(AutoUpdater.class.getResourceAsStream("/images/pepper.png"));
            }
            catch (IOException ioEx) {
                throw new RuntimeException(ioEx);
            }
            ExceptionMessageDialog errorMessageDialog = new ExceptionMessageDialog(null, ex, image){
                private static final long serialVersionUID = -2279928646747657106L;

                @Override
                protected void processWindowEvent(WindowEvent e) {
                    if (e.getID() == 201) {
                        System.exit(0);
                    }
                    super.processWindowEvent(e);
                }

                @Override
                protected void doOk() {
                    super.doOk();
                    System.exit(0);
                }
            };
            errorMessageDialog.setVisible(true);
        }
    }

    private static void doUpdate(String serverVersion) throws IOException, HttpException, InterruptedException {
        String jarFile = AutoUpdater.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        File file = new File(jarFile);
        if (!file.exists()) {
            JOptionPane.showMessageDialog(null, ModelEnviroment.getMessageResolver().resolveMessage("messages.autoupdate.fileNotExists", new Serializable[]{jarFile}), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.warning", new Serializable[0]), 2);
            System.exit(0);
        } else if (!file.canWrite()) {
            JOptionPane.showMessageDialog(null, ModelEnviroment.getMessageResolver().resolveMessage("messages.autoupdate.canNotWrite", new Serializable[]{jarFile}), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.warning", new Serializable[0]), 2);
            System.exit(0);
        }
        AutoUpdater.downloadAndExecuteUpdate(file.getAbsolutePath(), serverVersion);
    }

    private static void downloadAndExecuteUpdate(String jarFile, String serverVersion) throws IOException, HttpException, InterruptedException {
        File downloadJar = AutoUpdater.download();
        AutoUpdater.execute(downloadJar, jarFile, serverVersion);
    }

    private static void execute(File downloadJar, String jarFile, String serverVersion) throws IOException, InterruptedException {
        boolean win = AutoUpdater.isWin();
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = runtimeMxBean.getInputArguments();
        String proxyHost = System.getProperty("proxyHost");
        String proxyPort = System.getProperty("proxyPort");
        String proxyUser = System.getProperty("proxyUser");
        String proxyPassword = StringUtil.nullToEmpty(System.getProperty("proxyPassword"));
        String javaCommand = AutoUpdater.getJavaCommand(win);
        String[] commandArray = new String[3];
        if (win) {
            commandArray[0] = "cmd";
            commandArray[1] = "/c";
        } else {
            commandArray[0] = "/bin/sh";
            commandArray[1] = "-c";
        }
        LinkedList<String> commandChain = new LinkedList<String>();
        commandChain.add(javaCommand);
        commandChain.add("-jar");
        commandChain.add(downloadJar.getAbsolutePath());
        commandChain.add(jarFile);
        commandChain.add(serverVersion);
        commandChain.add(AutoUpdater.emptyToQ(proxyHost));
        commandChain.add(AutoUpdater.emptyToQ(proxyPort));
        commandChain.add(AutoUpdater.emptyToQ(proxyUser));
        commandChain.add(AutoUpdater.emptyToQ(proxyPassword));
        commandChain.addAll(arguments);
        StringBuilder sb = new StringBuilder("\"");
        boolean first = true;
        for (String c : commandChain) {
            if (!first) {
                sb.append(" ");
            }
            sb.append("\"").append(c).append("\"");
            first = false;
        }
        sb.append("\"");
        commandArray[2] = sb.toString();
        System.out.println("Executing " + commandArray[2]);
        Process p = Runtime.getRuntime().exec(commandArray);
        IOUtils.copy(p.getErrorStream(), (OutputStream)System.err);
        IOUtils.copy(p.getInputStream(), (OutputStream)System.out);
        p.waitFor();
        System.exit(0);
    }

    private static boolean isWin() {
        String arch = StringUtil.nullToEmpty(System.getProperty("os.name")).trim().toLowerCase();
        boolean win = arch.startsWith(OS_WINDOWS);
        return win;
    }

    private static String emptyToQ(String s) {
        if (StringUtil.isBlank(s)) {
            return "?";
        }
        return s;
    }

    private static String getJavaCommand(boolean win) throws IOException {
        String javaHome = System.getProperty("java.home");
        String javaCommand = javaHome + "/bin/java" + (win ? ".exe" : "");
        File javaCommandFile = new File(javaCommand);
        if (!(javaCommandFile.exists() || (javaCommandFile = new File(javaCommand = javaHome + "/java" + (win ? ".exe" : ""))).exists() || (javaCommandFile = new File(javaCommand = javaCommandFile.getParentFile().getParent() + "/bin/java" + (win ? ".exe" : ""))).exists())) {
            throw new IOException("Could not find java command");
        }
        return javaCommand;
    }

    private static File download() throws UnsupportedEncodingException, IOException, FileNotFoundException, HttpException {
        byte[] encodeBase64 = Base64.encodeBase64("client:trlqm3io".getBytes());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Authorization", "Basic " + new String(encodeBase64, "UTF-8"));
        File file = File.createTempFile("updater", ".jar");
        FileOutputStream fos = new FileOutputStream(file);
        StreamHttpResponse streamHttpResponse = HttpUtil.get(UPDATER_LOCATION, map, fos);
        fos.flush();
        fos.close();
        int statusCode = streamHttpResponse.getStatusCode();
        if (statusCode != 200) {
            throw new HttpException("Http return code " + statusCode);
        }
        return file;
    }
}

