/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.auth;

import de.datomino.peppergis.client.auth.UserInformation;
import de.datomino.peppergis.client.model.admin.UserModel;
import de.datomino.peppergis.client.model.admin.UserRoleObjectModel;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.model.tour.AreaTourScheduleModel;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.type.UserRole;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DefaultUserInformation
implements UserInformation {
    private UserModel userModel;
    private String login;
    private Map<UserRole, Set<Long>> rightInformation;

    public DefaultUserInformation(UserModel userModel) {
        this.userModel = userModel;
        this.login = userModel.getLogin();
        this.rightInformation = new HashMap<UserRole, Set<Long>>();
        for (UserRoleObjectModel userRoleObjectModel : userModel.iterableUserRoleObjects()) {
            Long attachedId;
            UserRole userRole = userRoleObjectModel.getUserRole();
            Set<Long> attachedIds = this.rightInformation.get((Object)userRole);
            if (attachedIds == null) {
                attachedIds = new LinkedHashSet<Long>();
                this.rightInformation.put(userRole, attachedIds);
            }
            if ((attachedId = userRoleObjectModel.getAttachedId()) == null) continue;
            attachedIds.add(attachedId);
        }
        System.out.println();
    }

    protected DefaultUserInformation() {
        this.rightInformation = Collections.emptyMap();
    }

    @Override
    public Map<UserRole, Set<Long>> getRightInformation() {
        if (this.rightInformation == null) {
            return new HashMap<UserRole, Set<Long>>();
        }
        return this.rightInformation;
    }

    @Override
    public boolean hasUserRole(UserRole userRole) {
        return this.rightInformation.containsKey((Object)userRole);
    }

    @Override
    public boolean hasAtLeastOneRole(UserRole ... userRoles) {
        for (UserRole userRole : userRoles) {
            if (!this.hasUserRole(userRole)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasOtherRolesThan(UserRole ... userRoles) {
        HashSet<UserRole> set = new HashSet<UserRole>(this.rightInformation.keySet());
        set.removeAll(Arrays.asList(userRoles));
        return !set.isEmpty();
    }

    @Override
    public Set<Long> getAttachedIdsForUserRole(UserRole userRole) {
        Set<Long> attachedIds = this.rightInformation.get((Object)userRole);
        if (attachedIds == null) {
            attachedIds = Collections.emptySet();
        }
        return attachedIds;
    }

    @Override
    public UserModel getUserModel() {
        return this.userModel;
    }

    @Override
    public String getLogin() {
        return this.login;
    }

    public static DefaultUserInformation getDummyUserInformation() {
        return new DefaultUserInformation();
    }

    @Override
    public boolean isAdmin() {
        return this.rightInformation.containsKey((Object)UserRole.ADMIN);
    }

    @Override
    public boolean hasUserRoleForTour(TourModel tour, UserRole ... userRoles) {
        BranchModel branch = tour.getBranch();
        Long branchId = branch == null ? null : branch.getId();
        DelivererModel deliverer = tour.getDeliverer();
        Long delivererId = deliverer == null ? null : deliverer.getId();
        for (UserRole userRole : userRoles) {
            if ((userRole == UserRole.ADMIN || userRole == UserRole.DISPONENT_SUPER) && this.rightInformation.containsKey((Object)userRole)) {
                return true;
            }
            Set<Long> ids = this.rightInformation.get((Object)userRole);
            if (ids == null) continue;
            if ((userRole == UserRole.DISPONENT_LOCAL_ACTIVE || userRole == UserRole.DISPONENT_LOCAL_PASSIVE) && branchId != null && ids.contains(branchId)) {
                return true;
            }
            if (userRole != UserRole.DELIVERER_ACTIVE && userRole != UserRole.DELIVERER_PASSIVE || delivererId == null || !ids.contains(delivererId)) continue;
            return true;
        }
        return false;
    }

    public boolean hasUserRoleForSchedule(AreaTourScheduleModel schedule, UserRole ... userRoles) {
        AreaDelivererModel deliverer = schedule.getDeliverer();
        Long delivererId = deliverer == null ? null : deliverer.getId();
        for (UserRole userRole : userRoles) {
            if (userRole == UserRole.ADMIN || userRole == UserRole.AREA_ADMIN || userRole == UserRole.DISPONENT_SUPER) {
                return true;
            }
            Set<Long> ids = this.rightInformation.get((Object)userRole);
            if (ids == null || userRole != UserRole.DELIVERER_ACTIVE && userRole != UserRole.DELIVERER_PASSIVE || delivererId == null || !ids.contains(delivererId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSuperUser() {
        return false;
    }
}

