/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.areagenerator;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaObjectGenInfoModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenInfoModelImpl;
import de.datomino.peppergis.client.model.area.AreaObjectGenSegmentModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenSegmentModelImpl;
import de.datomino.peppergis.client.model.area.AreaObjectGenSegmentRelModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenSegmentRelModelImpl;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.peppergis.helper.StreetsegmentHelper;
import de.datomino.util.algorithm.selfintersection.PolygonSelfIntersectionKiller;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.util.GeoUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.datatypes.ArrayHelper;

public class StreetsegmentAreaGenerator {
    private ModelEnviroment modelEnviroment;

    public void setModelEnviroment(ModelEnviroment modelEnviroment) {
        this.modelEnviroment = modelEnviroment;
    }

    public void createAreaGeometryAddSegments(AreaObjectModel currentAreaObject, Set<AreaObjectModel> changedAreaObjects, Collection<SegmentModel> segments, Integer maxSegmentCount) {
        AreaObjectGenSegmentModel data = this.getGeninfo(currentAreaObject);
        HashSet<SegmentModel> toaddSegments = new HashSet<SegmentModel>();
        Set<SegmentModel> known = AreaObjectModelUtil.getKnownSegments(data);
        for (SegmentModel side : segments) {
            if (known.contains(side)) continue;
            toaddSegments.add(side);
        }
        this.generateArea(currentAreaObject, changedAreaObjects, toaddSegments, null, maxSegmentCount);
    }

    public void createAreaGeometryRemoveSegments(AreaObjectModel currentAreaObject, Set<AreaObjectModel> changedAreaObjects, Collection<SegmentModel> segments, Integer maxSegmentCount) {
        AreaObjectGenSegmentModel data = this.getGeninfo(currentAreaObject);
        HashSet<SegmentModel> todelSegments = new HashSet<SegmentModel>();
        Set<SegmentModel> known = AreaObjectModelUtil.getKnownSegments(data);
        for (SegmentModel side : segments) {
            if (!known.contains(side)) continue;
            todelSegments.add(side);
        }
        this.generateArea(currentAreaObject, changedAreaObjects, null, todelSegments, maxSegmentCount);
    }

    public void createAreaGeometryReplaceSegments(AreaObjectModel currentAreaObject, Set<AreaObjectModel> changedAreaObjects, Collection<SegmentModel> segments, Integer maxSegmentCount) {
        AreaObjectGenSegmentModel data = this.getGeninfo(currentAreaObject);
        HashSet<SegmentModel> todelSegments = new HashSet<SegmentModel>();
        HashSet<SegmentModel> toaddSegments = new HashSet<SegmentModel>();
        Set<SegmentModel> known = AreaObjectModelUtil.getKnownSegments(data);
        for (SegmentModel side : segments) {
            if (known.contains(side)) continue;
            toaddSegments.add(side);
        }
        for (SegmentModel side : known) {
            if (segments.contains(side)) continue;
            todelSegments.add(side);
        }
        this.generateArea(currentAreaObject, changedAreaObjects, toaddSegments, todelSegments, maxSegmentCount);
    }

    private AreaObjectGenSegmentModel getGeninfo(AreaObjectModel currentAreaObject) {
        AreaObjectGenInfoModel geninfo = currentAreaObject.getGenInfo();
        if (geninfo == null) {
            geninfo = new AreaObjectGenInfoModelImpl();
            geninfo.setAreaObject(currentAreaObject);
            AreaObjectGenSegmentModelImpl gensegment = new AreaObjectGenSegmentModelImpl();
            geninfo.setAreaObjectGenSegment(gensegment);
        }
        AreaObjectGenSegmentModel data = currentAreaObject.getGenInfo().getAreaObjectGenSegment();
        return data;
    }

    private void generateArea(AreaObjectModel currentAreaObject, Set<AreaObjectModel> changedAreaObjects, Set<SegmentModel> toaddSegments, Set<SegmentModel> todelSegments, Integer maxSegmentCount) {
        if (ArrayHelper.isEmpty(toaddSegments) && ArrayHelper.isEmpty(todelSegments)) {
            return;
        }
        AreaObjectGenSegmentModel segmentInfo = currentAreaObject.getGenInfo().getAreaObjectGenSegment();
        Set<SegmentModel> knownSegments = AreaObjectModelUtil.getKnownSegments(segmentInfo);
        HashSet<AreaObjectGenSegmentRelModel> existingsegments = new HashSet<AreaObjectGenSegmentRelModel>();
        for (AreaObjectGenSegmentRelModel rel : segmentInfo.iterableSegments()) {
            existingsegments.add(rel);
        }
        for (AreaObjectGenSegmentRelModel existing : existingsegments) {
            SegmentModel segment = existing.getSegment();
            if (todelSegments == null || !todelSegments.contains(segment)) continue;
            existing.setGenInfoSegment(null);
            existing.setSegment(null);
            ChangeSet.delete(existing);
            knownSegments.remove(segment);
        }
        if (toaddSegments != null) {
            for (SegmentModel segment : toaddSegments) {
                AreaObjectGenSegmentRelModelImpl rel = new AreaObjectGenSegmentRelModelImpl();
                rel.setSegment(segment);
                rel.setGenInfoSegment(segmentInfo);
            }
        }
        ImmutablePolygonKind polygon = StreetsegmentAreaGenerator.createPolygon(segmentInfo, this.modelEnviroment, maxSegmentCount);
        PolygonSelfIntersectionKiller polygonSelfIntersectionKiller = new PolygonSelfIntersectionKiller(polygon);
        polygonSelfIntersectionKiller.start(false);
        polygon = polygonSelfIntersectionKiller.getResult();
        currentAreaObject.setGeom(polygon);
    }

    private static ImmutablePolygonKind createPolygon(AreaObjectGenSegmentModel segmentInfo, ModelEnviroment modelEnviroment, Integer maxSegmentCount) {
        if (segmentInfo == null) {
            return null;
        }
        CoordinateFactory coordinateFactory = null;
        HashSet<ImmutableLineString> lineStrings = new HashSet<ImmutableLineString>(segmentInfo.countSegments());
        for (AreaObjectGenSegmentRelModel rel : segmentInfo.iterableSegments()) {
            lineStrings.add(rel.getSegment().getGeom());
        }
        Collection<ImmutablePolygon> parts = StreetsegmentHelper.getParts(lineStrings, maxSegmentCount);
        if (parts.size() == 1) {
            return parts.iterator().next();
        }
        if (coordinateFactory == null) {
            coordinateFactory = parts.iterator().next().getCoordinateFactory();
        }
        ImmutablePolygonKind immutableMultiPolygon = GeoUtils.createImmutableMultiPolygon(parts);
        double b = coordinateFactory.getRefScale() / 10.0;
        return (ImmutablePolygonKind)immutableMultiPolygon.buffer(b);
    }
}

