/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.areagenerator;

import com.vividsolutions.jts.geom.TopologyException;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.util.algorithm.selfintersection.PolygonSelfIntersectionKiller;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.util.GeoUtils;
import java.util.Collection;
import java.util.Iterator;

public class FreehandAreaGenerator {
    public static final FreehandAreaGenerator INSTANCE = new FreehandAreaGenerator();

    protected FreehandAreaGenerator() {
    }

    public void createAreaGeometryRemovePolygons(AreaObjectModel selectedObject, Collection<ImmutablePolygonKind> freehandSelection, ModelEnviroment modelEnviroment) {
        ImmutablePolygonKind basePolygon = selectedObject.getGeom();
        if (basePolygon != null && freehandSelection != null) {
            for (ImmutablePolygonKind immutablePolygon : freehandSelection) {
                if (immutablePolygon == null) continue;
                try {
                    basePolygon = (ImmutablePolygonKind)basePolygon.difference(immutablePolygon);
                }
                catch (TopologyException ex) {
                    PolygonSelfIntersectionKiller polygonSelfIntersectionKiller = new PolygonSelfIntersectionKiller(immutablePolygon);
                    polygonSelfIntersectionKiller.start(false);
                    immutablePolygon = polygonSelfIntersectionKiller.getResult();
                    try {
                        basePolygon = (ImmutablePolygonKind)basePolygon.difference(immutablePolygon);
                    }
                    catch (TopologyException topologyException) {}
                }
            }
            selectedObject.setGeom(basePolygon);
        }
    }

    public void createAreaGeometryAddPolygons(AreaObjectModel selectedObject, Collection<ImmutablePolygonKind> freehandSelection, ModelEnviroment modelEnviroment) {
        if (freehandSelection != null && !freehandSelection.isEmpty()) {
            ImmutablePolygonKind basePolygon = selectedObject.getGeom();
            Iterator<ImmutablePolygonKind> iter = freehandSelection.iterator();
            if (basePolygon == null) {
                basePolygon = iter.next();
            }
            while (iter.hasNext()) {
                ImmutablePolygonKind next = iter.next();
                try {
                    basePolygon = (ImmutablePolygonKind)basePolygon.union(next);
                }
                catch (TopologyException topologyException) {
                    next = GeoUtils.killSelfIntersections(next);
                    try {
                        basePolygon = (ImmutablePolygonKind)basePolygon.union(next);
                    }
                    catch (TopologyException topologyException2) {
                        basePolygon = GeoUtils.killSelfIntersections(basePolygon);
                        try {
                            basePolygon = (ImmutablePolygonKind)basePolygon.union(next);
                        }
                        catch (TopologyException topologyException3) {}
                    }
                }
            }
            selectedObject.setGeom(basePolygon);
        }
    }

    public void createAreaGeometryReplace(AreaObjectModel selectedObject, Collection<ImmutablePolygonKind> freeHands, ModelEnviroment modelEnviroment) {
        selectedObject.setGeom(null);
        this.createAreaGeometryAddPolygons(selectedObject, freeHands, modelEnviroment);
    }
}

