/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.areagenerator;

import com.vividsolutions.jts.geom.TopologyException;
import de.datomino.peppergis.client.areagenerator.UnionAreaGenerator;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaObjectGenAreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenAreaObjectModelImpl;
import de.datomino.peppergis.client.model.area.AreaObjectGenAreaObjectRelModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenAreaObjectRelModelImpl;
import de.datomino.peppergis.client.model.area.AreaObjectGenInfoModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenInfoModelImpl;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.util.algorithm.selfintersection.PolygonSelfIntersectionKiller;
import de.datomino.util.algorithm.smooth.PolygonSmoother;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableGeometryCollection;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutableMultiPolygon;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.exception.IllegalPointCountException;
import de.datomino.util.geo.util.GeoUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.ktde.math.projection.OpenStreetmapViewFactory;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultUnionAreaGenerator
implements UnionAreaGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultUnionAreaGenerator.class);
    public static final UnionAreaGenerator INSTANCE = new DefaultUnionAreaGenerator();

    private DefaultUnionAreaGenerator() {
    }

    @Override
    public void createAreaGeometryAddAreaObjects(AreaObjectModel currentAreaObject, Collection<AreaObjectModel> areas, ModelEnviroment modelEnviroment) {
        AreaObjectGenAreaObjectModel data = this.getGeninfo(currentAreaObject);
        HashSet<AreaObjectModel> newAreaObjects = new HashSet<AreaObjectModel>();
        Set<AreaObjectModel> known = AreaObjectModelUtil.getKnownAreaObjects(data);
        for (AreaObjectModel areaObjectDo : areas) {
            if (known.contains(areaObjectDo)) continue;
            newAreaObjects.add(areaObjectDo);
        }
        this.generateArea(currentAreaObject, newAreaObjects, null, modelEnviroment);
    }

    @Override
    public void createAreaGeometryRemoveAreaObjects(AreaObjectModel currentAreaObject, Collection<AreaObjectModel> areas, ModelEnviroment modelEnviroment) {
        AreaObjectGenAreaObjectModel data = this.getGeninfo(currentAreaObject);
        HashSet<AreaObjectModel> todelAreaObjects = new HashSet<AreaObjectModel>();
        Set<AreaObjectModel> known = AreaObjectModelUtil.getKnownAreaObjects(data);
        for (AreaObjectModel areaObject : areas) {
            if (!known.contains(areaObject)) continue;
            todelAreaObjects.add(areaObject);
        }
        this.generateArea(currentAreaObject, null, todelAreaObjects, modelEnviroment);
    }

    @Override
    public void createAreaGeometryReplaceAreaObjects(AreaObjectModel currentAreaObject, Collection<AreaObjectModel> areas, ModelEnviroment modelEnviroment) {
        AreaObjectGenAreaObjectModel data = this.getGeninfo(currentAreaObject);
        HashSet<AreaObjectModel> todelAreaObjects = new HashSet<AreaObjectModel>();
        HashSet<AreaObjectModel> newAreaObjects = new HashSet<AreaObjectModel>();
        Set<AreaObjectModel> known = AreaObjectModelUtil.getKnownAreaObjects(data);
        for (AreaObjectModel areaObjectDo : areas) {
            if (known.contains(areaObjectDo)) continue;
            newAreaObjects.add(areaObjectDo);
        }
        for (AreaObjectModel areaObject : known) {
            if (areas.contains(areaObject)) continue;
            todelAreaObjects.add(areaObject);
        }
        this.generateArea(currentAreaObject, newAreaObjects, todelAreaObjects, modelEnviroment);
    }

    private AreaObjectGenAreaObjectModel getGeninfo(AreaObjectModel currentAreaObject) {
        AreaObjectGenInfoModel geninfo = currentAreaObject.getGenInfo();
        if (geninfo == null) {
            geninfo = new AreaObjectGenInfoModelImpl();
            geninfo.setAreaObject(currentAreaObject);
            AreaObjectGenAreaObjectModelImpl genareaobject = new AreaObjectGenAreaObjectModelImpl();
            geninfo.setAreaObjectGenAreaObject(genareaobject);
        }
        AreaObjectGenAreaObjectModel data = currentAreaObject.getGenInfo().getAreaObjectGenAreaObject();
        return data;
    }

    private Set<AreaObjectModel> generateArea(AreaObjectModel currentAreaObject, Collection<AreaObjectModel> toaddAreaObjects, Collection<AreaObjectModel> todelAreaObjects, ModelEnviroment modelEnviroment) {
        AreaObjectGenAreaObjectModel areaObjectinfo = currentAreaObject.getGenInfo().getAreaObjectGenAreaObject();
        Set<AreaObjectModel> knownAreaObjects = AreaObjectModelUtil.getKnownAreaObjects(areaObjectinfo);
        HashSet<AreaObjectGenAreaObjectRelModel> existingareaObjects = new HashSet<AreaObjectGenAreaObjectRelModel>();
        for (AreaObjectGenAreaObjectRelModel areaObjectGenAreaObjectRelModel : areaObjectinfo.iterableAreaObjects()) {
            existingareaObjects.add(areaObjectGenAreaObjectRelModel);
        }
        for (AreaObjectGenAreaObjectRelModel existing : existingareaObjects) {
            AreaObjectModel areaObject = existing.getAreaObject();
            if (todelAreaObjects == null || !todelAreaObjects.contains(areaObject)) continue;
            existing.setAreaObject(null);
            existing.setGenInfoAreaObject(null);
            knownAreaObjects.remove(areaObject);
        }
        if (toaddAreaObjects != null) {
            for (AreaObjectModel areaObject : toaddAreaObjects) {
                AreaObjectGenAreaObjectRelModelImpl rel = new AreaObjectGenAreaObjectRelModelImpl();
                rel.setAreaObject(areaObject);
                rel.setGenInfoAreaObject(areaObjectinfo);
                knownAreaObjects.add(areaObject);
            }
        }
        HashSet<AreaObjectModel> result = new HashSet<AreaObjectModel>();
        Iterator<AreaObjectModel> iterator = knownAreaObjects.iterator();
        if (iterator.hasNext()) {
            ImmutableGeoObject resultPolygon = null;
            while (resultPolygon == null && iterator.hasNext()) {
                AreaObjectModel first = iterator.next();
                resultPolygon = first.getGeom();
            }
            while (iterator.hasNext()) {
                AreaObjectModel next = iterator.next();
                ImmutablePolygonKind geom = next.getGeom();
                if (geom == null) continue;
                try {
                    resultPolygon = (ImmutablePolygonKind)resultPolygon.union(geom);
                }
                catch (TopologyException e) {
                    ImmutableGeoObject broken = resultPolygon instanceof ImmutableGeometryCollection ? ((ImmutableGeometryCollection)resultPolygon).unionPolygonsToOneMultiPolygon() : resultPolygon;
                    PolygonSelfIntersectionKiller polygonSelfIntersectionKiller = new PolygonSelfIntersectionKiller((ImmutablePolygonKind)broken);
                    polygonSelfIntersectionKiller.start(false);
                    resultPolygon = polygonSelfIntersectionKiller.getResult();
                    polygonSelfIntersectionKiller = new PolygonSelfIntersectionKiller(geom);
                    polygonSelfIntersectionKiller.start(false);
                    geom = polygonSelfIntersectionKiller.getResult();
                    if (geom.getCoordinates().contains(null)) continue;
                    try {
                        resultPolygon = (ImmutablePolygonKind)resultPolygon.union(geom);
                    }
                    catch (TopologyException ex) {
                        try {
                            resultPolygon = (ImmutablePolygonKind)resultPolygon.union(geom.convexHull());
                        }
                        catch (TopologyException topologyException) {}
                    }
                }
            }
            if (resultPolygon instanceof ImmutablePolygon) {
                currentAreaObject.setGeom(ImmutableGeoObjectFactory.createImmutableMultiPolygonByParts(resultPolygon.getCoordinateFactory(), Collections.singletonList((ImmutablePolygon)resultPolygon)));
            } else if (resultPolygon instanceof ImmutableMultiPolygon) {
                currentAreaObject.setGeom((ImmutableMultiPolygon)resultPolygon);
            } else if (resultPolygon instanceof ImmutableGeometryCollection) {
                currentAreaObject.setGeom(((ImmutableGeometryCollection)resultPolygon).unionPolygonsToOneMultiPolygon());
            } else {
                throw new IllegalStateException("Ergebnis-Geometrie ist weder Polygon noch Multipolygon!");
            }
            result.add(currentAreaObject);
        }
        return result;
    }

    @Override
    public void smoothAreaGeometry(AreaObjectModel currentAreaObject, ModelEnviroment modelEnviroment, double mindist) {
        AreaObjectGenAreaObjectModel data = this.getGeninfo(currentAreaObject);
        Set<AreaObjectModel> knownAreaObjects = AreaObjectModelUtil.getKnownAreaObjects(data);
        currentAreaObject.setGeom(this.smoothAreaObjects(knownAreaObjects, mindist));
    }

    @Override
    public void removeSmoothings(AreaObjectModel currentAreaObject, ModelEnviroment modelEnviroment) {
        AreaObjectGenAreaObjectModel data = this.getGeninfo(currentAreaObject);
        Set<AreaObjectModel> knownAreaObjects = AreaObjectModelUtil.getKnownAreaObjects(data);
        List<AreaObjectModel> emptyList = Collections.emptyList();
        this.createAreaGeometryAddAreaObjects(currentAreaObject, emptyList, modelEnviroment);
        currentAreaObject.setGeom(null);
        this.createAreaGeometryAddAreaObjects(currentAreaObject, knownAreaObjects, modelEnviroment);
    }

    private ImmutablePolygonKind smoothAreaObjects(Set<AreaObjectModel> set, double dist) {
        return this.smoothAreaObjects(set, dist, null);
    }

    private ImmutablePolygonKind smoothAreaObjects(Set<AreaObjectModel> set, double dist, ImmutablePolygonKind base) {
        ArrayList<ImmutablePolygonKind> polygons = new ArrayList<ImmutablePolygonKind>(set.size());
        for (AreaObjectModel areaObjectModel : set) {
            ImmutablePolygonKind geom = areaObjectModel.getGeom();
            polygons.add(geom);
        }
        PolygonSmoother polygonSmoother = new PolygonSmoother(polygons, dist, OpenStreetmapViewFactory.INSTANCE);
        polygonSmoother.start(false);
        return polygonSmoother.getResult();
    }

    private List<ImmutablePolygonKind> unifyTouchingPolygons(List<ImmutablePolygonKind> polygons) {
        if (polygons.size() <= 1) {
            return polygons;
        }
        ArrayList<ImmutablePolygonKind> copy = new ArrayList<ImmutablePolygonKind>(polygons);
        boolean gUnioned = false;
        do {
            gUnioned = false;
            ArrayList result = new ArrayList(copy.size());
            Iterator iter = copy.iterator();
            result.add(iter.next());
            while (iter.hasNext()) {
                ImmutablePolygonKind next = (ImmutablePolygonKind)iter.next();
                int i = 0;
                boolean unioned = false;
                for (ImmutablePolygonKind r : result) {
                    if (r.intersects(next) || r.touches(next)) {
                        try {
                            r = (ImmutablePolygonKind)r.union(next);
                        }
                        catch (Exception ex) {
                            continue;
                        }
                        result.set(i, r);
                        unioned = true;
                        gUnioned = true;
                        break;
                    }
                    ++i;
                }
                if (unioned) continue;
                result.add(next);
            }
            copy = result;
        } while (gUnioned);
        return copy;
    }

    private ImmutablePolygonKind smoothPolygons(ImmutablePolygonKind polygon1, ImmutablePolygonKind polygon2, double dist, boolean refresh1, Map<ImmutablePolygon, ImmutablePolygonKind> streched) {
        ImmutablePolygonKind result;
        ImmutableGeoObject intersection;
        double hDist = dist;
        ImmutablePolygonKind stretch1 = GeoUtils.stretchBlocks(polygon1, hDist, streched);
        ImmutablePolygonKind stretch2 = GeoUtils.stretchBlocks(polygon2, hDist, streched);
        if (stretch2 == null) {
            stretch2 = GeoUtils.stretchBlocks(polygon2, hDist, streched);
        }
        if ((intersection = stretch1.intersection(stretch2)) instanceof ImmutablePolygonKind) {
            intersection = GeoUtils.stretchBlocks((ImmutablePolygonKind)intersection, 1.0, streched);
        }
        try {
            result = (ImmutablePolygonKind)polygon1.union(polygon2);
        }
        catch (Exception ex) {
            PolygonSelfIntersectionKiller polygonSelfIntersectionKiller1 = new PolygonSelfIntersectionKiller(polygon1);
            polygonSelfIntersectionKiller1.start(false);
            ImmutablePolygonKind mPolygon1 = polygonSelfIntersectionKiller1.getResult();
            PolygonSelfIntersectionKiller polygonSelfIntersectionKiller2 = new PolygonSelfIntersectionKiller(polygon2);
            polygonSelfIntersectionKiller2.start(false);
            ImmutablePolygonKind mPolygon2 = polygonSelfIntersectionKiller2.getResult();
            result = (ImmutablePolygonKind)mPolygon1.union(mPolygon2);
        }
        if (intersection instanceof ImmutablePolygonKind && intersection.intersects(polygon1) && intersection.intersects(polygon2)) {
            try {
                intersection = this.cutHorns2((ImmutablePolygonKind)intersection, polygon1, polygon2);
            }
            catch (Exception ex) {
                LOGGER.warn("Could not cut horns");
                intersection = this.cutHorns2((ImmutablePolygonKind)intersection, polygon1, polygon2);
            }
            if (intersection != null) {
                ImmutableGeoObject union = result.union(intersection);
                if (union instanceof ImmutablePolygonKind) {
                    result = (ImmutablePolygonKind)union;
                } else if (union instanceof ImmutableGeometryCollection) {
                    result = ((ImmutableGeometryCollection)union).unionPolygonsToOneMultiPolygon();
                }
            }
            if (refresh1) {
                result = this.refreshHoles(result, polygon1, null);
            }
            result = this.refreshHoles(result, polygon2, refresh1 ? null : polygon1);
        }
        return result;
    }

    private ImmutablePolygonKind refreshHoles(ImmutablePolygonKind bigPolygon, ImmutablePolygonKind polygon, ImmutablePolygonKind origPolygon) {
        List<ImmutableLineString> holes;
        if (polygon instanceof ImmutablePolygon) {
            holes = ((ImmutablePolygon)polygon).getHoles();
        } else {
            List parts = ((ImmutableMultiPolygon)polygon).getParts();
            holes = new LinkedList<ImmutableLineString>();
            for (ImmutablePolygon part : parts) {
                holes.addAll(part.getHoles());
            }
        }
        ImmutablePolygonKind result = bigPolygon;
        for (ImmutableLineString hole : holes) {
            try {
                ImmutablePolygon holePolygon = ImmutableGeoObjectFactory.createImmutablePolygonByLineStrings(hole, new ImmutableLineString[0]);
                result = (ImmutablePolygonKind)result.difference(holePolygon);
            }
            catch (IllegalPointCountException illegalPointCountException) {}
        }
        if (origPolygon != null) {
            result = (ImmutablePolygonKind)result.union(origPolygon);
        }
        return result;
    }

    private ImmutablePolygonKind cutHorns2(ImmutablePolygonKind intersection, ImmutablePolygonKind polygon1, ImmutablePolygonKind polygon2) {
        ImmutableGeometryCollection immutableGeometryCollection;
        Object union;
        List<Object> iPolygons = Collections.emptyList();
        if (intersection instanceof ImmutablePolygon) {
            iPolygons = Collections.singletonList((ImmutablePolygon)intersection);
        } else if (intersection instanceof ImmutableMultiPolygon) {
            iPolygons = ((ImmutableMultiPolygon)intersection).getParts();
        } else if (intersection instanceof ImmutableGeometryCollection && (union = (immutableGeometryCollection = (ImmutableGeometryCollection)((Object)intersection)).unionPolygonsToOneMultiPolygon()) != null) {
            if (union instanceof ImmutablePolygon) {
                iPolygons = Collections.singletonList((ImmutablePolygon)union);
            } else if (union instanceof ImmutableMultiPolygon) {
                iPolygons = ((ImmutableMultiPolygon)union).getParts();
            }
        }
        ArrayList<ImmutablePolygon> rPolygons = new ArrayList<ImmutablePolygon>(iPolygons.size());
        for (ImmutablePolygon iPolygon : iPolygons) {
            LinkedList<ImmutablePoint> iPoints = new LinkedList<ImmutablePoint>(iPolygon.getShell().getCoordinates());
            if (((ImmutablePoint)iPoints.get(0)).equals(iPoints.get(iPoints.size() - 1))) {
                iPoints.remove(iPoints.size() - 1);
            }
            iPoints.add((ImmutablePoint)iPoints.get(0));
            Iterator iter = iPoints.iterator();
            ImmutablePoint p1 = (ImmutablePoint)iter.next();
            LinkedList<ImmutablePoint> nPoints = new LinkedList<ImmutablePoint>();
            while (iter.hasNext()) {
                ImmutablePoint p2 = (ImmutablePoint)iter.next();
                ImmutableLineString lineString = ImmutableGeoObjectFactory.createImmutableLineStringByPoints(p1, p2, new ImmutablePoint[0]);
                ImmutableGeoObject lIntersection1 = polygon1.intersection(lineString);
                ImmutableLineString iLineString1 = null;
                if (lIntersection1 instanceof ImmutableLineString) {
                    iLineString1 = (ImmutableLineString)lIntersection1;
                }
                ImmutableGeoObject lIntersection2 = polygon2.intersection(lineString);
                ImmutableLineString iLineString2 = null;
                if (lIntersection2 instanceof ImmutableLineString) {
                    iLineString2 = (ImmutableLineString)lIntersection2;
                }
                if (iLineString1 != null || iLineString2 != null) {
                    double distEnd;
                    ImmutablePoint end;
                    ImmutablePoint start;
                    if (iLineString1 != null && iLineString2 != null) {
                        ImmutablePoint start1 = iLineString1.getStartPoint();
                        ImmutablePoint end1 = iLineString1.getEndPoint();
                        ImmutablePoint start2 = iLineString2.getStartPoint();
                        ImmutablePoint end2 = iLineString2.getEndPoint();
                        double distStart1 = p1.distance(start1);
                        double distEnd1 = p1.distance(end1);
                        double distStart2 = p1.distance(start1);
                        double distEnd2 = p1.distance(end1);
                        List<Tupel> tupels = Arrays.asList(new Tupel<Double, ImmutablePoint>(distStart1, start1), new Tupel<Double, ImmutablePoint>(distEnd1, end1), new Tupel<Double, ImmutablePoint>(distStart2, start2), new Tupel<Double, ImmutablePoint>(distEnd2, end2));
                        Collections.sort(tupels);
                        for (Tupel tupel : tupels) {
                            nPoints.add((ImmutablePoint)tupel.getElement2());
                        }
                    } else if (iLineString1 != null) {
                        start = iLineString1.getStartPoint();
                        end = iLineString1.getEndPoint();
                        double distStart = p1.distance(start);
                        distEnd = p1.distance(end);
                        if (distEnd < distStart) {
                            ImmutablePoint swap = start;
                            start = end;
                            end = swap;
                        }
                        nPoints.add(start);
                        nPoints.add(end);
                    } else if (iLineString2 != null) {
                        start = iLineString2.getStartPoint();
                        end = iLineString2.getEndPoint();
                        double distStart = p1.distance(start);
                        distEnd = p1.distance(end);
                        if (distEnd < distStart) {
                            ImmutablePoint swap = start;
                            start = end;
                            end = swap;
                        }
                        nPoints.add(start);
                        nPoints.add(end);
                    }
                }
                p1 = p2;
            }
            if (nPoints.isEmpty()) continue;
            try {
                ImmutablePolygon polygon = ImmutableGeoObjectFactory.createImmutablePolygon(nPoints);
                rPolygons.add(polygon);
            }
            catch (IllegalPointCountException illegalPointCountException) {}
        }
        ImmutableMultiPolygon cutPolygon = ImmutableGeoObjectFactory.createImmutableMultiPolygonByParts(intersection.getCoordinateFactory(), rPolygons);
        PolygonSelfIntersectionKiller polygonSelfIntersectionKiller = new PolygonSelfIntersectionKiller(cutPolygon);
        polygonSelfIntersectionKiller.start(false);
        return polygonSelfIntersectionKiller.getResult();
    }

    private ImmutablePolygonKind cutHorns(ImmutablePolygonKind intersection, ImmutablePolygonKind polygon1, ImmutablePolygonKind polygon2) {
        List<ImmutablePolygon> iPolygons = intersection instanceof ImmutablePolygon ? Collections.singletonList((ImmutablePolygon)intersection) : ((ImmutableMultiPolygon)intersection).getParts();
        ArrayList<ImmutablePolygon> rPolygons = new ArrayList<ImmutablePolygon>(iPolygons.size());
        for (ImmutablePolygon iPolygon : iPolygons) {
            List<ImmutablePoint> iPoints = iPolygon.getShell().getCoordinates();
            Stack<Integer> rIndices = new Stack<Integer>();
            int index = 0;
            for (ImmutablePoint iPoint : iPoints) {
                if (polygon1.disjoint(iPoint) && polygon2.disjoint(iPoint) && !iPoint.touches(polygon1) && !iPoint.touches(polygon2)) {
                    rIndices.push(index);
                }
                ++index;
            }
            LinkedList<ImmutablePoint> nPoints = new LinkedList<ImmutablePoint>(iPoints);
            while (!rIndices.isEmpty()) {
                nPoints.remove((Integer)rIndices.pop());
            }
            ImmutablePolygon rPolygon = null;
            try {
                rPolygon = ImmutableGeoObjectFactory.createImmutablePolygon(nPoints);
            }
            catch (IllegalPointCountException illegalPointCountException) {
                // empty catch block
            }
            if (rPolygon == null) continue;
            rPolygons.add(rPolygon);
        }
        ImmutableMultiPolygon cutPolygon = ImmutableGeoObjectFactory.createImmutableMultiPolygonByParts(intersection.getCoordinateFactory(), rPolygons);
        PolygonSelfIntersectionKiller polygonSelfIntersectionKiller = new PolygonSelfIntersectionKiller(cutPolygon);
        polygonSelfIntersectionKiller.start(false);
        return polygonSelfIntersectionKiller.getResult();
    }
}

