/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.alias.bulk;

import de.datomino.peppergis.client.alias.bulk.AbstractBulkAliasInsertAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.DistrictAliasModel;
import de.datomino.peppergis.client.model.map.DistrictAliasModelImpl;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.util.international.country.Country;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.collections.Transformer;
import org.ktde.util.StringUtil;

public class DistrictBulkAliasInsertAction
extends AbstractBulkAliasInsertAction<DistrictModel> {
    private static final long serialVersionUID = 5305248687863294354L;

    public DistrictBulkAliasInsertAction(Window parent, ModelEnviroment modelEnviroment) {
        super(parent, modelEnviroment);
    }

    @Override
    protected void createAlias(DistrictModel t, String newAlias) {
        DistrictAliasModelImpl districtAliasModel = new DistrictAliasModelImpl();
        districtAliasModel.setName(newAlias);
        districtAliasModel.setSearch(StringUtil.normalize(newAlias));
        districtAliasModel.setDistrict(t);
    }

    @Override
    protected String getSearchTitle() {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.alias.bulkDistrictSearch", new Serializable[0]);
    }

    @Override
    protected String getConfirmTitle() {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.alias.bulkDistrictConfirm", new Serializable[0]);
    }

    @Override
    protected List<DistrictModel> getMatchedModels(String part) {
        Collection<DistrictModel> streets = this.getModelEnviroment().getAllCaller().getStreetSearchCaller().searchDistrictWithPart(part);
        return new ArrayList<DistrictModel>(streets);
    }

    @Override
    protected String getDescription(DistrictModel t) {
        Iterator iter;
        CityModel city = t.getCity();
        HashSet<Country> countries = new HashSet<Country>();
        ArrayList<PostcodeModel> postcodes = new ArrayList<PostcodeModel>(t.countPostcodes());
        for (PostcodeDistrictRelationModel postcodeDistrictRelationModel : t.iterablePostcodes()) {
            PostcodeModel postcode = postcodeDistrictRelationModel.getPostcode();
            postcodes.add(postcode);
            Country country = postcode.getCountry();
            if (country == null) continue;
            countries.add(country);
        }
        Collections.sort(postcodes, ComparatorUtils.transformedComparator(ComparatorUtils.naturalComparator(), new Transformer(){

            @Override
            public Object transform(Object input) {
                return ((PostcodeModel)input).getName();
            }
        }));
        StringBuilder sb = new StringBuilder();
        if (countries.isEmpty()) {
            sb.append("?");
        } else if (countries.size() == 1) {
            sb.append(((Country)countries.iterator().next()).getVehicleSign());
        } else {
            sb.append("(");
            iter = countries.iterator();
            sb.append(((Country)iter.next()).getVehicleSign());
            do {
                sb.append(", ").append(((Country)iter.next()).getVehicleSign());
            } while (iter.hasNext());
            sb.append(")");
        }
        sb.append(", ");
        if (postcodes.isEmpty()) {
            sb.append("?");
        } else if (postcodes.size() == 1) {
            sb.append(((PostcodeModel)postcodes.get(0)).getName());
        } else {
            sb.append("(");
            iter = postcodes.iterator();
            sb.append(((PostcodeModel)iter.next()).getName());
            do {
                sb.append(", ").append(((PostcodeModel)iter.next()).getName());
            } while (iter.hasNext());
            sb.append(")");
        }
        sb.append(" ").append(city == null ? "?" : city.getName()).append(" - ").append(t.getName());
        return sb.toString();
    }

    @Override
    protected String getReplacedValue(DistrictModel t, String part, String replacement) {
        String name = t.getName();
        int index = name.toLowerCase().indexOf(part.toLowerCase());
        if (index >= 0) {
            return name.substring(0, index) + replacement + name.substring(index + part.length(), name.length());
        }
        return name;
    }

    @Override
    protected List<String> getAliasNames(DistrictModel t) {
        ArrayList<String> aliasNames = new ArrayList<String>(t.countAlias());
        for (DistrictAliasModel alias : t.iterableAlias()) {
            aliasNames.add(alias.getName());
        }
        Collections.sort(aliasNames);
        return aliasNames;
    }
}

