/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.action.search;

import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticQualifiedLocationDto;
import de.datomino.peppergis.client.communication.StreetNetCaller;
import de.datomino.peppergis.client.gui.DefaultPointRenderer;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePointDto;
import de.datomino.util.international.country.Country;
import de.datomino.util.international.country.CountryUtil;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.swing.navigator.listener.NavigatorRendererActiveListener;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public class CommonSearchAction
extends AbstractAction {
    private static final long serialVersionUID = -503065577673128270L;
    private JTextField country = new JTextField();
    private JTextField postcode = new JTextField();
    private JTextField city = new JTextField();
    private JTextField district = new JTextField();
    private JTextField street = new JTextField();
    private JTextField housenumber = new JTextField();
    private JTextField housenumberExtension = new JTextField();
    private JTextField coordinateX = new JTextField();
    private JTextField coordinateY = new JTextField();
    private JTextField parcelId = new JTextField();
    private EnumComboBox<CoordinateFactory.Projections> coordinateFormat = new EnumComboBox<CoordinateFactory.Projections>(CoordinateFactory.Projections.class, false, CoordinateFactory.getListableProjections());
    private JRadioButton useAddress = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("gui.location.useAddress", new Serializable[0]), true);
    private JRadioButton useCoord = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("gui.location.useCoordinate", new Serializable[0]));
    private JRadioButton useParcelId = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("gui.location.useParcelId", new Serializable[0]));
    NavigatorPanel navigator;
    private Component owner;
    private CommonSearchActionRenderer renderer;
    private Coordinate coordinate;
    private ModelEnviroment modelEnviroment;
    private int rendererSortOrder = Integer.MAX_VALUE;
    private CommonSearchAction buddyAction;
    private boolean parcelOnly;

    public CommonSearchAction(Component owner, NavigatorPanel navigator, ModelEnviroment modelEnviroment, boolean isButton, boolean parcelOnly) {
        this(owner, navigator, null, modelEnviroment, isButton, parcelOnly);
    }

    public CommonSearchAction(Component owner, NavigatorPanel navigator, ModelEnviroment modelEnviroment, boolean withrenderer, boolean isButton, boolean parcelOnly) {
        this(owner, navigator, null, modelEnviroment, withrenderer, isButton, parcelOnly);
    }

    public CommonSearchAction(Component owner, NavigatorPanel navigator, String country, ModelEnviroment modelEnviroment, boolean isButton, boolean parcelOnly) {
        this(owner, navigator, country, modelEnviroment, true, isButton, parcelOnly);
    }

    public CommonSearchAction(Component owner, NavigatorPanel navigator, String country, ModelEnviroment modelEnviroment, boolean withRenderer, boolean isButton, boolean parcelOnly) {
        super(isButton ? ModelEnviroment.getMessageResolver().resolveMessage("gui.location.searchLocation", new Serializable[0]) : ModelEnviroment.getMessageResolver().resolveMessage("gui.location.searchLocationMenu", new Serializable[0]));
        this.modelEnviroment = modelEnviroment;
        this.navigator = navigator;
        this.owner = owner;
        this.parcelOnly = parcelOnly;
        this.renderer = new CommonSearchActionRenderer();
        if (withRenderer) {
            this.navigator.addRenderer(this.renderer);
        }
        if (country != null) {
            this.country.setText(country);
        }
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, 128));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JPanel main = new JPanel(new BorderLayout());
        JPanel options = new JPanel(new SpringLayout());
        options.add(this.useAddress);
        String label1 = ModelEnviroment.getMessageResolver().resolveMessage("address.country", new Serializable[0]);
        String label2 = ModelEnviroment.getMessageResolver().resolveMessage("address.postcode", new Serializable[0]);
        String label3 = ModelEnviroment.getMessageResolver().resolveMessage("address.city", new Serializable[0]);
        String label4 = ModelEnviroment.getMessageResolver().resolveMessage("address.district", new Serializable[0]);
        String label5 = ModelEnviroment.getMessageResolver().resolveMessage("address.street", new Serializable[0]);
        String label6 = ModelEnviroment.getMessageResolver().resolveMessage("address.housenumber", new Serializable[0]);
        String label7 = ModelEnviroment.getMessageResolver().resolveMessage("address.housenumberExt", new Serializable[0]);
        JPanel search = new JPanel(new SpringLayout());
        search.add(new JLabel(label1));
        search.add(this.country);
        search.add(new JLabel(label2));
        search.add(this.postcode);
        search.add(new JLabel(label3));
        search.add(this.city);
        search.add(new JLabel(label4));
        search.add(this.district);
        search.add(new JLabel(label5));
        search.add(this.street);
        search.add(new JLabel(label6));
        search.add(this.housenumber);
        search.add(new JLabel(label7));
        search.add(this.housenumberExtension);
        SpringUtilities.makeCompactGrid(search, 7, 2, 5, 5, 2, 2);
        options.add(search);
        options.add(this.useCoord);
        search = new JPanel(new SpringLayout());
        search.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gis.coordinate.x", new Serializable[0])));
        search.add(this.coordinateX);
        search.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gis.coordinate.y", new Serializable[0])));
        search.add(this.coordinateY);
        search.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gis.coordinate_factory.name", new Serializable[0])));
        this.coordinateFormat.setSelectedValue(CoordinateFactory.Projections.Wgs84);
        search.add(this.coordinateFormat);
        SpringUtilities.makeCompactGrid(search, 3, 2, 5, 5, 2, 2);
        options.add(search);
        options.add(this.useParcelId);
        search = new JPanel(new SpringLayout());
        search.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.location.useParcelId", new Serializable[0])));
        search.add(this.parcelId);
        SpringUtilities.makeCompactGrid(search, 1, 2, 5, 5, 2, 2);
        options.add(search);
        SpringUtilities.makeCompactGrid(options, 6, 1, 5, 5, 5, 5);
        main.add((Component)options, "North");
        ButtonGroup group = new ButtonGroup();
        group.add(this.useAddress);
        group.add(this.useCoord);
        group.add(this.useParcelId);
        RadioActionListener radioActionListener = new RadioActionListener();
        this.useAddress.addActionListener(radioActionListener);
        this.useCoord.addActionListener(radioActionListener);
        this.useParcelId.addActionListener(radioActionListener);
        this.setEnabledBySelection();
        boolean tryagain = true;
        while (tryagain && JOptionPane.showConfirmDialog(this.owner, main, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.searchAddress", new Serializable[0]), 2) == 0) {
            tryagain = false;
            ImmutablePoint point = null;
            boolean multiCanceled = false;
            try {
                if (this.useCoord.isSelected()) {
                    CoordinateFactory factory = CoordinateFactory.getInstance(this.coordinateFormat.getSelectedValue());
                    Coordinate coord = factory.createCoordinate(ClientFormUtil.getNumber(this.coordinateX.getText()).doubleValue(), ClientFormUtil.getNumber(this.coordinateY.getText()).doubleValue());
                    point = ImmutableGeoObjectFactory.createImmutablePoint(coord);
                } else if (this.useAddress.isSelected()) {
                    Tripel<ImmutablePoint, Boolean, Boolean> tupel = this.doAddressSearch();
                    tryagain = tupel.getElement2();
                    point = tupel.getElement1();
                    multiCanceled = tupel.getElement3();
                } else if (this.useParcelId.isSelected()) {
                    point = this.doParcelIdSearch();
                }
                if (GeoUtil.isNullPoint(point)) {
                    if (!multiCanceled) {
                        JOptionPane.showMessageDialog(this.owner, ModelEnviroment.getMessageResolver().resolveMessage("messages.locationNotFound", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.locationNotFound", new Serializable[0]), 1);
                    }
                    tryagain = true;
                } else {
                    this.doAfterFindingCoordinate(point);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                tryagain = true;
                JOptionPane.showMessageDialog(this.owner, ex.getMessage(), "Fehler", 0);
            }
            if (tryagain) continue;
            double upp = this.navigator.getUpp();
            double supp = this.navigator.getScaledUpp();
            double ratio = supp / upp;
            this.navigator.zoom(ratio);
            this.navigator.repaint(10L);
        }
    }

    protected void doAfterFindingCoordinate(ImmutablePoint point) {
        Coordinate createCoordinate = this.navigator.getCoordinateFactory().createCoordinate(point.getCoordinate());
        this.setCoordinate(createCoordinate);
        this.navigator.gotoCoordinate(this.coordinate);
    }

    private ImmutablePoint doParcelIdSearch() {
        ParcelModel parcel;
        ImmutablePoint geom;
        int index;
        String parcelId = this.parcelId.getText().trim();
        StreetNetCaller streetNetCaller = this.modelEnviroment.getAllCaller().getStreetNetCaller();
        Tupel<Collection<ParcelModel>, Integer> result = streetNetCaller.searchParcelByNumberPart(parcelId, 10);
        Integer count = result.getElement2();
        if (count == 0) {
            return null;
        }
        ArrayList<ParcelModel> parcels = new ArrayList<ParcelModel>(result.getElement1());
        ParcelModel exact = null;
        ParcelModel exactIgnoreCase = null;
        for (ParcelModel ip : parcels) {
            String importKey = ip.getImportKey();
            if (parcelId.equals(importKey.trim())) {
                exact = ip;
                break;
            }
            if (exactIgnoreCase != null || !parcelId.equalsIgnoreCase(importKey.trim())) continue;
            exactIgnoreCase = ip;
        }
        if (exact != null) {
            return exact.getGeom();
        }
        if (exactIgnoreCase != null) {
            return exactIgnoreCase.getGeom();
        }
        DefaultListModel<String> dlm = new DefaultListModel<String>();
        JList list = new JList(dlm);
        for (ParcelModel parcel2 : parcels) {
            StringBuilder sb = new StringBuilder(parcel2.getImportKey()).append(" - ");
            StreetModel street = parcel2.getStreet();
            PostcodeDistrictRelationModel pdr = street.getPostcodeDistrictRelation();
            PostcodeModel postcode = pdr.getPostcode();
            DistrictModel district = pdr.getDistrict();
            CityModel city = district.getCity();
            sb.append(postcode.getCountry().getVehicleSign()).append(" - ").append(postcode.getName()).append(city.getName()).append(" - ").append(district.getName()).append(", ").append(street.getName()).append(" ").append(parcel2.getHouseNumber()).append(parcel2.getHouseNumberExtension());
            dlm.addElement(sb.toString());
        }
        int d = JOptionPane.showConfirmDialog(this.owner, new JScrollPane(list), "", 0);
        if (d == 0 && (index = list.getSelectedIndex()) >= 0 && (geom = (parcel = (ParcelModel)parcels.get(index)).getGeom()) != null) {
            return geom;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tripel<ImmutablePoint, Boolean, Boolean> doAddressSearch() {
        LogisticQualifiedLocationDto logisticQualifiedLocationDto;
        ImmutablePointDto geom;
        if (StringUtil.isBlank(this.postcode.getText()) && StringUtil.isBlank(this.city.getText())) {
            return new Tripel<Object, Boolean, Boolean>(null, true, false);
        }
        LogisticLocationDto<Long> logisticLocationDto = new LogisticLocationDto<Long>(Long.valueOf(1L), null, null, CountryUtil.searchCountryFuzzy(this.country.getText()), this.postcode.getText(), this.city.getText(), this.district.getText(), this.street.getText(), this.housenumber.getText(), this.housenumberExtension.getText());
        ArrayList<LogisticQualifiedLocationDto> result = new ArrayList<LogisticQualifiedLocationDto>(this.modelEnviroment.getAllCaller().getStreetNetCaller().searchAddress(logisticLocationDto, null, false, this.parcelOnly));
        if (result.size() > 1) {
            LogisticQualifiedLocationDto logisticQualifiedLocationDto2;
            ImmutablePointDto geom2;
            DefaultListModel<String> dlm = new DefaultListModel<String>();
            JList list = new JList(dlm);
            for (LogisticQualifiedLocationDto dto : result) {
                Country country = dto.getCountry();
                String textRepresentation = (country == null ? "" : country.getVehicleSign() + " - ") + StringUtil.nullToEmpty(dto.getPostcode()) + " " + StringUtil.nullToEmpty(dto.getCity()) + " - " + StringUtil.nullToEmpty(dto.getDistrict()) + ", " + StringUtil.nullToEmpty(dto.getStreet()) + " " + StringUtil.nullToEmpty(dto.getHousenumber()) + StringUtil.nullToEmpty(dto.getExtension()) + ", " + dto.getMatching();
                dlm.addElement(textRepresentation);
            }
            int d = JOptionPane.showConfirmDialog(this.owner, new JScrollPane(list), "", 0);
            if (d != 0) return new Tripel<Object, Boolean, Boolean>(null, true, true);
            int index = list.getSelectedIndex();
            if (index < 0 || (geom2 = (logisticQualifiedLocationDto2 = (LogisticQualifiedLocationDto)result.get(index)).getGeom()) == null) return new Tripel<Object, Boolean, Boolean>(null, true, false);
            return new Tripel<ImmutablePoint, Boolean, Boolean>((ImmutablePoint)geom2.getGeoObject(), false, false);
        }
        if (result.isEmpty() || (geom = (logisticQualifiedLocationDto = (LogisticQualifiedLocationDto)result.get(0)).getGeom()) == null) return new Tripel<Object, Boolean, Boolean>(null, true, false);
        return new Tripel<ImmutablePoint, Boolean, Boolean>((ImmutablePoint)geom.getGeoObject(), false, false);
    }

    public void clearCoordinate() {
        this.setCoordinate(null);
        this.navigator.repaint(10L);
    }

    private void setParcelEnabled(boolean b) {
        this.parcelId.setEnabled(b);
    }

    public void setBuddyAction(CommonSearchAction buddyAction) {
        this.buddyAction = buddyAction;
    }

    private void setCoordEnabled(boolean b) {
        this.coordinateX.setEnabled(b);
        this.coordinateY.setEnabled(b);
        this.coordinateFormat.setEnabled(b);
    }

    private void setAddressEnabled(boolean b) {
        this.country.setEnabled(b);
        this.postcode.setEnabled(b);
        this.city.setEnabled(b);
        this.district.setEnabled(b);
        this.street.setEnabled(b);
        this.housenumber.setEnabled(b);
        this.housenumberExtension.setEnabled(b);
    }

    public void setCoordinate(Coordinate coordinate) {
        if (!new EqualsBuilder().append(this.coordinate, coordinate).isEquals()) {
            this.coordinate = coordinate;
            this.navigator.repaint(10L);
            if (this.buddyAction != null) {
                this.buddyAction.setCoordinate(coordinate);
            }
        }
    }

    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    public boolean isParcelOnly() {
        return this.parcelOnly;
    }

    public void setParcelOnly(boolean parcelOnly) {
        this.parcelOnly = parcelOnly;
    }

    private void setEnabledBySelection() {
        if (this.useAddress.isSelected()) {
            this.setAddressEnabled(true);
            this.setCoordEnabled(false);
            this.setParcelEnabled(false);
        } else if (this.useCoord.isSelected()) {
            this.setAddressEnabled(false);
            this.setCoordEnabled(true);
            this.setParcelEnabled(false);
        } else if (this.useParcelId.isSelected()) {
            this.setAddressEnabled(false);
            this.setCoordEnabled(false);
            this.setParcelEnabled(true);
        }
    }

    public void setSortOrder(int sortOrder) {
        this.rendererSortOrder = sortOrder;
    }

    public void setAddress(LocationWrapper wrapper) {
        Country lCountry = wrapper.getCountry();
        String displayName = lCountry == null ? "" : lCountry.getDisplayName(ModelEnviroment.getMessageResolver().getLocaleString());
        this.country.setText(displayName);
        this.postcode.setText(wrapper.getPostcode());
        this.city.setText(wrapper.getCity());
        this.district.setText(wrapper.getDistrict());
        this.street.setText(wrapper.getStreet());
        Integer housenumberValue = wrapper.getHousenumber();
        if (housenumberValue != null) {
            this.housenumber.setText(housenumberValue.toString());
        } else {
            this.housenumber.setText("");
        }
        this.housenumberExtension.setText(wrapper.getHousenumberExtension());
    }

    private class RadioActionListener
    implements ActionListener {
        private RadioActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommonSearchAction.this.setEnabledBySelection();
        }
    }

    private class CommonSearchActionRenderer
    implements NavigatorRenderer {
        private List<NavigatorRendererActiveListener> navigatorPanelActiveListeners = new ArrayList<NavigatorRendererActiveListener>();

        private CommonSearchActionRenderer() {
        }

        @Override
        public void setNavigatorPanel(NavigatorPanel navigatorPanel) {
        }

        @Override
        public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        }

        @Override
        public Collection<OnTopRendering> paintOnto(final Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, final double upp) {
            if (CommonSearchAction.this.coordinate != null) {
                OnTopRendering onTopRendering = new OnTopRendering(){

                    @Override
                    public void paint() {
                        double margin = 8.0 * upp;
                        DefaultPointRenderer tourPointRenderer = new DefaultPointRenderer(g2d, upp, CommonSearchAction.this.navigator.getCoordinateFactory());
                        tourPointRenderer.drawPin(CommonSearchAction.this.coordinate, margin, Color.GREEN);
                    }
                };
                return Collections.singleton(onTopRendering);
            }
            return Collections.emptyList();
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        @Override
        public String getName() {
            return ModelEnviroment.getMessageResolver().resolveMessage("messages.renderer.commonSearchRenderer.name", new Serializable[0]);
        }

        @Override
        public void addNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
            this.navigatorPanelActiveListeners.add(navigatorPanelActiveListener);
        }

        @Override
        public void removeNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
            this.navigatorPanelActiveListeners.remove(navigatorPanelActiveListener);
        }

        @Override
        public void close() {
        }

        @Override
        public int getSortOrder() {
            return CommonSearchAction.this.rendererSortOrder;
        }
    }
}

