/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.action;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.util.LocationObject;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.geo.swing.GeoObjectBucketMouseManipulatorAction;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.util.Collection;
import javax.swing.Icon;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorPanningAction;

public abstract class HoverAndMoveableGeoObjectBucketMouseManipulatorAction<S extends LocationObject<U>, T extends ImmutableGeoObject, U extends Model>
extends GeoObjectBucketMouseManipulatorAction<S, T> {
    private static final long serialVersionUID = -1832272979475470602L;
    private static final long DRAG_SETTING_INTERVAL = 100L;
    private Collection<S> hover;
    private boolean moveable;
    private S movingObject;
    private ImmutablePoint pointBeforeMove;
    private Cursor moveCursor;
    private long lastDragSet = System.currentTimeMillis();
    private ModelEnviroment modelEnviroment;

    public HoverAndMoveableGeoObjectBucketMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, Icon icon, boolean on, GeoObjectBucketsModel<S, T> bucketsModel, ModelEnviroment modelEnviroment, boolean moveable) {
        super(navigatorPanel, maxUpp, icon, on, bucketsModel);
        this.moveable = moveable;
        this.modelEnviroment = modelEnviroment;
    }

    public HoverAndMoveableGeoObjectBucketMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, Icon icon, GeoObjectBucketsModel<S, T> bucketsModel, ModelEnviroment modelEnviroment, boolean moveable) {
        super(navigatorPanel, maxUpp, icon, bucketsModel);
        this.moveable = moveable;
        this.modelEnviroment = modelEnviroment;
    }

    public HoverAndMoveableGeoObjectBucketMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, Icon iconOn, Icon iconOff, boolean on, GeoObjectBucketsModel<S, T> bucketsModel, ModelEnviroment modelEnviroment, boolean moveable) {
        super(navigatorPanel, maxUpp, iconOn, iconOff, on, bucketsModel);
        this.moveable = moveable;
        this.modelEnviroment = modelEnviroment;
    }

    public HoverAndMoveableGeoObjectBucketMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, Icon iconOn, Icon iconOff, GeoObjectBucketsModel<S, T> bucketsModel, ModelEnviroment modelEnviroment, boolean moveable) {
        super(navigatorPanel, maxUpp, iconOn, iconOff, bucketsModel);
        this.moveable = moveable;
        this.modelEnviroment = modelEnviroment;
    }

    public HoverAndMoveableGeoObjectBucketMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, String title, boolean on, GeoObjectBucketsModel<S, T> bucketsModel, ModelEnviroment modelEnviroment, boolean moveable) {
        super(navigatorPanel, maxUpp, title, on, bucketsModel);
        this.moveable = moveable;
        this.modelEnviroment = modelEnviroment;
    }

    public HoverAndMoveableGeoObjectBucketMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, String title, GeoObjectBucketsModel<S, T> bucketsModel, ModelEnviroment modelEnviroment, boolean moveable) {
        super(navigatorPanel, maxUpp, title, bucketsModel);
        this.moveable = moveable;
        this.modelEnviroment = modelEnviroment;
    }

    public HoverAndMoveableGeoObjectBucketMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, String title, Icon icon, boolean on, GeoObjectBucketsModel<S, T> bucketsModel, ModelEnviroment modelEnviroment, boolean moveable) {
        super(navigatorPanel, maxUpp, title, icon, on, bucketsModel);
        this.moveable = moveable;
        this.modelEnviroment = modelEnviroment;
    }

    public HoverAndMoveableGeoObjectBucketMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, String title, Icon icon, GeoObjectBucketsModel<S, T> bucketsModel, ModelEnviroment modelEnviroment, boolean moveable) {
        super(navigatorPanel, maxUpp, title, icon, bucketsModel);
        this.moveable = moveable;
        this.modelEnviroment = modelEnviroment;
    }

    public HoverAndMoveableGeoObjectBucketMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, String titleOn, String titleOff, boolean on, GeoObjectBucketsModel<S, T> bucketsModel, ModelEnviroment modelEnviroment, boolean moveable) {
        super(navigatorPanel, maxUpp, titleOn, titleOff, on, bucketsModel);
        this.moveable = moveable;
        this.modelEnviroment = modelEnviroment;
    }

    public HoverAndMoveableGeoObjectBucketMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, String titleOn, String titleOff, GeoObjectBucketsModel<S, T> bucketsModel, ModelEnviroment modelEnviroment, boolean moveable) {
        super(navigatorPanel, maxUpp, titleOn, titleOff, bucketsModel);
        this.moveable = moveable;
        this.modelEnviroment = modelEnviroment;
    }

    public HoverAndMoveableGeoObjectBucketMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, String titleOn, String titleOff, Icon iconOn, Icon iconOff, boolean on, GeoObjectBucketsModel<S, T> bucketsModel, ModelEnviroment modelEnviroment, boolean moveable) {
        super(navigatorPanel, maxUpp, titleOn, titleOff, iconOn, iconOff, on, bucketsModel);
        this.moveable = moveable;
        this.modelEnviroment = modelEnviroment;
    }

    public HoverAndMoveableGeoObjectBucketMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, String titleOn, String titleOff, Icon iconOn, Icon iconOff, GeoObjectBucketsModel<S, T> bucketsModel, ModelEnviroment modelEnviroment, boolean moveable) {
        super(navigatorPanel, maxUpp, titleOn, titleOff, iconOn, iconOff, bucketsModel);
        this.moveable = moveable;
        this.modelEnviroment = modelEnviroment;
    }

    @Override
    protected void mouseMoved(int x, int y) {
        Collection underMouse = this.findObjects(x, y, this.getMindistForHover(x, y));
        if (!underMouse.isEmpty()) {
            if (!CollectionUtil.isEqualsCollection(this.hover, underMouse)) {
                this.hover = underMouse;
                this.renderHover(null);
                this.renderHover(this.hover);
                this.getNavigatorPanel().setCursor(this.getHoverCursor(this.hover));
                this.getNavigatorPanel().repaint(10L);
            }
        } else if (this.hover != null) {
            this.hover = null;
            this.renderHover(null);
            this.getNavigatorPanel().setCursor(Cursor.getDefaultCursor());
            this.getNavigatorPanel().repaint(10L);
        }
    }

    @Override
    protected void turnedOff() {
        if (this.hover != null) {
            this.hover = null;
            this.renderHover(null);
            this.getNavigatorPanel().setCursor(Cursor.getDefaultCursor());
            this.getNavigatorPanel().repaint(10L);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.hover != null) {
            this.hover = null;
            this.renderHover(null);
            this.getNavigatorPanel().setCursor(Cursor.getDefaultCursor());
            this.getNavigatorPanel().repaint(10L);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        NavigatorPanningAction.performWheelZoom(e, this.getNavigatorPanel());
    }

    protected abstract void renderHover(Collection<S> var1);

    protected abstract double getMindistForHover(int var1, int var2);

    protected abstract Cursor getHoverCursor(Collection<S> var1);

    @Override
    protected void mouseDragFinished(int x, int y, int modifiers) {
        if (this.movingObject != null) {
            Point2D.Double real = this.getNavigatorPanel().getReal(x, y);
            ImmutablePoint newPoint = ImmutableGeoObjectFactory.createImmutablePoint(this.getNavigatorPanel().getCoordinateFactory().createCoordinate(real.getX(), real.getY()));
            this.movingObject.setRealImmutablePoint(newPoint);
            this.getNavigatorPanel().setCursor(Cursor.getDefaultCursor());
            Object model = this.movingObject.getModel();
            this.modelEnviroment.getUndoManager().finishTransaction(this.getMoveTransactionFinishedMessage(model));
        }
        this.movingObject = null;
        this.pointBeforeMove = null;
    }

    protected abstract String getMoveTransactionFinishedMessage(U var1);

    @Override
    protected void mouseDragged(int x, int y) {
        Collection objects;
        if (this.moveable && this.movingObject == null && !(objects = this.findObjects(x, y, this.getMindistForHover(x, y))).isEmpty()) {
            this.modelEnviroment.getUndoManager().startTransaction();
            this.movingObject = (LocationObject)objects.iterator().next();
            this.pointBeforeMove = this.movingObject.getImmutablePoint();
            this.getNavigatorPanel().setCursor(this.moveCursor);
            this.lastDragSet = System.currentTimeMillis();
        }
        if (this.movingObject != null && this.lastDragSet + 100L < System.currentTimeMillis()) {
            Point2D.Double real = this.getNavigatorPanel().getReal(x, y);
            this.movingObject.setRealImmutablePoint(ImmutableGeoObjectFactory.createImmutablePoint(this.getNavigatorPanel().getCoordinateFactory().createCoordinate(real.getX(), real.getY())));
            this.lastDragSet = System.currentTimeMillis();
            this.getNavigatorPanel().repaint(1L);
        }
    }

    @Override
    protected void mousePressed(int x, int y, int modifiers, MouseButton mouseButton) {
    }

    @Override
    protected void turnedOn() {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }
}

