/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.action;

import de.datomino.peppergis.client.action.HoverAndMoveableGeoObjectBucketMouseManipulatorAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.subscription.SubscriptionDialog;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.util.model.subscription.SubscriptionLocationObject;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.swing.SwingUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.KeyStroke;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.util.StringUtil;

public abstract class ChooseSubscriptionOnMapAction
extends HoverAndMoveableGeoObjectBucketMouseManipulatorAction<SubscriptionLocationObject, ImmutablePoint, SubscriptionModel> {
    private static final long serialVersionUID = -7253814435817055710L;
    private ModelEnviroment modelEnviroment;

    public ChooseSubscriptionOnMapAction(NavigatorPanel navigatorPanel, GeoObjectBucketsModel<SubscriptionLocationObject, ImmutablePoint> bucketsModel, ModelEnviroment modelEnviroment, boolean moveable) {
        super(navigatorPanel, (Double)10.0, ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptions", new Serializable[0]), bucketsModel, modelEnviroment, moveable);
        this.modelEnviroment = modelEnviroment;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(123, 0));
    }

    @Override
    protected Cursor getHoverCursor(Collection<SubscriptionLocationObject> s) {
        return Cursor.getDefaultCursor();
    }

    @Override
    protected double getMindistForHover(int x, int y) {
        return 10.0 * this.getNavigatorPanel().getUpp();
    }

    @Override
    protected void mouseClicked(int x, int y, int clickCount, int modifiers, MouseButton mouseButton) {
        Collection objects;
        if (mouseButton == MouseButton.BUTTON1 && clickCount > 1 && !(objects = this.findObjects(x, y, this.getMindistForHover(x, y))).isEmpty()) {
            ArrayList<SubscriptionModel> subscriptions = new ArrayList<SubscriptionModel>(objects.size());
            CollectionUtil.transform(objects, subscriptions, new Transformer<SubscriptionLocationObject, SubscriptionModel>(){

                @Override
                public SubscriptionModel transform(SubscriptionLocationObject object) {
                    return (SubscriptionModel)object.getModel();
                }
            });
            SubscriptionDialog subscriptionDialog = new SubscriptionDialog(SwingUtils.findWindowParent(this.getNavigatorPanel()), subscriptions, this.modelEnviroment);
            subscriptionDialog.setVisible(true);
        }
    }

    protected abstract Component getParent();

    @Override
    protected String getMoveTransactionFinishedMessage(SubscriptionModel model) {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.moved", new Serializable[]{StringUtil.nullToEmpty(model.getSubscriptionNumber())});
    }
}

