/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.action;

import de.datomino.peppergis.client.action.HoverAndMoveableGeoObjectBucketMouseManipulatorAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.poi.PoiDialog;
import de.datomino.peppergis.client.gui.poi.PoiFilterableMarkerRenderer;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.util.model.poi.PoiLocationObject;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.swing.SwingUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.ktde.swing.AbstractToggleAction;
import org.ktde.swing.ToggleAction;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.util.StringUtil;

public abstract class ChoosePoiOnMapAction
extends HoverAndMoveableGeoObjectBucketMouseManipulatorAction<PoiLocationObject, ImmutablePoint, PoiModel> {
    private static final long serialVersionUID = -7253814435817055710L;
    private ModelEnviroment modelEnviroment;
    private PoiFilterableMarkerRenderer poiFilterableMarkerRenderer;
    private AbstractTypeToggleAction mainDelivererLocationAction;
    private AbstractTypeToggleAction branchDelivererLocationAction;
    private AbstractTypeToggleAction delivererDelivererLocationAction;
    private AbstractTypeToggleAction areaDelivererDelivererLocationAction;
    private AbstractTypeToggleAction regularAreaObjectLocationAction;
    private AbstractTypeToggleAction startPickPointAreaObjectLocationAction;
    private AbstractTypeToggleAction endPickPointAreaObjectLocationAction;
    private AbstractTypeToggleAction inactiveAreaObjectLocationAction;
    private AbstractTypeToggleAction customerAction;
    private AbstractTypeToggleAction pickPointAction;

    public ChoosePoiOnMapAction(NavigatorPanel navigatorPanel, GeoObjectBucketsModel<PoiLocationObject, ImmutablePoint> bucketsModel, ModelEnviroment modelEnviroment, boolean moveable, PoiFilterableMarkerRenderer poiFilterableMarkerRenderer) {
        super(navigatorPanel, (Double)2048.0, ModelEnviroment.getMessageResolver().resolveMessage("messages.poi.pois", new Serializable[0]), bucketsModel, modelEnviroment, moveable);
        this.poiFilterableMarkerRenderer = poiFilterableMarkerRenderer;
        this.modelEnviroment = modelEnviroment;
        this.createToggleActions();
    }

    private void createToggleActions() {
        ArrayList<AbstractTypeToggleAction> toggleActions = new ArrayList<AbstractTypeToggleAction>(10);
        this.mainDelivererLocationAction = new AbstractTypeToggleAction(ModelEnviroment.getMessageResolver().resolveMessageForEnum(PoiFilterableMarkerRenderer.RenderPoiType.MAIN_DELIVERER_LOCATION), toggleActions){
            private static final long serialVersionUID = -2613430859169304796L;

            @Override
            protected void setFlag(PoiFilterableMarkerRenderer poiRenderer, boolean b) {
                poiRenderer.setMainDelivererLocationActive(b);
            }
        };
        toggleActions.add(this.mainDelivererLocationAction);
        this.branchDelivererLocationAction = new AbstractTypeToggleAction(ModelEnviroment.getMessageResolver().resolveMessageForEnum(PoiFilterableMarkerRenderer.RenderPoiType.BRANCH_DELIVERER_LOCATION), toggleActions){
            private static final long serialVersionUID = -2613430859169304796L;

            @Override
            protected void setFlag(PoiFilterableMarkerRenderer poiRenderer, boolean b) {
                poiRenderer.setBranchDelivererLocationActive(b);
            }
        };
        toggleActions.add(this.branchDelivererLocationAction);
        this.delivererDelivererLocationAction = new AbstractTypeToggleAction(ModelEnviroment.getMessageResolver().resolveMessageForEnum(PoiFilterableMarkerRenderer.RenderPoiType.DELIVERER_DELIVERER_LOCATION), toggleActions){
            private static final long serialVersionUID = -2613430859169304796L;

            @Override
            protected void setFlag(PoiFilterableMarkerRenderer poiRenderer, boolean b) {
                poiRenderer.setDelivererDelivererLocationActive(b);
            }
        };
        toggleActions.add(this.delivererDelivererLocationAction);
        this.areaDelivererDelivererLocationAction = new AbstractTypeToggleAction(ModelEnviroment.getMessageResolver().resolveMessageForEnum(PoiFilterableMarkerRenderer.RenderPoiType.AREA_DELIVERER_DELIVERER_LOCATION), toggleActions){
            private static final long serialVersionUID = -2613430859169304796L;

            @Override
            protected void setFlag(PoiFilterableMarkerRenderer poiRenderer, boolean b) {
                poiRenderer.setAreaDelivererDelivererLocationActive(b);
            }
        };
        toggleActions.add(this.areaDelivererDelivererLocationAction);
        this.regularAreaObjectLocationAction = new AbstractTypeToggleAction(ModelEnviroment.getMessageResolver().resolveMessageForEnum(PoiFilterableMarkerRenderer.RenderPoiType.REGULAR_AREA_OBJECT_LOCATION), toggleActions){
            private static final long serialVersionUID = -2613430859169304796L;

            @Override
            protected void setFlag(PoiFilterableMarkerRenderer poiRenderer, boolean b) {
                poiRenderer.setRegularAreaObjectLocationActive(b);
            }
        };
        toggleActions.add(this.regularAreaObjectLocationAction);
        this.startPickPointAreaObjectLocationAction = new AbstractTypeToggleAction(ModelEnviroment.getMessageResolver().resolveMessageForEnum(PoiFilterableMarkerRenderer.RenderPoiType.START_PICK_POINT_AREA_OBJECT_LOCATION), toggleActions){
            private static final long serialVersionUID = -2613430859169304796L;

            @Override
            protected void setFlag(PoiFilterableMarkerRenderer poiRenderer, boolean b) {
                poiRenderer.setStartPickPointAreaObjectLocationActive(b);
            }
        };
        toggleActions.add(this.startPickPointAreaObjectLocationAction);
        this.endPickPointAreaObjectLocationAction = new AbstractTypeToggleAction(ModelEnviroment.getMessageResolver().resolveMessageForEnum(PoiFilterableMarkerRenderer.RenderPoiType.END_PICK_POINT_AREA_OBJECT_LOCATION), toggleActions){
            private static final long serialVersionUID = -2613430859169304796L;

            @Override
            protected void setFlag(PoiFilterableMarkerRenderer poiRenderer, boolean b) {
                poiRenderer.setEndPickPointAreaObjectLocationActive(b);
            }
        };
        toggleActions.add(this.endPickPointAreaObjectLocationAction);
        this.inactiveAreaObjectLocationAction = new AbstractTypeToggleAction(ModelEnviroment.getMessageResolver().resolveMessageForEnum(PoiFilterableMarkerRenderer.RenderPoiType.INACTIVE_AREA_OBJECT_LOCATION), toggleActions){
            private static final long serialVersionUID = -2613430859169304796L;

            @Override
            protected void setFlag(PoiFilterableMarkerRenderer poiRenderer, boolean b) {
                poiRenderer.setInactiveAreaObjectLocationActive(b);
            }
        };
        toggleActions.add(this.inactiveAreaObjectLocationAction);
        this.customerAction = new AbstractTypeToggleAction(ModelEnviroment.getMessageResolver().resolveMessageForEnum(PoiFilterableMarkerRenderer.RenderPoiType.CUSTOMER), toggleActions){
            private static final long serialVersionUID = -2613430859169304796L;

            @Override
            protected void setFlag(PoiFilterableMarkerRenderer poiRenderer, boolean b) {
                poiRenderer.setCustomerActive(b);
            }
        };
        toggleActions.add(this.customerAction);
        this.pickPointAction = new AbstractTypeToggleAction(ModelEnviroment.getMessageResolver().resolveMessageForEnum(PoiFilterableMarkerRenderer.RenderPoiType.PICK_POINT), toggleActions){
            private static final long serialVersionUID = -2613430859169304796L;

            @Override
            protected void setFlag(PoiFilterableMarkerRenderer poiRenderer, boolean b) {
                poiRenderer.setPickPointActive(b);
            }
        };
        toggleActions.add(this.pickPointAction);
    }

    @Override
    protected Cursor getHoverCursor(Collection<PoiLocationObject> s) {
        return Cursor.getDefaultCursor();
    }

    @Override
    protected double getMindistForHover(int x, int y) {
        return 10.0 * this.getNavigatorPanel().getUpp();
    }

    @Override
    protected Collection<PoiLocationObject> findObjects(int x, int y, double minDist) {
        Collection poiLocations = super.findObjects(x, y, minDist);
        ArrayList<PoiLocationObject> filtered = new ArrayList<PoiLocationObject>(poiLocations.size());
        for (PoiLocationObject poiLocationObject : poiLocations) {
            if (!this.poiFilterableMarkerRenderer.isPoiLocationActive(poiLocationObject)) continue;
            filtered.add(poiLocationObject);
        }
        return filtered;
    }

    @Override
    protected void mouseClicked(int x, int y, int clickCount, int modifiers, MouseButton mouseButton) {
        Collection<PoiLocationObject> objects;
        if (mouseButton == MouseButton.BUTTON1 && clickCount > 1 && !(objects = this.findObjects(x, y, this.getMindistForHover(x, y))).isEmpty()) {
            ArrayList<PoiModel> pois = new ArrayList<PoiModel>(objects.size());
            CollectionUtil.transform(objects, pois, new Transformer<PoiLocationObject, PoiModel>(){

                @Override
                public PoiModel transform(PoiLocationObject object) {
                    return (PoiModel)object.getModel();
                }
            });
            PoiDialog poiDialog = new PoiDialog(SwingUtils.findWindowParent(this.getNavigatorPanel()), pois, this.modelEnviroment);
            poiDialog.setVisible(true);
        }
    }

    protected abstract Component getParent();

    @Override
    protected void turnedOn() {
        super.turnedOn();
        NavigatorPanel navigatorPanel = this.getNavigatorPanel();
        navigatorPanel.removeMouseWheelListener(navigatorPanel.getPanningAction());
        navigatorPanel.repaint();
    }

    @Override
    protected void turnedOff() {
        super.turnedOff();
        NavigatorPanel navigatorPanel = this.getNavigatorPanel();
        navigatorPanel.addMouseWheelListener(navigatorPanel.getPanningAction());
        this.getNavigatorPanel().repaint();
    }

    @Override
    protected String getMoveTransactionFinishedMessage(PoiModel model) {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.poi.moved", new Serializable[]{StringUtil.nullToEmpty(model.getPoiNumber()) + " - " + StringUtil.nullToEmpty(model.getName())});
    }

    public ToggleAction getMainDelivererLocationAction() {
        return this.mainDelivererLocationAction;
    }

    public ToggleAction getBranchDelivererLocationAction() {
        return this.branchDelivererLocationAction;
    }

    public ToggleAction getDelivererDelivererLocationAction() {
        return this.delivererDelivererLocationAction;
    }

    public ToggleAction getAreaDelivererDelivererLocationAction() {
        return this.areaDelivererDelivererLocationAction;
    }

    public ToggleAction getRegularAreaObjectLocationAction() {
        return this.regularAreaObjectLocationAction;
    }

    public ToggleAction getStartPickPointAreaObjectLocationAction() {
        return this.startPickPointAreaObjectLocationAction;
    }

    public ToggleAction getEndPickPointAreaObjectLocationAction() {
        return this.endPickPointAreaObjectLocationAction;
    }

    public ToggleAction getInactiveAreaObjectLocationAction() {
        return this.inactiveAreaObjectLocationAction;
    }

    public ToggleAction getCustomerAction() {
        return this.customerAction;
    }

    public ToggleAction getPickPointAction() {
        return this.pickPointAction;
    }

    private abstract class AbstractTypeToggleAction
    extends AbstractToggleAction {
        private static final long serialVersionUID = -4223138045332583415L;
        private Collection<AbstractTypeToggleAction> others;

        public AbstractTypeToggleAction(String title, Collection<AbstractTypeToggleAction> others) {
            super(title);
            this.others = others;
        }

        @Override
        public void turnOn() {
            if (!this.isAlreadyActive()) {
                ChoosePoiOnMapAction.this.poiFilterableMarkerRenderer.setActive(true);
                ChoosePoiOnMapAction.this.turnOn();
            }
            this.setFlag(ChoosePoiOnMapAction.this.poiFilterableMarkerRenderer, true);
        }

        protected abstract void setFlag(PoiFilterableMarkerRenderer var1, boolean var2);

        @Override
        public void turnOff() {
            if (!this.isAlreadyActive()) {
                ChoosePoiOnMapAction.this.poiFilterableMarkerRenderer.setActive(false);
                ChoosePoiOnMapAction.this.turnOff();
            }
            this.setFlag(ChoosePoiOnMapAction.this.poiFilterableMarkerRenderer, false);
        }

        private boolean isAlreadyActive() {
            for (AbstractTypeToggleAction action : this.others) {
                if (action == this || !action.isSelected()) continue;
                return true;
            }
            return false;
        }
    }
}

