/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.action;

import de.datomino.peppergis.client.gui.area.AreaObjectDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.area.AreaLayerRenderer;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.swing.ObjectSelectionHandler;
import de.datomino.util.geo.swing.ObjectSelectorNavigatorRenderer;
import de.datomino.util.swing.SwingUtils;
import java.awt.Component;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.KeyStroke;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.swing.navigator.NavigatorPanel;

public class ChooseAreaObjectOnMapAction
extends ObjectSelectorNavigatorRenderer<AreaObjectModel, ImmutablePolygonKind> {
    private static final long serialVersionUID = 5948742144895185731L;
    private AreaLayerRenderer areaLayerRenderer;
    private Component parent;
    private ModelEnviroment modelEnviroment;
    private Point2D.Double startPoint;
    private boolean areaDialogEnabled = true;

    public ChooseAreaObjectOnMapAction(Component parent, NavigatorPanel navigatorPanel, AreaLayerRenderer areaLayerRenderer, ObjectSelectionHandler<AreaObjectModel> baseLayerEditorPanel, ModelEnviroment modelEnviroment, String actionMessageKey) {
        super(navigatorPanel, (Double)areaLayerRenderer.getMaxUpp(), ModelEnviroment.getMessageResolver().resolveMessage(actionMessageKey, new Serializable[0]), areaLayerRenderer.getBucketsModel(), baseLayerEditorPanel);
        this.parent = parent;
        this.areaLayerRenderer = areaLayerRenderer;
        this.modelEnviroment = modelEnviroment;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(118, 0));
    }

    public AreaLayerRenderer getAreaLayerRenderer() {
        return this.areaLayerRenderer;
    }

    @Override
    protected void mouseClicked(Collection<AreaObjectModel> marked, int clickCount, int modifiers) {
        if (!this.isSelected() || !this.areaLayerRenderer.isActive()) {
            return;
        }
        if (clickCount == 1) {
            super.doSelect(marked, modifiers);
        } else if (this.areaDialogEnabled && clickCount == 2 && !marked.isEmpty()) {
            AreaObjectDialog areaObjectDialog = new AreaObjectDialog(SwingUtils.findWindowParent(this.parent), marked.iterator().next(), this.modelEnviroment);
            areaObjectDialog.setVisible(true);
        } else {
            super.mouseClicked(marked, clickCount, modifiers);
        }
    }

    @Override
    protected void mouseDragFinished(int x, int y, int modifieres) {
        if (this.startPoint == null) {
            return;
        }
        Point2D.Double currentPoint = super.getNavigatorPanel().getReal(x, y);
        CoordinateFactory factory = super.getNavigatorPanel().getCoordinateFactory();
        double minX = Math.min(this.startPoint.x, currentPoint.x);
        double minY = Math.min(this.startPoint.y, currentPoint.y);
        double maxX = Math.max(this.startPoint.x, currentPoint.x);
        double maxY = Math.max(this.startPoint.y, currentPoint.y);
        Coordinate bottomLeftCoordinate = factory.createCoordinate(minX, minY);
        Coordinate topRightCoordinate = factory.createCoordinate(maxX, maxY);
        ImmutablePoint bottomLeft = ImmutableGeoObjectFactory.createImmutablePoint(bottomLeftCoordinate);
        ImmutablePoint topRight = ImmutableGeoObjectFactory.createImmutablePoint(topRightCoordinate);
        Collection objects = this.getBucketsModel().findObjects(bottomLeft, topRight);
        super.doSelect(this.getFilteredObjects(objects), modifieres);
        this.startPoint = null;
        this.areaLayerRenderer.setSelectedRectangle(null);
        this.parent.repaint();
    }

    @Override
    protected void mouseDragged(int x, int y) {
        if (this.startPoint == null) {
            return;
        }
        Point2D.Double currentPoint = super.getNavigatorPanel().getReal(x, y);
        Rectangle2D.Double rectangle = new Rectangle2D.Double();
        rectangle.x = Math.min(this.startPoint.x, currentPoint.x);
        rectangle.y = Math.min(this.startPoint.y, currentPoint.y);
        rectangle.width = Math.abs(currentPoint.x - this.startPoint.x);
        rectangle.height = Math.abs(currentPoint.y - this.startPoint.y);
        this.areaLayerRenderer.setSelectedRectangle(rectangle);
        this.parent.repaint();
    }

    @Override
    protected void mousePressed(int x, int y, int modifiers, MouseButton mouseButton) {
        if (!this.isSelected() || !this.areaLayerRenderer.isActive()) {
            this.startPoint = null;
            return;
        }
        this.startPoint = this.getNavigatorPanel().getReal(x, y);
    }

    public void setAreaLayerRenderer(AreaLayerRenderer areaLayerRenderer) {
        if (this.areaLayerRenderer != areaLayerRenderer) {
            this.areaLayerRenderer = areaLayerRenderer;
            super.setBucketsModel(areaLayerRenderer.getBucketsModel());
        }
    }

    public void setAreaDialogEnabled(boolean areaDialogEnabled) {
        this.areaDialogEnabled = areaDialogEnabled;
    }
}

