/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.action;

import de.datomino.peppergis.client.communication.AreaCaller;
import de.datomino.peppergis.client.gui.area.AreaLayerCellRenderer;
import de.datomino.peppergis.client.gui.common.FilteredListSelectorPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import de.datomino.util.swing.blocking.BusyDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

public abstract class AbstractAreaAction
extends AbstractAction {
    private static final long serialVersionUID = -4793724861249646414L;
    protected ModelEnviroment modelEnviroment;
    protected JDialog dialog;
    protected Window parent;
    private String titel;
    private FilteredListSelectorPane<AreaObjectModel> areaSelectorPane;
    private DefaultComboBoxModel areaLayerComboBoxModel;
    private boolean startBusyDialog;
    private AreaLayerModel areaLayer;

    public AbstractAreaAction(String titel, Window parent, boolean startBusyDialog) {
        this(titel, parent, startBusyDialog, null, new ModelEnviroment(parent));
    }

    public AbstractAreaAction(String titel, Window parent, boolean startBusyDialog, AreaLayerModel areaLayer, ModelEnviroment modelEnviroment) {
        super(titel);
        this.modelEnviroment = modelEnviroment;
        this.parent = parent;
        this.titel = titel;
        this.startBusyDialog = startBusyDialog;
        this.areaLayer = areaLayer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.dialog = new JDialog(this.getParent());
        try {
            this.dialog.setIconImage(ImageIO.read(AbstractAreaAction.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.createPanel();
        this.dialog.setTitle(this.titel);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.pack();
        SwingUtils.centerDialog(this.dialog, this.getParent());
        this.dialog.setVisible(true);
    }

    protected abstract void process(Collection<AreaObjectModel> var1, BusyDialog var2);

    protected abstract String getWarn(int var1);

    protected abstract String getResult();

    protected JComponent createOptionPane() {
        return null;
    }

    private void createPanel() {
        JPanel mainPane = new JPanel(new BorderLayout());
        JPanel inputPanel = new JPanel(new SpringLayout());
        JLabel areaLayerLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.layer", new Serializable[0]) + ":");
        inputPanel.add(areaLayerLabel);
        this.areaLayerComboBoxModel = this.createAreaLayerComboBoxModel();
        JComboBox areaLayerComboBox = new JComboBox(this.areaLayerComboBoxModel);
        areaLayerComboBox.setRenderer(new AreaLayerCellRenderer());
        areaLayerComboBox.setSelectedItem(null);
        inputPanel.add(areaLayerComboBox);
        JLabel areaObjectLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.area", new Serializable[0]) + ":");
        inputPanel.add(areaObjectLabel);
        this.areaSelectorPane = new FilteredListSelectorPane<AreaObjectModel>(2){
            private static final long serialVersionUID = 7592229468334022543L;

            @Override
            protected String getString(AreaObjectModel t) {
                return AreaObjectModelUtil.getShortcutAndDisplayname(t);
            }
        };
        inputPanel.add(this.areaSelectorPane);
        int rows = 2;
        JComponent optionPane = this.createOptionPane();
        if (optionPane != null) {
            inputPanel.add(new JLabel());
            inputPanel.add(optionPane);
            rows = 3;
        }
        SpringUtilities.makeCompactGrid(inputPanel, rows, 2, 5, 5, 5, 5);
        mainPane.add((Component)inputPanel, "Center");
        areaLayerComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item = e.getItem();
                if (e.getStateChange() == 1 && item != null) {
                    AreaCaller areaCaller = AbstractAreaAction.this.modelEnviroment.getAllCaller().getAreaCaller();
                    AbstractAreaAction.this.areaSelectorPane.setValues(areaCaller.fetchAreaObjectsByAreaLayer((AreaLayerModel)item, false));
                }
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JButton doButton = new JButton(this.getDoAction());
        doButton.setSelected(true);
        buttonPanel.add(doButton);
        JButton cancelButton = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = -6589168646513826811L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractAreaAction.this.dialog.dispose();
            }
        });
        buttonPanel.add(cancelButton);
        mainPane.add((Component)buttonPanel, "South");
        this.dialog.getContentPane().add(mainPane);
        if (this.areaLayer != null) {
            areaLayerComboBox.setSelectedItem(this.areaLayer);
            areaLayerComboBox.setEnabled(false);
        }
    }

    private Action getDoAction() {
        AbstractAction action = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.run", new Serializable[0])){
            private static final long serialVersionUID = 6194386089518517276L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BufferedImage image;
                TreeSet<AreaObjectModel> areas;
                block10: {
                    Collection<AreaObjectModel> selectAreas;
                    block9: {
                        if (AbstractAreaAction.this.getSelectAreaLayer() == null) {
                            return;
                        }
                        AreaLayerModel areaLayer = AbstractAreaAction.this.getSelectAreaLayer();
                        areas = new TreeSet<AreaObjectModel>(new Comparator<AreaObjectModel>(){

                            @Override
                            public int compare(AreaObjectModel o1, AreaObjectModel o2) {
                                return o1.getShortcut().compareTo(o2.getShortcut()) * -1;
                            }
                        });
                        selectAreas = AbstractAreaAction.this.getSelectArea();
                        if (!AbstractAreaAction.this.checkSelection(selectAreas)) {
                            return;
                        }
                        if (!selectAreas.isEmpty()) break block9;
                        int d = JOptionPane.showConfirmDialog(AbstractAreaAction.this.dialog, AbstractAreaAction.this.getWarn(areaLayer.countAreaObjects()));
                        switch (d) {
                            case 0: {
                                Iterator<AreaObjectModel> as = areaLayer.iterateAreaObjects();
                                while (as.hasNext()) {
                                    areas.add(as.next());
                                }
                                break block10;
                            }
                            default: {
                                return;
                            }
                        }
                    }
                    areas.addAll(selectAreas);
                }
                try {
                    image = ImageIO.read(AbstractAreaAction.class.getResourceAsStream("/images/pepper.png"));
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                final BusyDialog busyDialog = new BusyDialog((Window)AbstractAreaAction.this.dialog, "", image);
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        AbstractAreaAction.this.process(areas, busyDialog);
                        if (AbstractAreaAction.this.startBusyDialog) {
                            JOptionPane.showMessageDialog(AbstractAreaAction.this.dialog, AbstractAreaAction.this.getResult());
                        }
                        busyDialog.disposeManually();
                    }
                };
                t.start();
                if (AbstractAreaAction.this.startBusyDialog) {
                    busyDialog.setVisible(true);
                }
            }
        };
        return action;
    }

    protected boolean checkSelection(Collection<AreaObjectModel> areas) {
        return true;
    }

    private DefaultComboBoxModel createAreaLayerComboBoxModel() {
        AreaCaller areaCaller = this.modelEnviroment.getAllCaller().getAreaCaller();
        Collection<AreaLayerModel> areaLayers = areaCaller.getAreaLayersForType(AreaObjectGenInfoDiscriminator.values());
        AreaLayerModel[] allAreaLayers = new AreaLayerModel[areaLayers.size()];
        return new DefaultComboBoxModel<AreaLayerModel>(areaLayers.toArray(allAreaLayers));
    }

    protected AreaLayerModel getSelectAreaLayer() {
        return (AreaLayerModel)this.areaLayerComboBoxModel.getSelectedItem();
    }

    protected Collection<AreaObjectModel> getSelectArea() {
        return this.areaSelectorPane.getSelectedValues(true);
    }

    protected Window getParent() {
        return this.parent;
    }
}

