/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.printer;

import de.datomino.pdf.engine.Format;
import de.datomino.pdf.printer.PrinterInformation;
import de.datomino.pdf.printer.PrintingObject;
import de.datomino.peppergis.areamanager.gui.legend.schedule.AreaTourScheduleNode;
import de.datomino.peppergis.areamanager.util.AreaScheduleEntity;
import de.datomino.peppergis.areamanager.util.AreaTourScheduleModelUtil;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.legend.LegendObject;
import de.datomino.peppergis.client.model.tour.AreaTourScheduleModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaStopModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.client.print.DefaultPrintingInformation;
import de.datomino.peppergis.client.print.HeaderType;
import de.datomino.peppergis.client.util.wage.HistoryAreaTourModelWageResult;
import de.datomino.peppergis.print.ScheduleInfoPrintType;
import de.datomino.peppergis.type.areatourtype.AreaTourType;
import de.datomino.util.NumericUtil;
import de.datomino.util.collection.CollectionUtil;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public class SchedulePrintingInformation
extends DefaultPrintingInformation<AreaTourScheduleNode> {
    public SchedulePrintingInformation(AreaTourScheduleNode schedule, Format imageFormat, ModelEnviroment modelEnviroment) {
        this((List<AreaTourScheduleNode>)CollectionUtil.buildArrayList(schedule), (String)null, imageFormat, modelEnviroment);
    }

    public SchedulePrintingInformation(List<AreaTourScheduleNode> schedules, String imagePath, Format imageFormat, ModelEnviroment modelEnviroment) {
        super(schedules, imagePath, imageFormat, modelEnviroment);
    }

    public void initialize(PrinterInformation printerInformation) {
        for (AreaTourScheduleNode schedule : super.getOs()) {
            AreaScheduleEntity entity = schedule.getEntity();
            for (Tupel<AreaTourScheduleModel, HistoryAreaTourModelWageResult> tupel : entity.getAllElements().values()) {
                PrintingObject printingObject = new PrintingObject(null, null);
                String info = AreaTourScheduleModelUtil.getPrintingInformation(tupel.getElement1(), tupel.getElement2(), printerInformation.getNameRenderingType());
                List<String> lines = this.extractLines(printerInformation.getSpecialMessage());
                if (lines != null) {
                    info = info + "\n" + ModelEnviroment.getMessageResolver().resolveMessage("gui.print.message.special", new Serializable[0]) + "\n";
                    for (String line : lines) {
                        info = info + line + "\n";
                    }
                    info = info + "\n";
                }
                HeaderType headerType = this.getHeaderType(tupel.getElement2().getModel());
                List<Tripel<Integer, String, Color>> header = super.getPrintingTableHeader(headerType, printerInformation.getLineGroupType());
                List<Tripel<List<String>, List<String>, Color>> table = this.createTable(tupel.getElement2(), header, printerInformation, headerType);
                ScheduleInfoPrintType tourInfoPrintType = (ScheduleInfoPrintType)printerInformation.getNamePrintType();
                switch (tourInfoPrintType) {
                    case TOP: {
                        this.setTop(true);
                        printingObject.setText(info);
                        printingObject.setHeader(header);
                        printingObject.setTable(table);
                        break;
                    }
                    case DOWN: {
                        this.setDown(true);
                        printingObject.setText(info);
                        printingObject.setHeader(header);
                        printingObject.setTable(table);
                        break;
                    }
                    case NONE: {
                        printingObject.setHeader(null);
                        printingObject.setTable(null);
                        break;
                    }
                    case NO_LIST: {
                        this.setTop(true);
                        printingObject.setText(info);
                        printingObject.setHeader(null);
                        printingObject.setTable(null);
                        break;
                    }
                    case ONLY_LIST: {
                        printingObject.setHeader(header);
                        printingObject.setTable(table);
                    }
                }
                this.printingObjects.add(printingObject);
            }
        }
    }

    private HeaderType getHeaderType(HistoryAreaTourModel historyAreaTour) {
        HeaderType headerType = HeaderType.PARCEL;
        try {
            AreaTourType type = historyAreaTour.getParameter().getAreaTourType();
            switch (type.getAreaObjectType()) {
                case LETTER: {
                    headerType = HeaderType.LETTER;
                    break;
                }
                case PARCEL: {
                    headerType = HeaderType.PARCEL;
                    break;
                }
                case PARCEL_WITH_LETTER: {
                    headerType = HeaderType.MIXED;
                    break;
                }
                case PARCEL_WITHOUT_SUBSCRIPTION: {
                    headerType = HeaderType.PARCEL;
                    break;
                }
                case PARCEL_WITHOUT_SUBSCRIPTION_WITH_LETTER: {
                    headerType = HeaderType.MIXED;
                    break;
                }
                case SUBSCRIPTION: {
                    headerType = HeaderType.SUBSCRIPTION;
                    break;
                }
                case SUBSCRIPTION_WITH_LETTER: {
                    headerType = HeaderType.MIXED;
                    break;
                }
                case PARCEL_SUBSCRIPTION: 
                case PARCEL_SUBSCRIPTION_LETTER: {
                    headerType = HeaderType.MIXED;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return headerType;
    }

    private List<Tripel<List<String>, List<String>, Color>> createTable(HistoryAreaTourModelWageResult historyResult, List<Tripel<Integer, String, Color>> header, PrinterInformation printerInformation, HeaderType headerType) {
        DefaultPrintingInformation.LineGroupIndex streetGroupIndex = super.getLineGroupIndex(header, printerInformation, headerType);
        ArrayList<Tripel<List<String>, List<String>, Color>> table = new ArrayList<Tripel<List<String>, List<String>, Color>>();
        if (historyResult == null) {
            return table;
        }
        HistoryAreaTourModel historyModel = historyResult.getModel();
        int startPoiCount = NumericUtil.getIntegerValue(historyModel.getLengthFromPoi()) == 0 ? 0 : 1;
        startPoiCount += NumericUtil.getIntegerValue(historyModel.getLengthFromPickPoint()) == 0 ? 0 : 1;
        int endPoiCount = NumericUtil.getIntegerValue(historyModel.getLengthToPoi()) == 0 ? 0 : 1;
        endPoiCount += NumericUtil.getIntegerValue(historyModel.getLengthToPickPoint()) == 0 ? 0 : 1;
        int objectIndex = 0;
        Iterator<HistoryAreaStopModel> stopIter = historyModel.iterateHistoryAreaTourStop();
        while (stopIter.hasNext()) {
            HistoryAreaStopModel stop = stopIter.next();
            if (stop == null) continue;
            LegendObject<HistoryAreaStopModel> legendObject = new LegendObject<HistoryAreaStopModel>(stop, objectIndex);
            Tripel<List<String>, List<String>, Color> row = super.getRow(legendObject, printerInformation.getLineGroupType(), headerType == HeaderType.MIXED);
            boolean poi = objectIndex <= startPoiCount || objectIndex - 2 >= historyModel.countHistoryAreaTourStop() - endPoiCount;
            objectIndex = super.addRow(table, row, objectIndex, poi, printerInformation.getLineGroupType(), streetGroupIndex, headerType);
            super.checkRow(header, row);
        }
        return table;
    }
}

