/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.printer;

import de.datomino.peppergis.areamanager.gui.AreaManagerMapGui;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.util.swing.SpringUtilities;
import java.io.Serializable;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SpringLayout;

public class AreaManagerPrintWaySelectionPane
extends JPanel {
    private static final long serialVersionUID = -7790654051519984180L;
    private JRadioButton screenshot;
    private JRadioButton filterOnMap;
    private JRadioButton tourOnMap;
    private JRadioButton calendarSelection;
    private JRadioButton areaDelivererWeek;

    public AreaManagerPrintWaySelectionPane() {
        super(new SpringLayout());
        this.buildLayout();
    }

    private void buildLayout() {
        ButtonGroup buttonGroup = new ButtonGroup();
        this.screenshot = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.screenshot", new Serializable[0]));
        this.add(this.screenshot);
        buttonGroup.add(this.screenshot);
        this.filterOnMap = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.message.filterOnMap", new Serializable[0]));
        buttonGroup.add(this.filterOnMap);
        this.tourOnMap = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.message.tourOnMap", new Serializable[0]));
        this.add(this.tourOnMap);
        buttonGroup.add(this.tourOnMap);
        this.calendarSelection = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.message.tourInSchedule", new Serializable[0]));
        this.add(this.calendarSelection);
        buttonGroup.add(this.calendarSelection);
        this.areaDelivererWeek = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.print.areaDelivererWeek", new Serializable[0]));
        this.add(this.areaDelivererWeek);
        buttonGroup.add(this.areaDelivererWeek);
        this.screenshot.setSelected(true);
        SpringUtilities.makeCompactGrid(this, 4, 1, 5, 5, 5, 5);
    }

    public AreaManagerPrintWay getSelectedPrintWay() {
        if (this.screenshot.isSelected()) {
            return AreaManagerPrintWay.SCREENSHOT;
        }
        if (this.filterOnMap.isSelected()) {
            return AreaManagerPrintWay.FILTER_ON_MAP;
        }
        if (this.tourOnMap.isSelected()) {
            return AreaManagerPrintWay.TOUR_ON_MAP;
        }
        if (this.calendarSelection.isSelected()) {
            return AreaManagerPrintWay.CALENDAR_SELECTION;
        }
        if (this.areaDelivererWeek.isSelected()) {
            return AreaManagerPrintWay.AREA_DELIVERER_WEEK;
        }
        return null;
    }

    public void setEnablings(AreaManagerMapGui areaManagerMapGui, boolean hasFilterToPrint) {
        this.filterOnMap.setEnabled(hasFilterToPrint);
        this.tourOnMap.setEnabled(!areaManagerMapGui.getLogisticTourNodes().isEmpty());
        this.calendarSelection.setEnabled(!areaManagerMapGui.getHistoryTourNodes().isEmpty());
        if (this.tourOnMap.isSelected() && !this.tourOnMap.isEnabled()) {
            this.screenshot.setSelected(true);
        }
        if (this.calendarSelection.isSelected() && !this.calendarSelection.isEnabled()) {
            this.screenshot.setSelected(true);
        }
    }

    public static enum AreaManagerPrintWay {
        SCREENSHOT,
        FILTER_ON_MAP,
        TOUR_ON_MAP,
        CALENDAR_SELECTION,
        AREA_DELIVERER_WEEK;

    }
}

