/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.gui.sortOrder;

import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.areamanager.gui.legend.AreaObjectLogisticTourMapNode;
import de.datomino.peppergis.areamanager.gui.legend.AreaStopNode;
import de.datomino.peppergis.client.gui.common.AbstractCommonDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.AbstractTableRenderer;
import de.datomino.peppergis.client.gui.renderer.MultiLineHeaderRenderer;
import de.datomino.peppergis.client.manager.legend.LegendObject;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.peppergis.client.util.LetterModelUtil;
import de.datomino.peppergis.client.util.ParcelModelUtil;
import de.datomino.peppergis.client.util.SubscriptionModelUtil;
import de.datomino.peppergis.dto.tour.DeliveryRoundProxyDto;
import de.datomino.peppergis.tour.AreaTourParameter;
import de.datomino.peppergis.type.ParcelSortOrderType;
import de.datomino.peppergis.type.areatourtype.AreaObjectType;
import de.datomino.util.swing.TableHeaderWithComponentLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.apache.commons.lang.BooleanUtils;
import org.ktde.model.ValueChangeListener;

public class SavingSortOrderDialog
extends AbstractCommonDialog {
    private static final long serialVersionUID = 8380189983128946075L;
    private static final int TABLE_COLUMN_SIZE = 5;
    private static final int COLUMN_ROUND = 1;
    private static final int FOR_MANUAL = 3;
    private static final int FOR_OPTIMAL = 4;
    private List<AreaObjectLogisticTourMapNode> tourNodes;
    private DefaultTableModel tableModel;

    public SavingSortOrderDialog(List<AreaObjectLogisticTourMapNode> tourNodes, ModelEnviroment modelEnviroment, Component parent) {
        super(modelEnviroment, parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.save", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.tourNodes = tourNodes;
    }

    @Override
    protected Component getMainComponent() {
        this.tableModel = new DefaultTableModel(this.createTableData(), this.createColumnHeader()){
            private static final long serialVersionUID = -596018717845729246L;

            @Override
            public boolean isCellEditable(int row, int column) {
                switch (column) {
                    case 3: 
                    case 4: {
                        return SavingSortOrderDialog.this.tableModel.getValueAt(row, column) != null;
                    }
                }
                return false;
            }
        };
        JTable table = new JTable(this.tableModel){
            private static final long serialVersionUID = -3714464246600955806L;

            @Override
            public Class<?> getColumnClass(int column) {
                switch (column) {
                    case 3: 
                    case 4: {
                        return Boolean.class;
                    }
                }
                return super.getColumnClass(column);
            }
        };
        this.setTableStyle(table);
        return new JScrollPane(table);
    }

    @Override
    protected boolean close() {
        for (int row = 0; row < this.tableModel.getRowCount(); ++row) {
            AreaObjectLogisticTourMapNode tourNode = (AreaObjectLogisticTourMapNode)this.tableModel.getValueAt(row, 0);
            DeliveryRoundModel round = (DeliveryRoundModel)this.tableModel.getValueAt(row, 1);
            Boolean forManual = (Boolean)this.tableModel.getValueAt(row, 3);
            Boolean forOptimal = (Boolean)this.tableModel.getValueAt(row, 4);
            this.saveSortOrder(tourNode, BooleanUtils.isTrue(forManual), BooleanUtils.isTrue(forOptimal), round);
        }
        return true;
    }

    private void saveSortOrder(AreaObjectLogisticTourMapNode tourNode, boolean forManual, boolean forOptimal, DeliveryRoundModel round) {
        List<AreaStopNode<?>> allStopNodes = tourNode.getAllStopNodes();
        AreaObjectModel area = tourNode.getAreaObject();
        AreaTourParameter parameter = tourNode.getParameter();
        int sortOrder = 0;
        for (AreaStopNode<?> stopNode : allStopNodes) {
            Model m = (Model)((LegendObject)stopNode.getAreaStop()).getM();
            if (m instanceof ParcelModel) {
                if (forManual) {
                    ParcelModelUtil.setSortOrder((ParcelModel)m, area, sortOrder, parameter.getRouteVehicleTypeInArea(), round, ParcelSortOrderType.MANUAL);
                }
                if (forOptimal) {
                    ParcelModelUtil.setSortOrder((ParcelModel)m, area, sortOrder, parameter.getRouteVehicleTypeInArea(), round, ParcelSortOrderType.OPTIMAL_ALL);
                }
            } else if (m instanceof SubscriptionModel) {
                SubscriptionModelUtil.setSortOrder((SubscriptionModel)m, sortOrder, parameter.getRouteVehicleTypeInArea(), round);
            } else if (m instanceof LetterModel) {
                LetterModelUtil.setSortOrder((LetterModel)m, sortOrder, parameter.getRouteVehicleTypeInArea(), round);
            }
            ++sortOrder;
        }
    }

    private Object[][] createTableData() {
        Object[][] data = new Object[this.tourNodes.size()][5];
        int row = 0;
        for (AreaObjectLogisticTourMapNode node : this.tourNodes) {
            data[row++] = this.createRow(node);
        }
        return data;
    }

    private Object[] createRow(AreaObjectLogisticTourMapNode tourNode) {
        Object[] row = new Object[5];
        row[0] = tourNode;
        AreaTourParameter parameter = tourNode.getParameter();
        DeliveryRoundProxyDto roundDto = new DeliveryRoundProxyDto(parameter.getDeliveryRoundId(), null);
        row[1] = this.modelEnviroment.getAllCaller().convertDtoToModel(roundDto, new ValueChangeListener[0]);
        row[2] = ModelEnviroment.getMessageResolver().resolveMessageForEnum(parameter.getRouteVehicleTypeInArea());
        row[3] = false;
        row[4] = this.checkForOptimal(tourNode);
        return row;
    }

    private Boolean checkForOptimal(AreaObjectLogisticTourMapNode tourNode) {
        AreaStopNode<?> stopNode;
        Model m;
        AreaObjectType objectType = tourNode.getParameter().getAreaTourType().getAreaObjectType();
        if (!objectType.isForParcel()) {
            return null;
        }
        HashSet<ParcelModel> allParcels = new HashSet<ParcelModel>();
        AreaObjectModel area = tourNode.getAreaObject();
        for (AreaObjectParcelRelModel rel : area.iterableAreaObjectParcelRel()) {
            if (rel.getAreaObject() == null || !rel.getAreaObject().equals(area)) continue;
            allParcels.add(rel.getParcel());
        }
        allParcels.remove(null);
        List<AreaStopNode<?>> allStopNodes = tourNode.getAllStopNodes();
        if (allParcels.size() != allStopNodes.size()) {
            return null;
        }
        Iterator<AreaStopNode<?>> iterator = allStopNodes.iterator();
        while (iterator.hasNext() && (m = (Model)((LegendObject)(stopNode = iterator.next()).getAreaStop()).getM()) instanceof ParcelModel) {
            allParcels.remove(m);
        }
        if (allParcels.isEmpty()) {
            return false;
        }
        return null;
    }

    private String[] createColumnHeader() {
        String[] columnHeader = new String[]{ModelEnviroment.getMessageResolver().resolveMessage("messages.area.area1", new Serializable[0]) + "\n \n \n", ModelEnviroment.getMessageResolver().resolveMessage("gui.deliveryRound", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessageForEnum(RouteVehicleType.class), ModelEnviroment.getMessageResolver().resolveMessage("gui.areatours.sortOrder.manual", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("gui.areatours.sortOrder.optimal", new Serializable[0])};
        return columnHeader;
    }

    private void setTableStyle(JTable table) {
        table.setCellSelectionEnabled(false);
        table.setRowHeight(25);
        table.setRowMargin(5);
        table.getColumnModel().getColumn(0).setPreferredWidth(500);
        table.getColumnModel().getColumn(1).setPreferredWidth(300);
        table.getColumnModel().getColumn(2).setPreferredWidth(300);
        table.getColumnModel().getColumn(3).setPreferredWidth(400);
        table.getColumnModel().getColumn(4).setPreferredWidth(400);
        MultiLineHeaderRenderer headerHenderer = new MultiLineHeaderRenderer();
        AbstractTableRenderer cellRenderer = new AbstractTableRenderer(){

            @Override
            protected String getString(Object value) {
                String s = null;
                if (value == null) {
                    s = "";
                } else if (value instanceof AreaObjectLogisticTourMapNode) {
                    AreaObjectModel area = value == null ? null : ((AreaObjectLogisticTourMapNode)value).getAreaObject();
                    s = area == null ? "" : AreaObjectModelUtil.getShortcutAndDisplayname(area);
                } else {
                    s = value instanceof DeliveryRoundModel ? ((DeliveryRoundModel)value).getName() : value.toString();
                }
                return s;
            }
        };
        int col = 0;
        Enumeration<TableColumn> enumeration = table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setHeaderRenderer(headerHenderer);
            if (col != 3 && col != 4) {
                tableColumn.setCellRenderer(cellRenderer);
            }
            ++col;
        }
        JTableHeader th = table.getTableHeader();
        th.setLayout(new TableHeaderWithComponentLayout());
        JCheckBox forManualAll = new JCheckBox(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.all", new Serializable[0])){
            private static final long serialVersionUID = -7733577823032674842L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SavingSortOrderDialog.this.selectAll(3, ((JCheckBox)e.getSource()).isSelected());
            }
        });
        forManualAll.setFont(UIManager.getFont("TextField.font"));
        th.add((Component)forManualAll, (Object)3);
        JCheckBox forOptimalAll = new JCheckBox(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.all", new Serializable[0])){
            private static final long serialVersionUID = 6437089553389668409L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SavingSortOrderDialog.this.selectAll(4, ((JCheckBox)e.getSource()).isSelected());
            }
        });
        forOptimalAll.setFont(UIManager.getFont("TextField.font"));
        th.add((Component)forOptimalAll, (Object)4);
    }

    private void selectAll(int column, boolean selected) {
        for (int row = 0; row < this.tableModel.getRowCount(); ++row) {
            this.tableModel.setValueAt(selected, row, column);
        }
        this.tableModel.fireTableDataChanged();
    }

    public static void createAndShow(List<AreaObjectLogisticTourMapNode> nodes, ModelEnviroment modelEnviroment, Window parent) {
        SavingSortOrderDialog dialog = new SavingSortOrderDialog(nodes, modelEnviroment, parent);
        dialog.setVisible(true);
    }
}

