/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.gui.legend;

import de.datomino.peppergis.areamanager.gui.AreaManagerMapGui;
import de.datomino.peppergis.areamanager.gui.legend.AreaObjectTourMapNode;
import de.datomino.peppergis.client.manager.legend.AreaObjectTourLegendType;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public class AreaObjectMapNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = -2354960571582790759L;
    private List<AreaObjectTourMapNode<?>> tourNodes = new ArrayList();
    private Color color;
    private int sortOrder;

    public AreaObjectMapNode(AreaObjectModel areaObject) {
        super(areaObject);
    }

    public AreaObjectModel getAreaObject() {
        return (AreaObjectModel)super.getUserObject();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }

    public List<AreaObjectTourMapNode<?>> getTourNodes() {
        return this.tourNodes;
    }

    public void addTourNodes(AreaObjectTourMapNode<?> tourNode, AreaManagerMapGui areaManagerMap) {
        if (tourNode == null) {
            return;
        }
        AreaObjectTourMapNode<?> duplicate = null;
        for (AreaObjectTourMapNode<?> n : this.tourNodes) {
            if (n.getType() == AreaObjectTourLegendType.HISTORY) {
                if (!n.getUserObject().equals(tourNode.getUserObject())) continue;
                duplicate = n;
                continue;
            }
            if (n.getType() != tourNode.getType()) continue;
            duplicate = n;
            break;
        }
        if (duplicate != null) {
            areaManagerMap.removeRenderer(duplicate.getAllObjectFilterLayerRenderer());
            this.tourNodes.remove(duplicate);
        }
        this.tourNodes.add(tourNode);
        areaManagerMap.addRenderer(tourNode.getAllObjectFilterLayerRenderer());
        Collections.sort(this.tourNodes, new Comparator<AreaObjectTourMapNode<?>>(){

            @Override
            public int compare(AreaObjectTourMapNode<?> o1, AreaObjectTourMapNode<?> o2) {
                AreaObjectTourLegendType t1 = o1.getType();
                AreaObjectTourLegendType t2 = o2.getType();
                return Integer.compare(t1.getSortOrder(), t2.getSortOrder());
            }
        });
        this.removeAllChildren();
        for (AreaObjectTourMapNode<?> n : this.tourNodes) {
            this.add(n);
        }
    }
}

