/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.gui;

import de.datomino.peppergis.areamanager.gui.legend.AreaStopNode;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.ktde.util.datatypes.Tupel;

public class AreaTreeLegendReorderingListener
implements TreeModelListener {
    private DefaultTreeModel areaLegendTreeModel;

    public AreaTreeLegendReorderingListener(DefaultTreeModel areaLegendTreeModel) {
        this.areaLegendTreeModel = areaLegendTreeModel;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        this.reorder(e);
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        this.reorder(e);
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        this.reorder(e);
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        this.reorder(e);
    }

    private void reorder(TreeModelEvent e) {
        Collection<List<AreaStopNode<?>>> areaStopNodes = this.getAreaStopNodes();
        for (List<AreaStopNode<?>> list : areaStopNodes) {
            this.setColorsForReordering(list);
        }
    }

    private void setColorsForReordering(List<AreaStopNode<?>> list) {
        if (!list.isEmpty()) {
            boolean alter;
            Integer lowestIndex = null;
            for (AreaStopNode<?> areaStopNode : list) {
                Integer order = areaStopNode.getOrder();
                if (order == null) continue;
                if (lowestIndex == null) {
                    lowestIndex = order;
                    continue;
                }
                lowestIndex = Math.min(order, lowestIndex);
            }
            LinkedList sequences = new LinkedList();
            Iterator<AreaStopNode<?>> iter = list.iterator();
            LinkedList subList = new LinkedList();
            AreaStopNode<?> last = iter.next();
            subList.add(last);
            while (iter.hasNext()) {
                AreaStopNode<?> next = iter.next();
                if (next.getOrder() != last.getOrder() + 1) {
                    sequences.add(new Tupel(subList, false));
                    subList = new LinkedList();
                }
                subList.add(next);
                last = next;
            }
            sequences.add(new Tupel(subList, false));
            ListIterator tIter = sequences.listIterator();
            Tupel pred = (Tupel)tIter.next();
            if (((AreaStopNode)((List)pred.getElement1()).get(0)).getOrder() != (lowestIndex == null ? 1 : lowestIndex)) {
                pred.setElement2(true);
            }
            int oddCount = 0;
            int evenCount = 0;
            boolean odd = true;
            while (tIter.hasNext()) {
                int nextSize = ((List)((Tupel)tIter.next()).getElement1()).size();
                if (odd) {
                    oddCount += nextSize;
                } else {
                    evenCount += nextSize;
                }
                odd = !odd;
            }
            tIter = sequences.listIterator();
            tIter.next();
            boolean bl = alter = oddCount < evenCount;
            while (tIter.hasNext()) {
                Tupel next = (Tupel)tIter.next();
                next.setElement2(alter);
                pred = next;
                alter = !alter;
            }
            for (Tupel tupel : sequences) {
                boolean b = (Boolean)tupel.getElement2();
                for (AreaStopNode areaStopNode : (List)tupel.getElement1()) {
                    areaStopNode.setColor(b ? Color.ORANGE : Color.BLACK);
                }
            }
        }
    }

    private boolean existsHigher(Set<Integer> orders, int orderPointer) {
        for (Integer order : orders) {
            if (order <= orderPointer) continue;
            return true;
        }
        return false;
    }

    private Collection<List<AreaStopNode<?>>> getAreaStopNodes() {
        LinkedList result = new LinkedList();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.areaLegendTreeModel.getRoot();
        result.addAll(this.getAreaStopNodes(root));
        return result;
    }

    private Collection<List<AreaStopNode<?>>> getAreaStopNodes(DefaultMutableTreeNode node) {
        LinkedList result = new LinkedList();
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            if (child instanceof AreaStopNode) {
                return Collections.singletonList(this.getAreaStopNodeList((AreaStopNode)child));
            }
            Collection<List<AreaStopNode<?>>> areaStopNodes = this.getAreaStopNodes(child);
            result.addAll(areaStopNodes);
        }
        return result;
    }

    private List<AreaStopNode<?>> getAreaStopNodeList(AreaStopNode<?> areaStopNode) {
        LinkedList stopNodes = new LinkedList();
        stopNodes.add(areaStopNode);
        for (DefaultMutableTreeNode nextSibling = areaStopNode.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
            if (!(nextSibling instanceof AreaStopNode)) continue;
            stopNodes.add((AreaStopNode)nextSibling);
        }
        return stopNodes;
    }
}

