/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.gui;

import de.datomino.peppergis.areamanager.util.AreaScheduleEntity;
import de.datomino.peppergis.areamanager.util.AreaTourScheduleModelUtil;
import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.AbstractTableRenderer;
import de.datomino.peppergis.client.gui.renderer.MultiLineHeaderRenderer;
import de.datomino.peppergis.client.model.tour.AreaStopModel;
import de.datomino.peppergis.client.model.tour.AreaTourScheduleModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaStopModel;
import de.datomino.peppergis.client.util.AreaStopModelUtil;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.wage.HistoryAreaTourModelWageResult;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.swing.SwingUtils;
import de.datomino.util.time.TimeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.apache.commons.lang.time.DateUtils;
import org.ktde.swing.navigator.DefaultMouseManipulator;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.util.datatypes.Tupel;

public class AreaTourScheduleDialog
extends CommonDialog {
    private static final long serialVersionUID = 7524731702080390012L;
    private static final int TABLECOLCOUNT = 5;
    private JSpinner plannedTime;
    private ModelEnviroment modelEnviroment;
    private boolean editable;
    private List<Tupel<AreaTourScheduleModel, HistoryAreaTourModelWageResult>> list;
    private int currentIndex = 0;

    public AreaTourScheduleDialog(Component parent, List<Tupel<AreaTourScheduleModel, HistoryAreaTourModelWageResult>> list, ModelEnviroment modelEnviroment, boolean editable) {
        super(parent, AreaTourScheduleModelUtil.getDisplayForLegend(list.get(0).getElement1()), Dialog.ModalityType.APPLICATION_MODAL, true);
        this.list = list;
        this.modelEnviroment = modelEnviroment;
        this.editable = editable;
        super.buildLayout();
        if (this.list.size() > 1) {
            this.add((Component)this.createControlPanel(), "First");
        }
        super.pack();
        super.setSize(1000, 800);
        SwingUtils.center((Window)this, super.getParent());
    }

    private JPanel createControlPanel() {
        JPanel controlPanel = new JPanel(new FlowLayout());
        BasicArrowButton leftButton = new BasicArrowButton(7);
        leftButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        leftButton.setAction(new AbstractAction(){
            private static final long serialVersionUID = -1185768197035957154L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AreaTourScheduleDialog.this.next(-1);
            }
        });
        controlPanel.add(leftButton);
        JLabel indexLabel = new JLabel(this.currentIndex + 1 + "/" + this.list.size());
        controlPanel.add(indexLabel);
        BasicArrowButton rightButton = new BasicArrowButton(3);
        rightButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        rightButton.setAction(new AbstractAction(){
            private static final long serialVersionUID = -2166465787519311732L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AreaTourScheduleDialog.this.next(1);
            }
        });
        controlPanel.add(rightButton);
        return controlPanel;
    }

    private void next(int step) {
        this.currentIndex += step;
        if (this.currentIndex < 0) {
            this.currentIndex = this.list.size() - 1;
        } else if (this.currentIndex > this.list.size() - 1) {
            this.currentIndex = 0;
        }
        this.getContentPane().removeAll();
        this.buildLayout();
        this.add((Component)this.createControlPanel(), "First");
        this.pack();
    }

    public static void createAndShow(AreaScheduleEntity schedule, Component parent, ModelEnviroment modelEnviroment, boolean editable) {
        AreaTourScheduleDialog dialog = new AreaTourScheduleDialog(parent, new ArrayList<Tupel<AreaTourScheduleModel, HistoryAreaTourModelWageResult>>(schedule.getAllElements().values()), modelEnviroment, editable);
        dialog.setVisible(true);
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = 5737729182076620581L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AreaTourScheduleDialog.this.store();
                AreaTourScheduleDialog.this.dispose();
            }
        };
    }

    @Override
    protected Action getCancelAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = 5737729182076620581L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AreaTourScheduleDialog.this.dispose();
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        Box infoBox = Box.createVerticalBox();
        infoBox.setAlignmentY(0.0f);
        AreaTourScheduleModelUtil.loadInfoBox(infoBox, this.list.get(this.currentIndex).getElement2());
        JPanel timePane = new JPanel(new FlowLayout());
        JLabel plannedTimeLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.plannedStartTime", new Serializable[0]) + ": ");
        plannedTimeLabel.setFont(UIManager.getDefaults().getFont("TextField.font"));
        timePane.add(plannedTimeLabel);
        Calendar c = Calendar.getInstance();
        AreaTourScheduleModel schedule = this.list.get(this.currentIndex).getElement1();
        if (schedule != null && schedule.getPlannedStartTime() != null) {
            c.setTime(schedule.getPlannedStartTime());
        }
        Date start = TimeUtil.normalize(c.getTime());
        Date end = TimeUtil.setTime(c.getTime(), 23, 59, 59);
        this.plannedTime = new JSpinner(new SpinnerDateModel(c.getTime(), start, end, 5));
        JSpinner.DateEditor timeEditor = new JSpinner.DateEditor(this.plannedTime, FormUtil.TIMEFORMAT);
        this.plannedTime.setEditor(timeEditor);
        ClientSwingUtil.setSpinnerEnable(this.plannedTime, this.editable);
        timePane.add(this.plannedTime);
        JPanel infoPane = new JPanel(new BorderLayout());
        infoPane.add((Component)infoBox, "North");
        infoPane.add((Component)timePane, "West");
        DefaultTableModel areaStopTableModel = new DefaultTableModel(){
            private static final long serialVersionUID = 4992703138654908180L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        areaStopTableModel.setDataVector(this.createDataVector(), this.createColumnHeader());
        final JTable areaStopsTable = new JTable(areaStopTableModel);
        areaStopsTable.addMouseListener(new DefaultMouseManipulator(){

            @Override
            public void mouseClickFinished(int x, int y, int clickCount, int modifiers, MouseButton mouseButton) {
                if (mouseButton == MouseButton.BUTTON1 && clickCount == 2) {
                    Point point = new Point(x, y);
                    int row = areaStopsTable.rowAtPoint(point);
                    Tupel tupel = (Tupel)areaStopsTable.getValueAt(row, 0);
                    AreaStopModelUtil.createAndShowDialog((AreaStopModel)tupel.getElement2(), AreaTourScheduleDialog.this.modelEnviroment, SwingUtils.findWindowParent(AreaTourScheduleDialog.this));
                }
                areaStopsTable.clearSelection();
            }
        });
        this.setAreaStopsTableStyle(areaStopsTable);
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)infoPane, "North");
        pane.add((Component)new JScrollPane(areaStopsTable), "Center");
        return pane;
    }

    private void setAreaStopsTableStyle(JTable areaStopsTable) {
        areaStopsTable.setCellSelectionEnabled(false);
        areaStopsTable.setRowHeight(40);
        areaStopsTable.setRowMargin(5);
        areaStopsTable.getColumnModel().getColumn(0).setPreferredWidth(80);
        areaStopsTable.getColumnModel().getColumn(1).setPreferredWidth(130);
        areaStopsTable.getColumnModel().getColumn(2).setPreferredWidth(140);
        areaStopsTable.getColumnModel().getColumn(3).setPreferredWidth(100);
        areaStopsTable.getColumnModel().getColumn(4).setPreferredWidth(400);
        areaStopsTable.getColumnModel().getColumn(5).setPreferredWidth(250);
        areaStopsTable.getColumnModel().getColumn(6).setPreferredWidth(100);
        MultiLineHeaderRenderer headerHenderer = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = areaStopsTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setHeaderRenderer(headerHenderer);
            tableColumn.setCellRenderer(new AbstractTableRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JTextField textField = new JTextField(value == null ? "" : value.toString());
                    if (column == 0 && value instanceof Tupel) {
                        textField.setText(((String)((Tupel)value).getElement1()).toString());
                    }
                    textField.setFont(table.getFont());
                    textField.setBorder(BorderFactory.createEmptyBorder());
                    if (column == 0) {
                        textField.setHorizontalAlignment(0);
                    }
                    return textField;
                }
            });
        }
    }

    private Object[][] createDataVector() {
        AreaTourScheduleModel schedule = this.list.get(this.currentIndex).getElement1();
        Date startTime = schedule == null || schedule.getPlannedStartTime() == null ? new Date() : schedule.getPlannedStartTime();
        HistoryAreaTourModelWageResult historyResult = this.list.get(this.currentIndex).getElement2();
        if (historyResult == null) {
            return new Object[0][5];
        }
        Object[][] dataVector = new Object[historyResult.getModel().countHistoryAreaTourStop()][5];
        int index = 0;
        Iterator<HistoryAreaStopModel> stopIter = historyResult.getModel().iterateHistoryAreaTourStop();
        while (stopIter.hasNext()) {
            HistoryAreaStopModel stop = stopIter.next();
            Date arrivedTime = DateUtils.addSeconds(startTime, Math.round(stop.getSecondsFromStart().intValue()));
            dataVector[index] = this.createRow(stop, index, arrivedTime);
            ++index;
        }
        return dataVector;
    }

    private Object[] createRow(HistoryAreaStopModel areaStop, int row, Date timeOfArrival) {
        Object[] rowData = new Object[5];
        if (areaStop == null) {
            return rowData;
        }
        rowData[0] = new Tupel<String, HistoryAreaStopModel>(String.valueOf(areaStop.getSortOrder() + 1), areaStop);
        rowData[1] = ClientFormUtil.getNumberString(areaStop.getMetersFromStart());
        Object object = rowData[2] = areaStop.getSecondsFromStart() == null ? "0" : areaStop.getSecondsFromStart().toString();
        if (timeOfArrival == null) {
            rowData[3] = "";
        } else {
            Integer duration = areaStop.getEstimatedDurationSeconds();
            if (duration == null) {
                duration = 0;
            }
            Date leaveTime = DateUtils.addSeconds(timeOfArrival, duration);
            rowData[3] = String.valueOf(ClientFormUtil.dateToString(timeOfArrival) + " - " + FormUtil.timeToString(leaveTime));
        }
        rowData[4] = ClientFormUtil.getNumberString(areaStop.getSortOrder());
        return rowData;
    }

    private String[] createColumnHeader() {
        String[] columnHeader = new String[]{" \n#\n \n", this.getFormatedString(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.distance", new Serializable[0])), this.getFormatedString(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.duration", new Serializable[0]) + "(hh:mm:ss)"), this.getFormatedString(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.estimatedTime", new Serializable[0])), this.getFormatedString(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.sortOrder", new Serializable[0]))};
        return columnHeader;
    }

    private String getFormatedString(String string) {
        return " \n" + string + "\n \n";
    }

    private void store() {
        if (this.editable) {
            Date newPlannedTime = (Date)this.plannedTime.getValue();
            AreaTourScheduleModel schedule = this.list.get(this.currentIndex).getElement1();
            if (schedule != null && !newPlannedTime.equals(schedule.getPlannedStartTime())) {
                this.modelEnviroment.getUndoManager().startTransaction();
                schedule.setPlannedStartTime(newPlannedTime);
                this.modelEnviroment.getUndoManager().finishTransaction("Neue Abfahrtszeit - " + AreaTourScheduleModelUtil.getDisplayForLegend(schedule));
            }
        }
    }
}

