/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.gui;

import de.datomino.peppergis.PeppergisConstants;
import de.datomino.peppergis.areamanager.gui.AreaManagerCalendarGui;
import de.datomino.peppergis.areamanager.model.AreaScheduleTimeBucketModel;
import de.datomino.peppergis.areamanager.util.AreaScheduleEntity;
import de.datomino.peppergis.areamanager.util.AreaTourScheduleModelUtil;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.map.RendererNode;
import de.datomino.peppergis.client.gui.renderer.AbstractTableRenderer;
import de.datomino.peppergis.client.manager.AbstractWeekPlanTable;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.DeliveryRoundRelationModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.model.tour.AreaTourScheduleModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.DelivererModelUtil;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.client.util.wage.HistoryAreaTourModelWageResult;
import de.datomino.util.time.TimeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class AreaSchedulePlanTable
extends AbstractWeekPlanTable<AreaScheduleEntity> {
    private AreaManagerCalendarGui areaManager;
    private Map<AreaObjectModel, Collection<AreaScheduleEntity>> scheduleMap;
    private List<AreaObjectModel> filteredAreaObjects = new ArrayList<AreaObjectModel>();
    private Map<AreaDelivererModel, Map<Date, Double>> salaryForecastMap = new HashMap<AreaDelivererModel, Map<Date, Double>>();

    public AreaSchedulePlanTable(AreaManagerCalendarGui areaManager) {
        this.areaManager = areaManager;
    }

    @Override
    public JComponent createPlanPane(String title, int rowCount) {
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)super.createPlanPane(title, rowCount), "Center");
        return pane;
    }

    @Override
    public void createPlanTable() {
        super.clearSelectedObjects();
        this.loadValues(this.areaManager.getCalendarGui().getCurrentDate());
        this.setRowCount(this.filteredAreaObjects.size());
        int maxCellRowCount = Integer.MIN_VALUE;
        for (Collection<AreaScheduleEntity> entities : this.scheduleMap.values()) {
            for (AreaScheduleEntity entity : entities) {
                int size = entity.getRoundRels().size();
                maxCellRowCount = Math.max(size, maxCellRowCount);
            }
        }
        this.setRowHeight(maxCellRowCount * 2);
        super.createPlanTable();
    }

    private void loadValues(Date currentDate) {
        Tupel<Date, Date> weekTupel = TimeUtil.getWeekTupel(currentDate);
        this.scheduleMap = this.areaManager.getScheduleBucketModel().findObjects(this.areaManager.getAreaObjects(), weekTupel.getElement1(), weekTupel.getElement2(), true);
        this.filteredAreaObjects = new ArrayList<AreaObjectModel>(this.scheduleMap.keySet());
        Collections.sort(this.filteredAreaObjects, new Comparator<AreaObjectModel>(){

            @Override
            public int compare(AreaObjectModel o1, AreaObjectModel o2) {
                String s1 = o1.getShortcut();
                String s2 = o2.getShortcut();
                return StringUtil.getNotNull(s1).compareTo(StringUtil.getNotNull(s2));
            }
        });
    }

    @Override
    protected void addContentToTable() {
        int rowIndex = 0;
        for (AreaObjectModel areaObject : this.filteredAreaObjects) {
            this.planTable.getModel().setValueAt(areaObject, rowIndex, 0);
            Collection<AreaScheduleEntity> schedules = this.scheduleMap.get(areaObject);
            if (schedules != null && !schedules.isEmpty()) {
                for (AreaScheduleEntity schedule : schedules) {
                    int colIndex = super.getColumnIndex(schedule.getDate());
                    this.planTable.getModel().setValueAt(schedule, rowIndex, colIndex);
                }
            }
            ++rowIndex;
        }
    }

    private Object toDisplayString(Object o) {
        Object s = "";
        if (o != null) {
            s = o instanceof AreaObjectModel ? AreaObjectModelUtil.getShortcutAndDisplayname((AreaObjectModel)o) : (o instanceof AreaScheduleEntity ? this.getDisplayForTable((AreaScheduleEntity)o, this.areaManager.getScheduleBucketModel(), false) : o.toString());
        }
        return s;
    }

    /*
     * WARNING - void declaration
     */
    private List<RendererNode> getDisplayForTable(AreaScheduleEntity entity, AreaScheduleTimeBucketModel bucket, boolean detail) {
        ArrayList<RendererNode> list = new ArrayList<RendererNode>();
        Collection<AreaTourScheduleModel> model = entity.getModel();
        if (detail) {
            String s = AreaTourScheduleModelUtil.AREA_SCHEDULE_CELL_PATTERN;
            AreaTourScheduleModel schedule = model.iterator().next();
            AreaObjectModel areaObject = schedule.getAreaObject();
            s = s.replace("%%%shortcut%%%", areaObject.getShortcut());
            s = s.replace("%%%displayname%%%", areaObject.getDisplayname());
            AreaDelivererModel deliverer = schedule.getDeliverer();
            s = s.replace("%%%deliverer_number%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.deliverer.deliverer1", new Serializable[0]) + ": " + (deliverer == null ? "" : deliverer.getDelivererNumber()));
            s = s.replace("%%%deliverer_name%%%", deliverer.getName());
            s = s.replace("%%%plannedStartTime%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.plannedStartTime", new Serializable[0]) + ": " + (schedule == null ? "" : ClientFormUtil.dateToString(schedule.getPlannedStartTime())));
            HistoryAreaTourModelWageResult historyResult = entity.getHistoryResult().isEmpty() ? null : entity.getHistoryResult().iterator().next();
            HistoryAreaTourModel history = historyResult == null ? null : historyResult.getModel();
            s = s.replace("%%%distance%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.areatour.length", new Serializable[0]) + ": " + (history == null ? "" : ClientFormUtil.getNumberString(history.getLength())));
            String durationString = historyResult == null ? "" : TimeUtil.formatDurationSeparated((long)(historyResult.getTimeSum() * 1000.0));
            s = s.replace("%%%duration%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.duration", new Serializable[0]) + ": " + durationString);
            s = s.replace("%%%sum%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.numberOfAreaStops", new Serializable[0]) + ": " + (history == null ? "" : ClientFormUtil.getNumberString(history.getStopCount())));
            String string = history == null ? "" : ModelEnviroment.getMessageResolver().resolveMessageForEnum(history.getParameter().getAreaTourType().getAreaObjectType()) + "/" + ModelEnviroment.getMessageResolver().resolveMessageForEnum(history.getParameter().getAreaTourType().getAreaCalculationType());
            if ((s = s.replace("%%%type%%%", ModelEnviroment.getMessageResolver().resolveMessage("messages.default.type", new Serializable[0]) + ": " + string)).contains("%%%timeSumTillDay%%%")) {
                Double timeSum = this.getTimeSum(bucket, schedule);
                String timeSumString = timeSum == null ? "0" : TimeUtil.formatDurationSeparated((long)(timeSum * 1000.0));
                s = s.replace("%%%timeSumTillDay%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.timeSumTillDay", new Serializable[0]) + ": " + timeSumString);
            }
            list.add(new RendererNode(s, null, 0.0));
        } else {
            Collection<HistoryAreaTourModelWageResult> historyResults = entity.getHistoryResult();
            for (DeliveryRoundRelationModel rel : entity.getRoundRels()) {
                if (rel == null) continue;
                DeliveryRoundModel dr = rel.getDeliveryRound();
                String line = dr.getName();
                AreaTourScheduleModel foundSchedule = null;
                for (AreaTourScheduleModel areaTourScheduleModel : model) {
                    if (!rel.equals(areaTourScheduleModel.getDeliveryRound())) continue;
                    foundSchedule = areaTourScheduleModel;
                    line = AreaTourScheduleModelUtil.getDisplayForTable(foundSchedule, "\n");
                    break;
                }
                HistoryAreaTourModelWageResult foundHistory = null;
                for (HistoryAreaTourModelWageResult result : historyResults) {
                    String deliveryRound = result.getModel().getDeliveryRound();
                    if (!dr.getName().equals(deliveryRound)) continue;
                    foundHistory = result;
                    break;
                }
                Color color = PeppergisConstants.SERVICE_ALL_DONE_COLOR;
                if (foundSchedule == null && foundHistory == null) {
                    Color color2 = PeppergisConstants.SERVICE_OPEN_COLOR;
                } else if (foundSchedule == null && foundHistory != null) {
                    Color color3 = PeppergisConstants.SERVICE_CURRENT_COLOR;
                } else if (foundSchedule != null && foundHistory == null) {
                    Color color4 = PeppergisConstants.SERVICE_NOT_DONE_COLOR;
                } else if (!foundSchedule.getDeliverer().equals(foundHistory.getModel().getDeliverer())) {
                    Color color5 = PeppergisConstants.SERVICE_PARTIALLY_DONE_COLOR;
                }
                if (line == null) continue;
                for (String s : line.split("\n")) {
                    void var13_21;
                    RendererNode node = new RendererNode(s, null, (Color)var13_21, (Color)var13_21, 0.0);
                    node.setIcon(this.getIcon(foundSchedule, entity));
                    list.add(node);
                }
            }
        }
        return list;
    }

    private Double getTimeSum(AreaScheduleTimeBucketModel bucket, AreaTourScheduleModel schedule) {
        AreaDelivererModel deliverer = schedule.getDeliverer();
        if (deliverer == null) {
            return null;
        }
        Date startTime = schedule.getPlannedStartTime();
        Calendar cal = Calendar.getInstance();
        cal.setTime(startTime);
        Integer year = cal.get(1);
        Integer month = cal.get(2);
        Date startSearch = TimeUtil.createDate(year, month, 1, 0, 0, 0);
        Date endSearch = TimeUtil.createDate(year, month, cal.get(5), 23, 59, 59);
        Map<AreaObjectModel, Collection<AreaScheduleEntity>> map = bucket.findObjects(startSearch, endSearch, false);
        double timeSum = 0.0;
        for (Collection<AreaScheduleEntity> entities : map.values()) {
            for (AreaScheduleEntity entity : entities) {
                for (Tupel<AreaTourScheduleModel, HistoryAreaTourModelWageResult> tupel : entity.getAllElements().values()) {
                    HistoryAreaTourModelWageResult result;
                    AreaTourScheduleModel areaTourScheduleModel = tupel.getElement1();
                    if (areaTourScheduleModel == null || !new EqualsBuilder().append(deliverer, areaTourScheduleModel.getDeliverer()).isEquals() || (result = tupel.getElement2()) == null) continue;
                    timeSum += result.getTimeSum();
                }
            }
        }
        return timeSum;
    }

    @Override
    protected TableCellRenderer getTableCellRenderer() {
        return new AbstractTableRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JList list = this.createJList(AreaSchedulePlanTable.this.toDisplayString(value), 2, table.getFont(), null);
                list.setBorder(BorderFactory.createEmptyBorder());
                if (AreaSchedulePlanTable.this.getSelectedObjects().containsValue(new Tupel<Integer, Integer>(row, column))) {
                    list.setBackground(Color.YELLOW);
                }
                return list;
            }
        };
    }

    private Icon getIcon(AreaTourScheduleModel schedule, AreaScheduleEntity entity) {
        Date plannedStartTime;
        Icon icon = null;
        if (schedule == null || entity == null) {
            return icon;
        }
        AreaDelivererModel deliverer = schedule.getDeliverer();
        Double currentMaxSalary = DelivererModelUtil.getMaxSalary(deliverer, plannedStartTime = schedule.getPlannedStartTime());
        if (currentMaxSalary != null) {
            Date firstMonthDate;
            Double salaryForecast;
            Map<Date, Double> dateMap = this.salaryForecastMap.get(deliverer);
            if (dateMap == null) {
                dateMap = new HashMap<Date, Double>();
                this.salaryForecastMap.put(deliverer, dateMap);
            }
            if ((salaryForecast = dateMap.get(firstMonthDate = TimeUtil.getMonthTupel(plannedStartTime).getElement1())) == null) {
                boolean forecast = StringUtil.isTrue(ModelEnviroment.getProperties().getProperty("areaSchedule.deliverer.salaryForecast.active"));
                salaryForecast = AreaTourScheduleModelUtil.calculateSalary(deliverer, plannedStartTime, this.areaManager.getScheduleBucketModel(), forecast);
                dateMap.put(firstMonthDate, salaryForecast);
            }
            if (salaryForecast > currentMaxSalary) {
                icon = TourModelUtil.RED_EURO_ICON;
            }
        }
        return icon;
    }

    private Color getTextColor(Object o, int column) {
        AreaDelivererModel deliverer = null;
        Date date = null;
        if (o instanceof AreaScheduleEntity) {
            AreaScheduleEntity schedule = (AreaScheduleEntity)o;
            deliverer = schedule.getModel().isEmpty() ? null : schedule.getModel().iterator().next().getDeliverer();
            date = super.getDateFromColumn(column);
        }
        return DelivererModelUtil.determineColor(deliverer, date);
    }

    public Collection<AreaScheduleEntity> getAllEntities() {
        Collection<Collection<AreaScheduleEntity>> values = this.scheduleMap.values();
        LinkedList<AreaScheduleEntity> list = new LinkedList<AreaScheduleEntity>();
        for (Collection<AreaScheduleEntity> col : values) {
            list.addAll(col);
        }
        return list;
    }

    public Map<AreaDelivererModel, Map<Date, Double>> getSalaryForecastMap() {
        return this.salaryForecastMap;
    }
}

