/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.gui;

import de.datomino.peppergis.areamanager.gui.legend.AreaStopAttributeNode;
import de.datomino.peppergis.areamanager.gui.legend.AreaStopNode;
import de.datomino.peppergis.areamanager.gui.legend.schedule.AreaTourScheduleAttributeNode;
import de.datomino.peppergis.areamanager.gui.legend.schedule.AreaTourScheduleNode;
import de.datomino.peppergis.areamanager.gui.legend.schedule.DeliveryRoundNode;
import de.datomino.peppergis.areamanager.gui.legend.schedule.HistoryAreaStopNode;
import de.datomino.peppergis.areamanager.util.AreaTourScheduleModelUtil;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.tour.AreaStopModel;
import de.datomino.peppergis.client.model.tour.AreaTourScheduleModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaStopModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.client.model.wage.WageParameterModel;
import de.datomino.peppergis.client.util.AreaStopModelUtil;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.wage.HistoryAreaTourModelWageResult;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.geo.ImmutablePoint;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.util.StringUtil;

@Deprecated
public class AreaScheduleLegendTreeRenderer
implements TreeCellRenderer {
    DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.renderer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (value != null) {
            if (value instanceof AreaTourScheduleNode) {
                AreaTourScheduleNode node = (AreaTourScheduleNode)value;
                ArrayList<String> list = new ArrayList<String>();
                for (AreaTourScheduleModel schedule : node.getEntity().getModel()) {
                    list.add(AreaTourScheduleModelUtil.getDisplayForLegend(schedule));
                }
                this.renderer.setText(StringUtil.implode(list, "\n"));
                this.renderer.setForeground(node.getColor());
            } else if (value instanceof AreaStopNode) {
                AreaStopNode stopNode = (AreaStopNode)value;
                if (stopNode.getAreaStop() instanceof AreaStopModel) {
                    AreaStopModel stop = (AreaStopModel)stopNode.getAreaStop();
                    String text = stopNode.getOrder() + ": " + stop.getName() + ", ";
                    text = text + AreaStopModelUtil.getAddressString(stop);
                    this.renderer.setText(text);
                    this.renderer.setForeground(stopNode.getColor());
                }
            } else if (!(value instanceof AreaStopAttributeNode)) {
                if (value instanceof HistoryAreaStopNode) {
                    HistoryAreaStopNode stopNode = (HistoryAreaStopNode)value;
                    HistoryAreaStopModel stop = stopNode.getHistoryAreaStopModel();
                    String geomString = ModelEnviroment.getMessageResolver().resolveMessage("gis.coordinate", new Serializable[0]) + " (";
                    if (stop.getLocation() != null) {
                        ImmutablePoint transformed = (ImmutablePoint)stop.getLocation().getTransformed(Wgs84Factory.INSTANCE);
                        geomString = geomString + ClientFormUtil.numberToString(transformed.getX(), 5) + ", " + ClientFormUtil.numberToString(transformed.getY(), 5);
                    } else {
                        geomString = geomString + "0, 0";
                    }
                    geomString = geomString + ")";
                    String text = stopNode.getOrder() + ": " + geomString + ", ";
                    text = text + stop.getMetersFromStart() + ", " + ClientFormUtil.getSecondTimeString(stop.getSecondsFromStart());
                    this.renderer.setText(text);
                    this.renderer.setForeground(stopNode.getColor());
                } else if (value instanceof AreaTourScheduleAttributeNode) {
                    AreaTourScheduleAttributeNode attributeNode = (AreaTourScheduleAttributeNode)value;
                    HistoryAreaTourModelWageResult historyAreaTourModelWageResult = attributeNode.getHistoryAreaTourModelWageResult();
                    HistoryAreaTourModel model = historyAreaTourModelWageResult.getModel();
                    WageParameterModel parameter = model.getParameter();
                    switch (attributeNode.getAreaTourScheduleAttribute()) {
                        case DISTANCE: {
                            int distanceSum = model.getLength() == null ? 0 : model.getLength();
                            this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.length", new Serializable[]{ModelEnviroment.getMessageResolver().getNumberFormat().format(distanceSum)}));
                            break;
                        }
                        case DURATION: {
                            double timeSum = historyAreaTourModelWageResult.getTimeSum();
                            String secondTimeString = FormUtil.getSecondTimeString(timeSum);
                            this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.duration", new Serializable[0]) + ": " + secondTimeString);
                            break;
                        }
                        case DIFFICULTY_LEVEL: {
                            this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("area.attribute.descriptor.difficultyLevel", new Serializable[0]) + ": " + model.getDifficultyLevel());
                            break;
                        }
                        case PARCEL_LOCATION: {
                            this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("area.attribute.descriptor.parcellocation", new Serializable[0]) + ": " + model.getParcelLocation());
                            break;
                        }
                        case TOUR_TYPE: {
                            switch (parameter.getAreaTourType().getAreaObjectType()) {
                                case LETTER: {
                                    this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.letter.letters", new Serializable[0]));
                                    break;
                                }
                                case PARCEL: {
                                    this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.parcels", new Serializable[0]));
                                    break;
                                }
                                case PARCEL_WITH_LETTER: {
                                    this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.parcels", new Serializable[0]) + "/" + ModelEnviroment.getMessageResolver().resolveMessage("messages.letter.letters", new Serializable[0]));
                                    break;
                                }
                                case PARCEL_WITHOUT_SUBSCRIPTION: {
                                    this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.parcels", new Serializable[0]));
                                    break;
                                }
                                case PARCEL_WITHOUT_SUBSCRIPTION_WITH_LETTER: {
                                    this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.parcels", new Serializable[0]) + "/" + ModelEnviroment.getMessageResolver().resolveMessage("messages.letter.letters", new Serializable[0]));
                                    break;
                                }
                                case SUBSCRIPTION: {
                                    this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptions", new Serializable[0]));
                                    break;
                                }
                                case SUBSCRIPTION_WITH_LETTER: {
                                    this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptions", new Serializable[0]) + "/" + ModelEnviroment.getMessageResolver().resolveMessage("messages.letter.letters", new Serializable[0]));
                                    break;
                                }
                                case PARCEL_SUBSCRIPTION: {
                                    this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.parcel.parcels", "messages.subscription.subscriptions"), "/"));
                                    break;
                                }
                                case PARCEL_SUBSCRIPTION_LETTER: {
                                    this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.parcel.parcels", "messages.subscription.subscriptions", "messages.letter.letters"), "/"));
                                }
                            }
                            break;
                        }
                        case VEHICLE_IN_AREA: {
                            String vehicle = ModelEnviroment.getMessageResolver().resolveMessage("gui.areatour.vehicle.area", new Serializable[0]);
                            if (parameter.getVehicelTypeInArea() != null) {
                                vehicle = vehicle + ": " + ModelEnviroment.getMessageResolver().resolveMessageForEnum(parameter.getVehicelTypeInArea());
                            }
                            this.renderer.setText(vehicle);
                            break;
                        }
                        case PREPARE_DURATION: {
                            double receptionTimeSum = historyAreaTourModelWageResult.getReceptionTimeSum();
                            this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.receptionTime", new Serializable[0]) + ": " + FormUtil.getSecondTimeString(receptionTimeSum));
                            break;
                        }
                        case STREET_DURATION: {
                            double streetDuration = model.getDuration().intValue();
                            this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.areatour.duration", new Serializable[0]) + ": " + FormUtil.getSecondTimeString(streetDuration));
                            break;
                        }
                        case THROW_DURATION: {
                            double throwTimeSum = historyAreaTourModelWageResult.getThrowTimeSum();
                            this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.throw", new Serializable[0]) + ": " + FormUtil.getSecondTimeString(throwTimeSum));
                            break;
                        }
                    }
                    this.renderer.setForeground(attributeNode.getColor());
                } else if (value instanceof DeliveryRoundNode) {
                    DeliveryRoundNode deliveryRoundNode = (DeliveryRoundNode)value;
                    String round = deliveryRoundNode.getHistoryAreaTourModelWageResult().getModel().getDeliveryRound();
                    this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("gui.deliveryRound", new Serializable[0]) + ": " + StringUtil.nullToEmpty(round));
                    this.renderer.setForeground(deliveryRoundNode.getColor());
                } else {
                    Object object = ((DefaultMutableTreeNode)value).getUserObject();
                    this.renderer.setText(object.toString());
                    this.renderer.setForeground(Color.BLACK);
                }
            }
        }
        return this.renderer;
    }
}

